/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.AbstractRangerAdminClient;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerPluginCapability;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerServiceNotFoundException;
import org.apache.ranger.plugin.util.RangerSslHelper;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerAdminJersey2RESTClient
extends AbstractRangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminJersey2RESTClient.class);
    boolean _isSSL = false;
    volatile Client _client = null;
    SSLContext _sslContext = null;
    HostnameVerifier _hv;
    String _sslConfigFileName = null;
    String _serviceName = null;
    String _clusterName = null;
    String _supportsPolicyDeltas = null;
    String _supportsTagDeltas = null;
    String _pluginId = null;
    int _restClientConnTimeOutMs;
    int _restClientReadTimeOutMs;
    private int lastKnownActiveUrlIndex;
    private List<String> configURLs;
    private final String pluginCapabilities = Long.toHexString(new RangerPluginCapability().getPluginCapabilities());
    private static final int MAX_PLUGIN_ID_LEN = 255;

    public void init(String serviceName, String appId, String configPropertyPrefix, Configuration config) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + ")"));
        }
        super.init(serviceName, appId, configPropertyPrefix, config);
        this._serviceName = serviceName;
        this._pluginId = this.getPluginId(serviceName, appId);
        String tmpUrl = config.get(configPropertyPrefix + ".policy.rest.url");
        this._sslConfigFileName = config.get(configPropertyPrefix + ".policy.rest.ssl.config.file");
        this._restClientConnTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        this._restClientReadTimeOutMs = config.getInt(configPropertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this._clusterName = config.get(configPropertyPrefix + ".access.cluster.name", "");
        if (StringUtil.isEmpty((String)this._clusterName)) {
            this._clusterName = config.get(configPropertyPrefix + ".ambari.cluster.name", "");
        }
        this._supportsPolicyDeltas = config.get(configPropertyPrefix + ".policy.rest.supports.policy.deltas", "false");
        if (!"true".equalsIgnoreCase(this._supportsPolicyDeltas)) {
            this._supportsPolicyDeltas = "false";
        }
        this._supportsTagDeltas = config.get(configPropertyPrefix + ".tag.rest.supports.tag.deltas", "false");
        if (!"true".equalsIgnoreCase(this._supportsTagDeltas)) {
            this._supportsTagDeltas = "false";
        }
        this.configURLs = StringUtil.getURLs((String)tmpUrl);
        this.lastKnownActiveUrlIndex = new Random().nextInt(this.configURLs.size());
        String url = this.configURLs.get(this.lastKnownActiveUrlIndex);
        this._isSSL = this.isSsl(url);
        LOG.info((Object)("Init params: " + String.format("Base URL[%s], SSL Config filename[%s], ServiceName=[%s], SupportsPolicyDeltas=[%s], ConfigURLs=[%s]", url, this._sslConfigFileName, this._serviceName, this._supportsPolicyDeltas, this._supportsTagDeltas, this.configURLs)));
        this._client = this.getClient();
        this._client.property("jersey.config.client.connectTimeout", (Object)this._restClientConnTimeOutMs);
        this._client.property("jersey.config.client.readTimeout", (Object)this._restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.init(" + configPropertyPrefix + "): " + this._client.toString()));
        }
    }

    public ServicePolicies getServicePoliciesIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        String relativeURL = null;
        ServicePolicies servicePolicies = null;
        Response response = null;
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("clusterName", this._clusterName);
        queryParams.put("supportsPolicyDeltas", this._supportsPolicyDeltas);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service policy if updated as user : " + user));
            }
            final String secureRelativeUrl = relativeURL = "/service/plugins/secure/policies/download/" + this._serviceName;
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, secureRelativeUrl);
                }
            };
            response = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            relativeURL = "/service/plugins/policies/download/" + this._serviceName;
            response = this.get(queryParams, relativeURL);
        }
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Response from 200 server: " + body));
                }
                Gson gson = this.getGson();
                servicePolicies = (ServicePolicies)gson.fromJson(body, ServicePolicies.class);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Deserialized response to: " + servicePolicies));
                break;
            }
            case 304: {
                LOG.debug((Object)"Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn((Object)("Received 404 error code with body:[" + body + "], Ignoring"));
                break;
            }
            default: {
                body = (String)response.readEntity(String.class);
                LOG.warn((Object)String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + servicePolicies));
        }
        return servicePolicies;
    }

    public RangerRoles getRolesIfUpdated(long lastKnowRoleVersion, long lastActivationTimeInMillis) throws Exception {
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.getRolesIfUpdated(" + lastKnowRoleVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        String relativeURL = null;
        RangerRoles ret = null;
        Response response = null;
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownRoleVersion", Long.toString(lastKnowRoleVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("clusterName", this._clusterName);
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Roles if updated as user : " + user));
            }
            final String secureRelativeUrl = relativeURL = "/service/roles/secure/download/" + this._serviceName;
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, secureRelativeUrl);
                }
            };
            response = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Roles if updated with old api call");
            }
            relativeURL = "/service/roles/download/" + this._serviceName;
            response = this.get(queryParams, relativeURL);
        }
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Response from 200 server: " + body));
                }
                Gson gson = this.getGson();
                ret = (RangerRoles)gson.fromJson(body, RangerRoles.class);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Deserialized response to: " + ret));
                break;
            }
            case 304: {
                LOG.debug((Object)"Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while trying to get policies! Returning null!");
                break;
            }
            case 404: {
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn((Object)("Received 404 error code with body:[" + body + "], Ignoring"));
                break;
            }
            default: {
                body = (String)response.readEntity(String.class);
                LOG.warn((Object)String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.getRolesIfUpdated(" + lastKnowRoleVersion + ", " + lastActivationTimeInMillis + "): " + ret));
        }
        return ret;
    }

    public void grantAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this._pluginId);
        String relativeURL = "/service/plugins/services/grant/" + this._serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug((Object)("grantAccess() suceeded: HTTP status=" + httpResponseCode));
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL);
                LOG.warn((Object)message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    public void revokeAccess(GrantRevokeRequest request) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("pluginId", this._pluginId);
        String relativeURL = "/service/plugins/services/revoke/" + this._serviceName;
        Response response = this.get(queryParams, relativeURL);
        int httpResponseCode = response == null ? -1 : response.getStatus();
        switch (httpResponseCode) {
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from policy server while granting access! Returning null!");
                throw new Exception("unknown error!");
            }
            case 200: {
                LOG.debug((Object)("grantAccess() suceeded: HTTP status=" + httpResponseCode));
                break;
            }
            case 401: {
                throw new AccessControlException();
            }
            default: {
                String body = (String)response.readEntity(String.class);
                String message = String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL);
                LOG.warn((Object)message);
                throw new Exception("HTTP status: " + httpResponseCode);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    public ServiceTags getServiceTagsIfUpdated(long lastKnownVersion, long lastActivationTimeInMillis) throws Exception {
        UserGroupInformation user;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + ")"));
        }
        boolean isSecureMode = (user = MiscUtil.getUGILoginUser()) != null && UserGroupInformation.isSecurityEnabled();
        final HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("lastKnownVersion", Long.toString(lastKnownVersion));
        queryParams.put("lastActivationTime", Long.toString(lastActivationTimeInMillis));
        queryParams.put("pluginId", this._pluginId);
        queryParams.put("supportsTagDeltas", this._supportsTagDeltas);
        queryParams.put("pluginCapabilities", this.pluginCapabilities);
        String relativeURL = null;
        ServiceTags serviceTags = null;
        Response response = null;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service tags if updated as user : " + user));
            }
            final String secureRelativeUrl = relativeURL = "/service/tags/secure/download/" + this._serviceName;
            PrivilegedAction<Response> action = new PrivilegedAction<Response>(){

                @Override
                public Response run() {
                    return RangerAdminJersey2RESTClient.this.get(queryParams, secureRelativeUrl);
                }
            };
            response = (Response)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service tags if updated with old api call");
            }
            relativeURL = "/service/tags/download/" + this._serviceName;
            response = this.get(queryParams, relativeURL);
        }
        int httpResponseCode = response == null ? -1 : response.getStatus();
        String body = null;
        switch (httpResponseCode) {
            case 200: {
                body = (String)response.readEntity(String.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Response from 200 server: " + body));
                }
                Gson gson = this.getGson();
                serviceTags = (ServiceTags)gson.fromJson(body, ServiceTags.class);
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Deserialized response to: " + serviceTags));
                break;
            }
            case 304: {
                LOG.debug((Object)"Got response: 304. Ok. Returning null");
                break;
            }
            case -1: {
                LOG.warn((Object)"Unexpected: Null response from tag server while trying to get tags! Returning null!");
                break;
            }
            case 404: {
                if (response.hasEntity() && StringUtils.isNotBlank((String)(body = (String)response.readEntity(String.class)))) {
                    RangerServiceNotFoundException.throwExceptionIfServiceNotFound((String)this._serviceName, (String)body);
                }
                LOG.warn((Object)("Received 404 error code with body:[" + body + "], Ignoring"));
                break;
            }
            default: {
                body = (String)response.readEntity(String.class);
                LOG.warn((Object)String.format("Unexpected: Received status[%d] with body[%s] form url[%s]", httpResponseCode, body, relativeURL));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminJersey2RESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + ", " + lastActivationTimeInMillis + "): " + serviceTags));
        }
        return serviceTags;
    }

    public List<String> getTagTypes(String pattern) throws Exception {
        throw new Exception("RangerAdminjersey2RESTClient.getTagTypes() -- *** NOT IMPLEMENTED *** ");
    }

    Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Date.class, (Object)new GsonUnixDateDeserializer()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Client getClient() {
        Client result = this._client;
        if (result == null) {
            RangerAdminJersey2RESTClient rangerAdminJersey2RESTClient = this;
            synchronized (rangerAdminJersey2RESTClient) {
                result = this._client;
                if (result == null) {
                    this._client = result = this.buildClient();
                }
            }
        }
        return result;
    }

    Client buildClient() {
        if (this._isSSL) {
            if (this._sslContext == null) {
                RangerSslHelper sslHelper = new RangerSslHelper(this._sslConfigFileName);
                this._sslContext = sslHelper.createContext();
            }
            if (this._hv == null) {
                this._hv = new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return session.getPeerHost().equals(urlHostName);
                    }
                };
            }
            this._client = ClientBuilder.newBuilder().sslContext(this._sslContext).hostnameVerifier(this._hv).build();
        }
        if (this._client == null) {
            this._client = ClientBuilder.newClient();
        }
        return this._client;
    }

    private Response get(Map<String, String> queyParams, String relativeURL) {
        Response response = null;
        int startIndex = this.lastKnownActiveUrlIndex;
        int currentIndex = 0;
        for (int index = 0; index < this.configURLs.size(); ++index) {
            try {
                currentIndex = (startIndex + index) % this.configURLs.size();
                WebTarget target = this._client.target(this.configURLs.get(currentIndex) + relativeURL);
                response = RangerAdminJersey2RESTClient.setQueryParams(target, queyParams).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
                if (response == null) continue;
                this.setLastKnownActiveUrlIndex(currentIndex);
                break;
            }
            catch (ProcessingException e) {
                LOG.warn((Object)("Failed to communicate with Ranger Admin, URL : " + this.configURLs.get(currentIndex)));
                if (index != this.configURLs.size() - 1) continue;
                throw new ProcessingException("Failed to communicate with all Ranger Admin's URL : [ " + this.configURLs + " ]", (Throwable)e);
            }
        }
        return response;
    }

    private static WebTarget setQueryParams(WebTarget target, Map<String, String> params) {
        WebTarget ret = target;
        if (target != null && params != null) {
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                ret = ret.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return ret;
    }

    private void setLastKnownActiveUrlIndex(int lastKnownActiveUrlIndex) {
        this.lastKnownActiveUrlIndex = lastKnownActiveUrlIndex;
    }

    private boolean isSsl(String url) {
        return !StringUtils.isEmpty((String)url) && url.toLowerCase().startsWith("https");
    }

    private String getPluginId(String serviceName, String appId) {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"ERROR: Unable to find hostname for the agent ", (Throwable)e);
            hostName = "unknownHost";
        }
        String ret = hostName + "-" + serviceName;
        if (!StringUtils.isEmpty((String)appId)) {
            ret = appId + "@" + ret;
        }
        if (ret.length() > 255) {
            ret = ret.substring(0, 255);
        }
        return ret;
    }

    public static class GsonUnixDateDeserializer
    implements JsonDeserializer<Date> {
        public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new Date(json.getAsJsonPrimitive().getAsLong());
        }
    }
}

