/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceEvaluator;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerResourceTrie<T extends RangerPolicyResourceEvaluator> {
    private static final Log LOG = LogFactory.getLog(RangerResourceTrie.class);
    private static final Log TRACE_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.trace");
    private static final Log PERF_TRIE_INIT_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.init");
    private static final Log PERF_TRIE_OP_LOG = RangerPerfTracer.getPerfLogger("resourcetrie.op");
    private static final String DEFAULT_WILDCARD_CHARS = "*?";
    private static final String TRIE_BUILDER_THREAD_COUNT = "ranger.policyengine.trie.builder.thread.count";
    private final RangerServiceDef.RangerResourceDef resourceDef;
    private final boolean optIgnoreCase;
    private final boolean optWildcard;
    private final String wildcardChars;
    private final TrieNode<T> root;
    private final boolean isOptimizedForRetrieval;

    public RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators) {
        this(resourceDef, evaluators, true, null);
    }

    public RangerResourceTrie(RangerResourceTrie<T> other) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.copyTrie(name=" + other.resourceDef.getName() + ")");
        }
        this.resourceDef = other.resourceDef;
        this.optIgnoreCase = other.optIgnoreCase;
        this.optWildcard = other.optWildcard;
        this.wildcardChars = other.wildcardChars;
        this.isOptimizedForRetrieval = false;
        this.root = this.copyTrieSubtree(other.root, null);
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug((Object)this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.root.toString("", sb);
            TRACE_LOG.trace((Object)("Trie Dump from RangerResourceTrie.copyTrie(name=" + other.resourceDef.getName() + "):\n{" + sb.toString() + "}"));
        }
    }

    RangerResourceTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, boolean isOptimizedForRetrieval, RangerPluginContext pluginContext) {
        int builderThreadCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + isOptimizedForRetrieval + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + resourceDef.getName() + ")");
        }
        RangerPluginConfig config = pluginContext != null ? pluginContext.getConfig() : null;
        int n = builderThreadCount = config != null ? config.getInt(TRIE_BUILDER_THREAD_COUNT, 1) : 1;
        if (builderThreadCount < 1) {
            builderThreadCount = 1;
        }
        if (TRACE_LOG.isTraceEnabled()) {
            TRACE_LOG.trace((Object)("builderThreadCount is set to [" + builderThreadCount + "]"));
        }
        Map<String, String> matcherOptions = resourceDef.getMatcherOptions();
        boolean optReplaceTokens = RangerAbstractResourceMatcher.getOptionReplaceTokens(matcherOptions);
        String tokenReplaceSpecialChars = "";
        if (optReplaceTokens) {
            char delimiterStart = RangerAbstractResourceMatcher.getOptionDelimiterStart(matcherOptions);
            char delimiterEnd = RangerAbstractResourceMatcher.getOptionDelimiterEnd(matcherOptions);
            char delimiterEscape = RangerAbstractResourceMatcher.getOptionDelimiterEscape(matcherOptions);
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterStart;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEnd;
            tokenReplaceSpecialChars = tokenReplaceSpecialChars + delimiterEscape;
        }
        this.resourceDef = resourceDef;
        this.optIgnoreCase = RangerAbstractResourceMatcher.getOptionIgnoreCase(matcherOptions);
        this.optWildcard = RangerAbstractResourceMatcher.getOptionWildCard(matcherOptions);
        this.wildcardChars = this.optWildcard ? DEFAULT_WILDCARD_CHARS + tokenReplaceSpecialChars : "" + tokenReplaceSpecialChars;
        this.isOptimizedForRetrieval = isOptimizedForRetrieval;
        TrieNode<T> tmpRoot = this.buildTrie(resourceDef, evaluators, builderThreadCount);
        this.root = builderThreadCount > 1 && tmpRoot == null ? this.buildTrie(resourceDef, evaluators, 1) : tmpRoot;
        this.wrapUpUpdate();
        RangerPerfTracer.logAlways(perf);
        if (PERF_TRIE_INIT_LOG.isDebugEnabled()) {
            PERF_TRIE_INIT_LOG.debug((Object)this.toString());
        }
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.root.toString("", sb);
            TRACE_LOG.trace((Object)("Trie Dump from RangerResourceTrie.init(name=" + resourceDef.getName() + "):\n{" + sb.toString() + "}"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isOptimizedForRetrieval=" + isOptimizedForRetrieval + "): " + this.toString()));
        }
    }

    public Set<T> getEvaluatorsForResource(Object resource) {
        if (resource instanceof String) {
            return this.getEvaluatorsForResource((String)resource);
        }
        if (resource instanceof Collection) {
            if (CollectionUtils.isEmpty((Collection)((Collection)resource))) {
                return this.getEvaluatorsForResource("");
            }
            Collection resources = (Collection)resource;
            return this.getEvaluatorsForResources(resources);
        }
        return null;
    }

    public void add(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.add(name=" + resource + ")");
        }
        if (resource == null) {
            if (evaluator.isAncestorOf(this.resourceDef)) {
                this.root.addWildcardEvaluator(evaluator);
            }
        } else if (resource.getIsExcludes().booleanValue()) {
            this.root.addWildcardEvaluator(evaluator);
        } else if (CollectionUtils.isNotEmpty(resource.getValues())) {
            for (String value : resource.getValues()) {
                this.insert(this.root, value, resource.getIsRecursive(), evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.root.toString("", sb);
            TRACE_LOG.trace((Object)("Trie Dump from RangerResourceTrie.add(name=" + resource + "):\n{" + sb.toString() + "}"));
        }
    }

    public void delete(RangerPolicy.RangerPolicyResource resource, T evaluator) {
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.delete(name=" + resource + ")");
        }
        boolean isRemoved = false;
        if (resource.getIsExcludes().booleanValue()) {
            isRemoved = this.root.removeWildcardEvaluator(evaluator);
        }
        if (!isRemoved) {
            for (String value : resource.getValues()) {
                TrieNode<T> node = this.getNodeForResource(value);
                if (node == null) continue;
                ((TrieNode)node).removeEvaluatorFromSubtree(evaluator);
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            this.root.toString("", sb);
            TRACE_LOG.trace((Object)("Trie Dump from RangerResourceTrie.delete(name=" + resource + "):\n{" + sb.toString() + "}"));
        }
    }

    public void wrapUpUpdate() {
        if (this.root != null) {
            this.root.wrapUpUpdate();
        }
    }

    TrieNode<T> getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrieNode<T> copyTrieSubtree(TrieNode<T> source, TrieNode<T> parent) {
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            source.toString(sb);
            TRACE_LOG.trace((Object)("==> copyTrieSubtree(" + sb + ")"));
        }
        TrieNode<T> dest = new TrieNode<T>(((TrieNode)source).str);
        dest.setParent(parent);
        Map map = ((TrieNode)source).children;
        synchronized (map) {
            ((TrieNode)dest).isSetup = ((TrieNode)source).isSetup;
            ((TrieNode)dest).isSharingParentWildcardEvaluators = ((TrieNode)source).isSharingParentWildcardEvaluators;
            if (((TrieNode)source).isSharingParentWildcardEvaluators) {
                if (dest.getParent() != null) {
                    ((TrieNode)dest).wildcardEvaluators = dest.getParent().getWildcardEvaluators();
                } else {
                    ((TrieNode)dest).wildcardEvaluators = null;
                }
            } else if (((TrieNode)source).wildcardEvaluators != null) {
                ((TrieNode)dest).wildcardEvaluators = new HashSet(((TrieNode)source).wildcardEvaluators);
            } else {
                ((TrieNode)dest).wildcardEvaluators = null;
            }
            if (((TrieNode)source).evaluators != null) {
                if (((TrieNode)source).evaluators == ((TrieNode)source).wildcardEvaluators) {
                    ((TrieNode)dest).evaluators = ((TrieNode)dest).wildcardEvaluators;
                } else {
                    ((TrieNode)dest).evaluators = new HashSet(((TrieNode)source).evaluators);
                }
            } else {
                ((TrieNode)dest).evaluators = null;
            }
        }
        Map<Character, TrieNode<T>> children = source.getChildren();
        for (Map.Entry<Character, TrieNode<T>> entry : children.entrySet()) {
            this.copyTrieSubtree(entry.getValue(), dest);
        }
        if (TRACE_LOG.isTraceEnabled()) {
            StringBuilder sourceAsString = new StringBuilder();
            StringBuilder destAsString = new StringBuilder();
            source.toString(sourceAsString);
            dest.toString(destAsString);
            TRACE_LOG.trace((Object)("<== copyTrieSubtree(" + sourceAsString + ") : " + destAsString));
        }
        return dest;
    }

    private TrieNode<T> buildTrie(RangerServiceDef.RangerResourceDef resourceDef, List<T> evaluators, int builderThreadCount) {
        HashMap<Character, Integer> builderThreadMap;
        ArrayList<ResourceTrieBuilderThread> builderThreads;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + (builderThreadCount > 1) + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(resourceDef=" + resourceDef.getName() + ")");
        }
        TrieNode<RangerPolicyResourceEvaluator> ret = new TrieNode<RangerPolicyResourceEvaluator>(null);
        boolean isMultiThreaded = builderThreadCount > 1;
        String resourceName = resourceDef.getName();
        int lastUsedThreadIndex = 0;
        if (isMultiThreaded) {
            builderThreads = new ArrayList<ResourceTrieBuilderThread>();
            for (int i = 0; i < builderThreadCount; ++i) {
                ResourceTrieBuilderThread t = new ResourceTrieBuilderThread();
                t.setDaemon(true);
                builderThreads.add(t);
                t.start();
            }
            builderThreadMap = new HashMap<Character, Integer>();
        } else {
            builderThreads = null;
            builderThreadMap = null;
        }
        for (RangerPolicyResourceEvaluator evaluator : evaluators) {
            RangerPolicy.RangerPolicyResource policyResource;
            Map<String, RangerPolicy.RangerPolicyResource> policyResources = evaluator.getPolicyResource();
            RangerPolicy.RangerPolicyResource rangerPolicyResource = policyResource = policyResources != null ? policyResources.get(resourceName) : null;
            if (policyResource == null) {
                if (!evaluator.isAncestorOf(resourceDef)) continue;
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            if (policyResource.getIsExcludes().booleanValue()) {
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            RangerResourceMatcher resourceMatcher = evaluator.getResourceMatcher(resourceName);
            if (resourceMatcher != null && resourceMatcher.isMatchAny()) {
                ret.addWildcardEvaluator(evaluator);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
            for (String resource : policyResource.getValues()) {
                if (!isMultiThreaded) {
                    this.insert(ret, resource, policyResource.getIsRecursive(), evaluator);
                    continue;
                }
                try {
                    lastUsedThreadIndex = this.insert(ret, resource, policyResource.getIsRecursive(), evaluator, builderThreadMap, builderThreads, lastUsedThreadIndex);
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)("Failed to dispatch " + resource + " to " + builderThreads.get(lastUsedThreadIndex)));
                    LOG.error((Object)"Failing and retrying with one thread");
                    ret = null;
                    break;
                }
            }
            if (ret != null) continue;
            break;
        }
        if (ret != null && isMultiThreaded) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    t.add("", false, null);
                    t.join();
                    ret.getChildren().putAll(t.getSubtrees());
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)("BuilderThread " + t + " was interrupted:"), (Throwable)ex);
                    LOG.error((Object)"Failing and retrying with one thread");
                    ret = null;
                    break;
                }
            }
            this.cleanUpThreads(builderThreads);
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== buildTrie(" + resourceDef.getName() + ", evaluatorCount=" + evaluators.size() + ", isMultiThreaded=" + isMultiThreaded + ") :" + ret));
        }
        return ret;
    }

    private void cleanUpThreads(List<ResourceTrieBuilderThread> builderThreads) {
        if (CollectionUtils.isNotEmpty(builderThreads)) {
            for (ResourceTrieBuilderThread t : builderThreads) {
                try {
                    if (!t.isAlive()) continue;
                    t.interrupt();
                    t.join();
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)("Could not terminate thread " + t));
                }
            }
        }
    }

    private TrieData getTrieData() {
        TrieData ret = new TrieData();
        this.root.populateTrieData(ret);
        ret.maxDepth = this.getMaxDepth();
        return ret;
    }

    private int getMaxDepth() {
        return this.root.getMaxDepth();
    }

    private Character getLookupChar(char ch) {
        return Character.valueOf(this.optIgnoreCase ? Character.toLowerCase(ch) : ch);
    }

    private Character getLookupChar(String str, int index) {
        return this.getLookupChar(str.charAt(index));
    }

    private int insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator, Map<Character, Integer> builderThreadMap, List<ResourceTrieBuilderThread> builderThreads, int lastUsedThreadIndex) throws InterruptedException {
        int ret = lastUsedThreadIndex;
        String prefix = this.getNonWildcardPrefix(resource);
        if (StringUtils.isNotEmpty((String)prefix)) {
            char c = this.getLookupChar(prefix.charAt(0)).charValue();
            Integer index = builderThreadMap.get(Character.valueOf(c));
            if (index == null) {
                index = (lastUsedThreadIndex + 1) % builderThreads.size();
                ret = index;
                builderThreadMap.put(Character.valueOf(c), index);
            }
            builderThreads.get(index).add(resource, isRecursive, evaluator);
        } else {
            currentRoot.addWildcardEvaluator(evaluator);
        }
        return ret;
    }

    private void insert(TrieNode<T> currentRoot, String resource, boolean isRecursive, T evaluator) {
        boolean isWildcard;
        TrieNode<T> curr = currentRoot;
        String prefix = this.getNonWildcardPrefix(resource);
        boolean bl = isWildcard = prefix.length() != resource.length();
        if (StringUtils.isNotEmpty((String)prefix)) {
            curr = curr.getOrCreateChild(prefix);
        }
        if (isWildcard || isRecursive) {
            curr.addWildcardEvaluator(evaluator);
        } else {
            curr.addEvaluator(evaluator);
        }
    }

    private String getNonWildcardPrefix(String str) {
        int minIndex = str.length();
        for (int i = 0; i < this.wildcardChars.length(); ++i) {
            int index = str.indexOf(this.wildcardChars.charAt(i));
            if (index == -1 || index >= minIndex) continue;
            minIndex = index;
        }
        return str.substring(0, minIndex);
    }

    private Set<T> getEvaluatorsForResource(String resource) {
        int i;
        String childStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie.getEvaluatorsForResource(" + resource + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getEvaluatorsForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        TrieNode<T> parent = null;
        int len = resource.length();
        for (i = 0; i < len; i += childStr.length()) {
            TrieNode<T> child;
            if (!this.isOptimizedForRetrieval) {
                curr.setupIfNeeded(parent);
            }
            if ((child = curr.getChild(this.getLookupChar(resource, i))) == null || !resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length())) break;
            parent = curr;
            curr = child;
        }
        if (!this.isOptimizedForRetrieval) {
            curr.setupIfNeeded(parent);
        }
        Set<T> ret = i == len ? curr.getEvaluators() : curr.getWildcardEvaluators();
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie.getEvaluatorsForResource(" + resource + "): evaluatorCount=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    private TrieNode<T> getNodeForResource(String resource) {
        TrieNode<T> child;
        String childStr;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie.getNodeForResource(" + resource + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_OP_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_TRIE_OP_LOG, "RangerResourceTrie.getNodeForResource(resource=" + resource + ")");
        }
        TrieNode<T> curr = this.root;
        int len = resource.length();
        for (int i = 0; i < len && (child = curr.getChild(this.getLookupChar(resource, i))) != null && resource.regionMatches(this.optIgnoreCase, i, childStr = child.getStr(), 0, childStr.length()); i += childStr.length()) {
            curr = child;
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie.getNodeForResource(" + resource + ")"));
        }
        return curr;
    }

    private Set<T> getEvaluatorsForResources(Collection<String> resources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerResourceTrie.getEvaluatorsForResources(" + resources + ")"));
        }
        Set<Object> ret = null;
        HashMap<Long, RangerPolicyResourceEvaluator> evaluatorsMap = null;
        for (String resource : resources) {
            Set<T> resourceEvaluators = this.getEvaluatorsForResource(resource);
            if (CollectionUtils.isEmpty(resourceEvaluators)) continue;
            if (evaluatorsMap == null) {
                if (ret == null) {
                    ret = resourceEvaluators;
                } else if (ret != resourceEvaluators) {
                    evaluatorsMap = new HashMap<Long, RangerPolicyResourceEvaluator>();
                    for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : ret) {
                        evaluatorsMap.put(rangerPolicyResourceEvaluator.getId(), rangerPolicyResourceEvaluator);
                    }
                    ret = null;
                }
            }
            if (evaluatorsMap == null) continue;
            for (RangerPolicyResourceEvaluator rangerPolicyResourceEvaluator : resourceEvaluators) {
                evaluatorsMap.put(rangerPolicyResourceEvaluator.getId(), rangerPolicyResourceEvaluator);
            }
        }
        if (ret == null && evaluatorsMap != null) {
            ret = new HashSet(evaluatorsMap.values());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerResourceTrie.getEvaluatorsForResources(" + resources + "): evaluatorCount=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TrieData trieData = this.getTrieData();
        sb.append("resourceName=").append(this.resourceDef.getName());
        sb.append("; optIgnoreCase=").append(this.optIgnoreCase);
        sb.append("; optWildcard=").append(this.optWildcard);
        sb.append("; wildcardChars=").append(this.wildcardChars);
        sb.append("; nodeCount=").append(trieData.nodeCount);
        sb.append("; leafNodeCount=").append(trieData.leafNodeCount);
        sb.append("; singleChildNodeCount=").append(trieData.singleChildNodeCount);
        sb.append("; maxDepth=").append(trieData.maxDepth);
        sb.append("; evaluatorListCount=").append(trieData.evaluatorListCount);
        sb.append("; wildcardEvaluatorListCount=").append(trieData.wildcardEvaluatorListCount);
        sb.append("; evaluatorListRefCount=").append(trieData.evaluatorListRefCount);
        sb.append("; wildcardEvaluatorListRefCount=").append(trieData.wildcardEvaluatorListRefCount);
        return sb.toString();
    }

    class TrieNode<U extends T> {
        private String str;
        private TrieNode<U> parent;
        private final Map<Character, TrieNode<U>> children = new HashMap<Character, TrieNode<U>>();
        private Set<U> evaluators;
        private Set<U> wildcardEvaluators;
        private boolean isSharingParentWildcardEvaluators;
        private volatile boolean isSetup = false;

        TrieNode(String str) {
            this.str = str;
        }

        String getStr() {
            return this.str;
        }

        void setStr(String str) {
            this.str = str;
        }

        TrieNode<U> getParent() {
            return this.parent;
        }

        void setParent(TrieNode<U> parent) {
            this.parent = parent;
        }

        Map<Character, TrieNode<U>> getChildren() {
            return this.children;
        }

        Set<U> getEvaluators() {
            return this.evaluators;
        }

        Set<U> getWildcardEvaluators() {
            return this.wildcardEvaluators;
        }

        TrieNode<U> getChild(Character ch) {
            return this.children.get(ch);
        }

        void populateTrieData(TrieData trieData) {
            ++trieData.nodeCount;
            if (this.wildcardEvaluators != null) {
                if (this.isSharingParentWildcardEvaluators) {
                    ++trieData.wildcardEvaluatorListRefCount;
                } else {
                    ++trieData.wildcardEvaluatorListCount;
                }
            }
            if (this.evaluators != null) {
                if (this.evaluators == this.wildcardEvaluators) {
                    ++trieData.evaluatorListRefCount;
                } else {
                    ++trieData.evaluatorListCount;
                }
            }
            if (!this.children.isEmpty()) {
                if (this.children.size() == 1) {
                    ++trieData.singleChildNodeCount;
                }
                for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                    TrieNode<U> child = entry.getValue();
                    child.populateTrieData(trieData);
                }
            } else {
                ++trieData.leafNodeCount;
            }
        }

        int getMaxDepth() {
            int ret = 0;
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                int maxChildDepth = child.getMaxDepth();
                if (maxChildDepth <= ret) continue;
                ret = maxChildDepth;
            }
            return ret + 1;
        }

        TrieNode<U> getOrCreateChild(String str) {
            int len = str.length();
            TrieNode<U> child = this.children.get(RangerResourceTrie.this.getLookupChar(str, 0));
            if (child == null) {
                child = new TrieNode<U>(str);
                this.addChild(child);
            } else {
                boolean isExactMatch;
                String childStr = child.getStr();
                int childStrLen = childStr.length();
                boolean bl = isExactMatch = RangerResourceTrie.this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)childStr, (String)str) : StringUtils.equals((String)childStr, (String)str);
                if (!isExactMatch) {
                    int index;
                    int numOfCharactersToMatch = Math.min(childStrLen, len);
                    for (index = 1; index < numOfCharactersToMatch && RangerResourceTrie.this.getLookupChar(childStr, index) == RangerResourceTrie.this.getLookupChar(str, index); ++index) {
                    }
                    if (index == numOfCharactersToMatch) {
                        if (childStrLen > len) {
                            TrieNode<U> newChild = new TrieNode<U>(str);
                            this.addChild(newChild);
                            child.setStr(childStr.substring(index));
                            super.addChild(child);
                            child = newChild;
                        } else {
                            child = child.getOrCreateChild(str.substring(index));
                        }
                    } else {
                        String matchedPart = str.substring(0, index);
                        TrieNode<U> newChild = new TrieNode<U>(matchedPart);
                        this.addChild(newChild);
                        child.setStr(childStr.substring(index));
                        super.addChild(child);
                        child = newChild.getOrCreateChild(str.substring(index));
                    }
                }
            }
            return child;
        }

        private void addChild(TrieNode<U> child) {
            this.children.put(RangerResourceTrie.this.getLookupChar(child.getStr(), 0), child);
            child.setParent(this);
        }

        void addEvaluator(U evaluator) {
            if (this.evaluators == null) {
                this.evaluators = new HashSet<U>();
            }
            this.evaluators.add(evaluator);
        }

        void addWildcardEvaluator(U evaluator) {
            if (this.wildcardEvaluators == null) {
                this.wildcardEvaluators = new HashSet<U>();
            }
            if (!this.wildcardEvaluators.contains(evaluator)) {
                this.wildcardEvaluators.add(evaluator);
                this.undoSetup();
            }
        }

        void removeEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.evaluators) && this.evaluators.contains(evaluator)) {
                this.evaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.evaluators)) {
                    this.evaluators = null;
                }
            }
        }

        boolean removeWildcardEvaluator(U evaluator) {
            if (CollectionUtils.isNotEmpty(this.wildcardEvaluators) && this.wildcardEvaluators.contains(evaluator)) {
                this.undoSetup();
                this.wildcardEvaluators.remove(evaluator);
                if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                    this.wildcardEvaluators = null;
                }
                return true;
            }
            return false;
        }

        void undoSetup() {
            if (this.isSetup) {
                for (TrieNode<U> child : this.children.values()) {
                    child.undoSetup();
                }
                if (this.evaluators != null) {
                    if (this.evaluators == this.wildcardEvaluators) {
                        this.evaluators = null;
                    } else if (this.wildcardEvaluators != null) {
                        this.evaluators.removeAll(this.wildcardEvaluators);
                        if (CollectionUtils.isEmpty(this.evaluators)) {
                            this.evaluators = null;
                        }
                        if (this.isSharingParentWildcardEvaluators) {
                            this.wildcardEvaluators = null;
                        } else {
                            Set<U> parentWildcardEvaluators;
                            Set<U> set = parentWildcardEvaluators = this.getParent() == null ? null : this.getParent().getWildcardEvaluators();
                            if (parentWildcardEvaluators != null) {
                                this.wildcardEvaluators.removeAll(parentWildcardEvaluators);
                                if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                                    this.wildcardEvaluators = null;
                                }
                            }
                        }
                    }
                }
                this.isSharingParentWildcardEvaluators = false;
                this.isSetup = false;
            }
        }

        void wrapUpUpdate() {
            if (RangerResourceTrie.this.isOptimizedForRetrieval) {
                RangerPerfTracer postSetupPerf = null;
                if (RangerPerfTracer.isPerfTraceEnabled(PERF_TRIE_INIT_LOG)) {
                    postSetupPerf = RangerPerfTracer.getPerfTracer(PERF_TRIE_INIT_LOG, "RangerResourceTrie.init(name=" + RangerResourceTrie.this.resourceDef.getName() + "-postSetup)");
                }
                this.postSetup(null);
                RangerPerfTracer.logAlways(postSetupPerf);
            }
        }

        void postSetup(Set<U> parentWildcardEvaluators) {
            this.setup(parentWildcardEvaluators);
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.postSetup(this.wildcardEvaluators);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setupIfNeeded(TrieNode<U> parent) {
            boolean setupNeeded;
            boolean bl = setupNeeded = !this.isSetup;
            if (setupNeeded) {
                Map<Character, TrieNode<U>> map = this.children;
                synchronized (map) {
                    boolean bl2 = setupNeeded = !this.isSetup;
                    if (setupNeeded) {
                        this.setup(parent == null ? null : parent.getWildcardEvaluators());
                        if (TRACE_LOG.isTraceEnabled()) {
                            StringBuilder sb = new StringBuilder();
                            this.toString(sb);
                            TRACE_LOG.trace((Object)("Set up is completed for this TriNode as a part of access evaluation : [" + sb + "]"));
                        }
                    }
                }
            }
        }

        void setup(Set<U> parentWildcardEvaluators) {
            if (!this.isSetup) {
                if (parentWildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.wildcardEvaluators)) {
                        this.wildcardEvaluators = parentWildcardEvaluators;
                    } else {
                        for (RangerPolicyResourceEvaluator evaluator : parentWildcardEvaluators) {
                            this.addWildcardEvaluator(evaluator);
                        }
                    }
                }
                boolean bl = this.isSharingParentWildcardEvaluators = this.wildcardEvaluators == parentWildcardEvaluators;
                if (this.wildcardEvaluators != null) {
                    if (CollectionUtils.isEmpty(this.evaluators)) {
                        this.evaluators = this.wildcardEvaluators;
                    } else {
                        for (RangerPolicyResourceEvaluator evaluator : this.wildcardEvaluators) {
                            this.addEvaluator(evaluator);
                        }
                    }
                }
                this.isSetup = true;
            }
        }

        private void removeEvaluatorFromSubtree(U evaluator) {
            if (this.removeWildcardEvaluator(evaluator)) {
                for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                    super.removeEvaluatorFromSubtree(evaluator);
                }
            }
            this.removeEvaluator(evaluator);
        }

        void toString(StringBuilder sb) {
            String nodeValue = this.str;
            sb.append("nodeValue=").append(nodeValue);
            sb.append("; isSetup=").append(this.isSetup);
            sb.append("; isSharingParentWildcardEvaluators=").append(this.isSharingParentWildcardEvaluators);
            sb.append("; childCount=").append(this.children.size());
            sb.append("; evaluators=[ ");
            if (this.evaluators != null) {
                for (RangerPolicyResourceEvaluator evaluator : this.evaluators) {
                    sb.append(evaluator.getId()).append(" ");
                }
            }
            sb.append("]");
            sb.append("; wildcardEvaluators=[ ");
            if (this.wildcardEvaluators != null) {
                for (RangerPolicyResourceEvaluator evaluator : this.wildcardEvaluators) {
                    sb.append(evaluator.getId()).append(" ");
                }
            }
        }

        void toString(String prefix, StringBuilder sb) {
            String nodeValue = prefix + (this.str != null ? this.str : "");
            sb.append(prefix);
            this.toString(sb);
            sb.append("]\n");
            for (Map.Entry<Character, TrieNode<U>> entry : this.children.entrySet()) {
                TrieNode<U> child = entry.getValue();
                child.toString(nodeValue, sb);
            }
        }
    }

    static class TrieData {
        int nodeCount;
        int leafNodeCount;
        int singleChildNodeCount;
        int maxDepth;
        int evaluatorListCount;
        int wildcardEvaluatorListCount;
        int evaluatorListRefCount;
        int wildcardEvaluatorListRefCount;

        TrieData() {
        }
    }

    class ResourceTrieBuilderThread
    extends Thread {
        private final TrieNode<T> thisRoot;
        private final BlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem> workQueue;

        ResourceTrieBuilderThread() {
            this.thisRoot = new TrieNode(null);
            this.workQueue = new LinkedBlockingQueue<org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem>();
        }

        void add(String resourceName, boolean isRecursive, T evaluator) throws InterruptedException {
            this.workQueue.put((org.apache.ranger.plugin.policyengine.RangerResourceTrie$ResourceTrieBuilderThread.WorkItem)new WorkItem(this, resourceName, isRecursive, evaluator));
        }

        Map<Character, TrieNode<T>> getSubtrees() {
            return this.thisRoot.getChildren();
        }

        @Override
        public void run() {
            block6: {
                WorkItem workItem;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Running " + this));
                }
                while (true) {
                    try {
                        workItem = (WorkItem)this.workQueue.take();
                    }
                    catch (InterruptedException exception) {
                        LOG.error((Object)("Thread=" + this + " is interrupted"), (Throwable)exception);
                        break block6;
                    }
                    if (workItem.evaluator == null) break;
                    RangerResourceTrie.this.insert(this.thisRoot, workItem.resourceName, workItem.isRecursive, workItem.evaluator);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Received termination signal. " + workItem));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Exiting " + this));
            }
        }

        static class WorkItem {
            final String resourceName;
            final boolean isRecursive;
            final T evaluator;
            final /* synthetic */ ResourceTrieBuilderThread this$1;

            WorkItem(String resourceName, boolean isRecursive, T evaluator) {
                this.this$1 = this$1;
                this.resourceName = resourceName;
                this.isRecursive = isRecursive;
                this.evaluator = evaluator;
            }

            public String toString() {
                return "resourceName=" + this.resourceName + "isRecursive=" + this.isRecursive + "evaluator=" + (this.evaluator != null ? Long.valueOf(this.evaluator.getId()) : null);
            }
        }
    }
}

