/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.nifi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.nifi.client.NiFiClient;
import org.apache.ranger.services.nifi.client.NiFiConnectionMgr;

public class RangerServiceNiFi
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceNiFi.class);
    public static final String ACCESS_TYPE_READ = "read";
    public static final String ACCESS_TYPE_WRITE = "write";
    public static final String ACCESS_TYPE_DELETE = "delete";

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerServiceNiFi.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            ArrayList<RangerPolicy.RangerPolicyItemAccess> accessListForLookupUser = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_READ));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_WRITE));
            accessListForLookupUser.add(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_DELETE));
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(accessListForLookupUser);
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.getPolicyItems().add(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerServiceNiFi.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public HashMap<String, Object> validateConfig() throws Exception {
        HashMap<String, Object> ret = new HashMap();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceNiFi.validateConfig Service: (" + serviceName + " )"));
        }
        if (this.configs != null) {
            try {
                ret = NiFiConnectionMgr.connectionTest(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error((Object)"<== RangerServiceNiFi.validateConfig Error:", (Throwable)e);
                throw e;
            }
        } else {
            throw new IllegalStateException("No Configuration found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceNiFi.validateConfig Response : (" + ret + " )"));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        NiFiClient client = NiFiConnectionMgr.getNiFiClient(this.serviceName, this.configs);
        return client.getResources(context);
    }
}

