SELECT 'Upgrading MetaStore schema from 1.2.0 to 1.2.1000' AS MESSAGE;

--:r 008-HIVE-12807.mssql.sql
ALTER TABLE COMPACTION_QUEUE ADD CQ_HIGHEST_TXN_ID bigint NULL;

--:r 009-HIVE-12814.mssql.sql
ALTER TABLE COMPACTION_QUEUE ADD CQ_META_INFO varbinary(2048) NULL;

--:r 010-HIVE-12816.mssql.sql
ALTER TABLE COMPACTION_QUEUE ADD CQ_HADOOP_JOB_ID nvarchar(32) NULL;

--:r 011-HIVE-12818.mssql.sql
CREATE TABLE COMPLETED_COMPACTIONS (
        CC_ID bigint NOT NULL,
        CC_DATABASE nvarchar(128) NOT NULL,
        CC_TABLE nvarchar(128) NOT NULL,
        CC_PARTITION nvarchar(767) NULL,
        CC_STATE char(1) NOT NULL,
        CC_TYPE char(1) NOT NULL,
        CC_WORKER_ID nvarchar(128) NULL,
        CC_START bigint NULL,
        CC_END bigint NULL,
        CC_RUN_AS nvarchar(128) NULL,
        CC_HIGHEST_TXN_ID bigint NULL,
    CC_META_INFO varbinary(2048) NULL,
        CC_HADOOP_JOB_ID nvarchar(128) NULL,
PRIMARY KEY CLUSTERED
(
        CC_ID ASC
)
);

--:r 012-HIVE-12819.mssql.sql
ALTER TABLE TXNS ADD TXN_AGENT_INFO nvarchar(128) NULL;

--:r 013-HIVE-12821.mssql.sql
ALTER TABLE TXNS ADD TXN_HEARTBEAT_COUNT int NULL;
ALTER TABLE HIVE_LOCKS ADD HL_HEARTBEAT_COUNT int NULL;

--:r 014-HIVE-12822.mssql.sql
ALTER TABLE TXNS ADD TXN_META_INFO nvarchar(128) NULL;

--:r 015-HIVE-12823.mssql.sql
ALTER TABLE HIVE_LOCKS ADD HL_AGENT_INFO nvarchar(128) NULL;

--:r 016-HIVE-12831.mssql.sql
ALTER TABLE HIVE_LOCKS ADD HL_BLOCKEDBY_EXT_ID bigint NULL;
ALTER TABLE HIVE_LOCKS ADD HL_BLOCKEDBY_INT_ID bigint NULL;

--:r 017-HIVE-12832.mssql.sql
CREATE TABLE AUX_TABLE (
  MT_KEY1 nvarchar(128) NOT NULL,
  MT_KEY2 bigint NOT NULL,
  MT_COMMENT nvarchar(255) NULL,
  PRIMARY KEY CLUSTERED
(
    MT_KEY1 ASC,
    MT_KEY2 ASC
)
);

UPDATE VERSION SET SCHEMA_VERSION='1.2.1000', VERSION_COMMENT='Hive release version 1.2.1000' where VER_ID=1;
SELECT 'Finished upgrading MetaStore schema from 1.2.0 to 1.2.1000' AS MESSAGE;
