-- Upgrade MetaStore schema from 1.2.0 to 1.2.1000

-- RUN '023-HIVE-12807.derby.sql';
ALTER TABLE "COMPACTION_QUEUE" ADD "CQ_HIGHEST_TXN_ID" bigint;

-- RUN '024-HIVE-12814.derby.sql';
ALTER TABLE "COMPACTION_QUEUE" ADD "CQ_META_INFO" varchar(2048) for bit data;

-- RUN '025-HIVE-12816.derby.sql';
ALTER TABLE "COMPACTION_QUEUE" ADD "CQ_HADOOP_JOB_ID" VARCHAR(32);

-- RUN '026-HIVE-12818.derby.sql';
CREATE TABLE COMPLETED_COMPACTIONS (
  CC_ID bigint PRIMARY KEY,
  CC_DATABASE varchar(128) NOT NULL,
  CC_TABLE varchar(128) NOT NULL,
  CC_PARTITION varchar(767),
  CC_STATE char(1) NOT NULL,
  CC_TYPE char(1) NOT NULL,
  CC_WORKER_ID varchar(128),
  CC_START bigint,
  CC_END bigint,
  CC_RUN_AS varchar(128),
  CC_HIGHEST_TXN_ID bigint,
  CC_META_INFO varchar(2048) for bit data,
  CC_HADOOP_JOB_ID varchar(32)
);

-- RUN '027-HIVE-12819.derby.sql';
ALTER TABLE "TXNS" ADD "TXN_AGENT_INFO" varchar(128);

-- RUN '028-HIVE-12821.derby.sql';
ALTER TABLE "TXNS" ADD "TXN_HEARTBEAT_COUNT" INTEGER;
ALTER TABLE "HIVE_LOCKS" ADD "HL_HEARTBEAT_COUNT" INTEGER;

-- RUN '029-HIVE-12822.derby.sql';
ALTER TABLE "TXNS" ADD "TXN_META_INFO" varchar(128);

-- RUN '030-HIVE-12823.derby.sql';
ALTER TABLE "HIVE_LOCKS" ADD "HL_AGENT_INFO" varchar(128);

-- RUN '031-HIVE-12831.derby.sql';
ALTER TABLE "HIVE_LOCKS" ADD "HL_BLOCKEDBY_EXT_ID" bigint;
ALTER TABLE "HIVE_LOCKS" ADD "HL_BLOCKEDBY_INT_ID" bigint;

-- RUN '032-HIVE-12832.derby.sql';
CREATE TABLE AUX_TABLE (
  MT_KEY1 varchar(128) NOT NULL,
  MT_KEY2 bigint NOT NULL,
  MT_COMMENT varchar(255),
  PRIMARY KEY(MT_KEY1, MT_KEY2)
);

UPDATE "APP".VERSION SET SCHEMA_VERSION='1.2.1000', VERSION_COMMENT='Hive release version 1.2.1000' where VER_ID=1;
