/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.trace.SpanReceiverHost;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.TraceScope;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestSendTraceRequests
extends AbstractHBaseTool {
    public static final String TABLE_ARG = "t";
    public static final String CF_ARG = "f";
    public static final String TABLE_NAME_DEFAULT = "SendTracesTable";
    public static final String COLUMN_FAMILY_DEFAULT = "D";
    private TableName tableName = TableName.valueOf((String)"SendTracesTable");
    private byte[] familyName = Bytes.toBytes((String)"D");
    private IntegrationTestingUtility util;
    private Random random = new Random();
    private Admin admin;
    private SpanReceiverHost receiverHost;

    public static void main(String[] args) throws Exception {
        Configuration configuration = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(configuration);
        IntegrationTestSendTraceRequests tool = new IntegrationTestSendTraceRequests();
        ToolRunner.run((Configuration)configuration, (Tool)tool, (String[])args);
    }

    protected void addOptions() {
        this.addOptWithArg(TABLE_ARG, "The table name to target.  Will be created if not there already.");
        this.addOptWithArg(CF_ARG, "The family to target");
    }

    public void processOptions(CommandLine cmd) {
        String tableNameString = cmd.getOptionValue(TABLE_ARG, TABLE_NAME_DEFAULT);
        String familyString = cmd.getOptionValue(CF_ARG, COLUMN_FAMILY_DEFAULT);
        this.tableName = TableName.valueOf((String)tableNameString);
        this.familyName = Bytes.toBytes((String)familyString);
    }

    public int doWork() throws Exception {
        this.internalDoWork();
        return 0;
    }

    @Test
    public void internalDoWork() throws Exception {
        this.util = this.createUtil();
        this.admin = this.util.getAdmin();
        this.setupReceiver();
        this.deleteTable();
        this.createTable();
        LinkedBlockingQueue<Long> rks = this.insertData();
        ExecutorService service = Executors.newFixedThreadPool(20);
        this.doScans(service, rks);
        this.doGets(service, rks);
        service.shutdown();
        service.awaitTermination(100L, TimeUnit.SECONDS);
        Thread.sleep(90000L);
        this.receiverHost.closeReceivers();
        this.util.restoreCluster();
        this.util = null;
    }

    private void doScans(ExecutorService service, final LinkedBlockingQueue<Long> rks) {
        for (int i = 0; i < 100; ++i) {
            Runnable runnable = new Runnable(){
                private final LinkedBlockingQueue<Long> rowKeyQueue;
                {
                    this.rowKeyQueue = rks;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ResultScanner rs = null;
                    TraceUtil.addSampler((Sampler)Sampler.ALWAYS);
                    try (TraceScope scope = TraceUtil.createTrace((String)"Scan");){
                        Table ht = IntegrationTestSendTraceRequests.this.util.getConnection().getTable(IntegrationTestSendTraceRequests.this.tableName);
                        Scan s = new Scan();
                        s.setStartRow(Bytes.toBytes((long)this.rowKeyQueue.take()));
                        s.setBatch(7);
                        rs = ht.getScanner(s);
                        long accum = 0L;
                        for (int x = 0; x < 1000; ++x) {
                            Result r = rs.next();
                            accum |= Bytes.toLong((byte[])r.getRow());
                        }
                        TraceUtil.addTimelineAnnotation((String)("Accum result = " + accum));
                        ht.close();
                        ht = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        TraceUtil.addKVAnnotation((String)"exception", (String)e.getClass().getSimpleName());
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
            };
            service.submit(runnable);
        }
    }

    private void doGets(ExecutorService service, final LinkedBlockingQueue<Long> rowKeys) throws IOException {
        for (int i = 0; i < 100; ++i) {
            Runnable runnable = new Runnable(){
                private final LinkedBlockingQueue<Long> rowKeyQueue;
                {
                    this.rowKeyQueue = rowKeys;
                }

                @Override
                public void run() {
                    Table ht = null;
                    try {
                        ht = IntegrationTestSendTraceRequests.this.util.getConnection().getTable(IntegrationTestSendTraceRequests.this.tableName);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    long accum = 0L;
                    TraceUtil.addSampler((Sampler)Sampler.ALWAYS);
                    for (int x = 0; x < 5; ++x) {
                        try (TraceScope scope = TraceUtil.createTrace((String)"gets");){
                            Result r2;
                            long rk = this.rowKeyQueue.take();
                            Result r1 = ht.get(new Get(Bytes.toBytes((long)rk)));
                            if (r1 != null) {
                                accum |= Bytes.toLong((byte[])r1.getRow());
                            }
                            if ((r2 = ht.get(new Get(Bytes.toBytes((long)rk)))) != null) {
                                accum |= Bytes.toLong((byte[])r2.getRow());
                            }
                            TraceUtil.addTimelineAnnotation((String)("Accum = " + accum));
                            continue;
                        }
                        catch (IOException | InterruptedException exception) {
                            // empty catch block
                        }
                    }
                }
            };
            service.submit(runnable);
        }
    }

    private void createTable() throws IOException {
        TraceUtil.addSampler((Sampler)Sampler.ALWAYS);
        try (TraceScope scope = TraceUtil.createTrace((String)"createTable");){
            this.util.createTable(this.tableName, this.familyName);
        }
    }

    private void deleteTable() throws IOException {
        TraceUtil.addSampler((Sampler)Sampler.ALWAYS);
        try (TraceScope scope = TraceUtil.createTrace((String)"deleteTable");){
            if (this.admin.tableExists(this.tableName)) {
                this.util.deleteTable(this.tableName);
            }
        }
    }

    private LinkedBlockingQueue<Long> insertData() throws IOException, InterruptedException {
        LinkedBlockingQueue<Long> rowKeys = new LinkedBlockingQueue<Long>(25000);
        BufferedMutator ht = this.util.getConnection().getBufferedMutator(this.tableName);
        byte[] value = new byte[300];
        TraceUtil.addSampler((Sampler)Sampler.ALWAYS);
        for (int x = 0; x < 5000; ++x) {
            try (TraceScope traceScope = TraceUtil.createTrace((String)"insertData");){
                for (int i = 0; i < 5; ++i) {
                    long rk = this.random.nextLong();
                    rowKeys.add(rk);
                    Put p = new Put(Bytes.toBytes((long)rk));
                    for (int y = 0; y < 10; ++y) {
                        this.random.nextBytes(value);
                        p.addColumn(this.familyName, Bytes.toBytes((long)this.random.nextLong()), value);
                    }
                    ht.mutate((Mutation)p);
                }
                if (x % 1000 != 0) continue;
                this.admin.flush(this.tableName);
                continue;
            }
        }
        this.admin.flush(this.tableName);
        return rowKeys;
    }

    private IntegrationTestingUtility createUtil() throws Exception {
        Configuration conf = this.getConf();
        if (this.util == null) {
            IntegrationTestingUtility u = conf == null ? new IntegrationTestingUtility() : new IntegrationTestingUtility(conf);
            this.util = u;
            this.util.initializeCluster(1);
        }
        return this.util;
    }

    private void setupReceiver() {
        Configuration conf = new Configuration(this.util.getConfiguration());
        conf.setBoolean("hbase.zipkin.is-in-client-mode", true);
        this.receiverHost = SpanReceiverHost.getInstance((Configuration)conf);
    }
}

