/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mapred.TestTableSnapshotInputFormat;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestTableSnapshotInputFormat
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestTableSnapshotInputFormat.class);
    private static final String TABLE_NAME_KEY = "IntegrationTestTableSnapshotInputFormat.table";
    private static final String DEFAULT_TABLE_NAME = "IntegrationTestTableSnapshotInputFormat";
    private static final String SNAPSHOT_NAME_KEY = "IntegrationTestTableSnapshotInputFormat.snapshot";
    private static final String NUM_REGIONS_KEY = "IntegrationTestTableSnapshotInputFormat.numRegions";
    private static final String MR_IMPLEMENTATION_KEY = "IntegrationTestTableSnapshotInputFormat.API";
    private static final String MAPRED_IMPLEMENTATION = "mapred";
    private static final String MAPREDUCE_IMPLEMENTATION = "mapreduce";
    private static final int DEFAULT_NUM_REGIONS = 32;
    private static final String TABLE_DIR_KEY = "IntegrationTestTableSnapshotInputFormat.tableDir";
    private static final byte[] START_ROW = Bytes.toBytes((String)"bbb");
    private static final byte[] END_ROW = Bytes.toBytes((String)"yyy");
    private static final byte[] MAPRED_START_ROW = Bytes.toBytes((String)"aaa");
    private static final byte[] MAPRED_END_ROW = Bytes.toBytes((String)"zz{");
    private IntegrationTestingUtility util;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.util = this.getTestingUtil(conf);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(1);
        this.setConf(this.util.getConfiguration());
    }

    @Override
    @After
    public void cleanUp() throws Exception {
        this.util.restoreCluster();
    }

    @Override
    public void setUpCluster() throws Exception {
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        Configuration conf = this.getConf();
        TableName tableName = TableName.valueOf((String)conf.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
        String snapshotName = conf.get(SNAPSHOT_NAME_KEY, tableName.getQualifierAsString() + "_snapshot_" + System.currentTimeMillis());
        int numRegions = conf.getInt(NUM_REGIONS_KEY, 32);
        String tableDirStr = conf.get(TABLE_DIR_KEY);
        Path tableDir = tableDirStr == null ? this.util.getDataTestDirOnTestFS(tableName.getQualifierAsString()) : new Path(tableDirStr);
        String mr = conf.get(MR_IMPLEMENTATION_KEY, MAPREDUCE_IMPLEMENTATION);
        if (mr.equalsIgnoreCase(MAPREDUCE_IMPLEMENTATION)) {
            LOG.debug("Running job with mapreduce API.");
            int expectedNumSplits = numRegions > 2 ? numRegions - 2 : numRegions;
            org.apache.hadoop.hbase.mapreduce.TestTableSnapshotInputFormat.doTestWithMapReduce((HBaseTestingUtility)this.util, (TableName)tableName, (String)snapshotName, (byte[])START_ROW, (byte[])END_ROW, (Path)tableDir, (int)numRegions, (int)1, (int)expectedNumSplits, (boolean)false);
        } else if (mr.equalsIgnoreCase(MAPRED_IMPLEMENTATION)) {
            LOG.debug("Running job with mapred API.");
            int expectedNumSplits = numRegions;
            TestTableSnapshotInputFormat.doTestWithMapReduce((HBaseTestingUtility)this.util, (TableName)tableName, (String)snapshotName, (byte[])MAPRED_START_ROW, (byte[])MAPRED_END_ROW, (Path)tableDir, (int)numRegions, (int)1, (int)expectedNumSplits, (boolean)false);
        } else {
            throw new IllegalArgumentException("Unrecognized mapreduce implementation: " + mr + ".");
        }
        return 0;
    }

    @Override
    public TableName getTablename() {
        return null;
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return null;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestTableSnapshotInputFormat(), (String[])args);
        System.exit(ret);
    }
}

