/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.DistributedHBaseCluster;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseClusterManager;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SudoCommandAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(SudoCommandAction.class);
    protected long timeout;
    protected HBaseClusterManager clusterManager;

    public SudoCommandAction(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        ClusterManager manager;
        super.init(context);
        HBaseCluster cluster = context.getHBaseCluster();
        if (cluster != null && cluster instanceof DistributedHBaseCluster && (manager = ((DistributedHBaseCluster)cluster).getClusterManager()) != null && manager instanceof HBaseClusterManager) {
            this.clusterManager = (HBaseClusterManager)manager;
        }
    }

    @Override
    public void perform() throws Exception {
        if (this.clusterManager == null) {
            LOG.info("Couldn't perform command action, it requires a distributed cluster.");
            return;
        }
        if (this.context.isStopping()) {
            return;
        }
        this.localPerform();
    }

    protected abstract void localPerform() throws IOException;
}

