/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveColumnAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveColumnAction.class);
    private final TableName tableName;
    private final Set<String> protectedColumns;
    private Admin admin;
    private Random random;

    public RemoveColumnAction(TableName tableName, Set<String> protectedColumns) {
        this.tableName = tableName;
        this.protectedColumns = protectedColumns;
        this.random = new Random();
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getAdmin();
    }

    @Override
    public void perform() throws Exception {
        TableDescriptor tableDescriptor = this.admin.getDescriptor(this.tableName);
        ColumnFamilyDescriptor[] columnDescriptors = tableDescriptor.getColumnFamilies();
        if (columnDescriptors.length <= (this.protectedColumns == null ? 1 : this.protectedColumns.size())) {
            return;
        }
        int index = this.random.nextInt(columnDescriptors.length);
        while (this.protectedColumns != null && this.protectedColumns.contains(columnDescriptors[index].getNameAsString())) {
            index = this.random.nextInt(columnDescriptors.length);
        }
        byte[] colDescName = columnDescriptors[index].getName();
        LOG.debug("Performing action: Removing " + Bytes.toString((byte[])colDescName) + " from " + this.tableName.getNameAsString());
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor);
        builder.removeColumnFamily(colDescName);
        if (this.context.isStopping()) {
            return;
        }
        this.admin.modifyTable(builder.build());
    }
}

