/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.SudoCommandAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FillDiskCommandAction
extends SudoCommandAction {
    private static final Logger LOG = LoggerFactory.getLogger(FillDiskCommandAction.class);
    private long size;
    private long duration;
    private String path;

    public FillDiskCommandAction(long size, long duration, String path, long timeout) {
        super(timeout);
        this.size = size;
        this.duration = duration;
        this.path = path;
    }

    @Override
    protected void localPerform() throws IOException {
        LOG.info("Starting to execute FillDiskCommandAction");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getCurrentServers());
        String hostname = server.getHostname();
        try {
            this.clusterManager.execSudo(hostname, this.duration, this.getFillCommand());
        }
        catch (IOException ex) {
            try {
                LOG.info("Potential timeout. We try to stop the dd process on target machine");
                this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getStopCommand());
                throw ex;
            }
            catch (Throwable throwable) {
                this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getClearCommand());
                LOG.info("Finished to execute FillDiskCommandAction");
                throw throwable;
            }
        }
        this.clusterManager.execSudoWithRetries(hostname, this.timeout, this.getClearCommand());
        LOG.info("Finished to execute FillDiskCommandAction");
    }

    private String getFillCommand() {
        if (this.size == 0L) {
            return String.format("dd if=/dev/urandom of=%s/garbage bs=1M iflag=fullblock", this.path);
        }
        return String.format("dd if=/dev/urandom of=%s/garbage bs=1M count=%s iflag=fullblock", this.path, this.size);
    }

    private String getClearCommand() {
        return String.format("rm -f %s/garbage", this.path);
    }

    private String getStopCommand() {
        return String.format("killall dd", new Object[0]);
    }
}

