/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddColumnAction
extends Action {
    private final TableName tableName;
    private Admin admin;
    private static final Logger LOG = LoggerFactory.getLogger(AddColumnAction.class);

    public AddColumnAction(TableName tableName) {
        this.tableName = tableName;
    }

    @Override
    public void init(Action.ActionContext context) throws IOException {
        super.init(context);
        this.admin = context.getHBaseIntegrationTestingUtility().getAdmin();
    }

    @Override
    public void perform() throws Exception {
        TableDescriptor tableDescriptor = this.admin.getDescriptor(this.tableName);
        ColumnFamilyDescriptor columnDescriptor = null;
        while (columnDescriptor == null || tableDescriptor.getColumnFamily(columnDescriptor.getName()) != null) {
            columnDescriptor = ColumnFamilyDescriptorBuilder.of((String)RandomStringUtils.randomAlphabetic((int)5));
        }
        if (this.context.isStopping()) {
            return;
        }
        LOG.debug("Performing action: Adding " + columnDescriptor + " to " + this.tableName);
        TableDescriptor modifiedTable = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDescriptor).setColumnFamily(columnDescriptor).build();
        this.admin.modifyTable(modifiedTable);
    }
}

