/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.SudoCommandAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCPULoadAction
extends SudoCommandAction {
    protected static final Logger LOG = LoggerFactory.getLogger(AddCPULoadAction.class);
    private static final String CPU_LOAD_COMMAND = "seq 1 %s | xargs -I{} -n 1 -P %s timeout %s dd if=/dev/urandom of=/dev/null bs=1M iflag=fullblock";
    private final long duration;
    private long processes;

    public AddCPULoadAction(long duration, long processes, long timeout) {
        super(timeout);
        this.duration = duration;
        this.processes = processes;
    }

    @Override
    protected void localPerform() throws IOException {
        LOG.info("Starting to execute AddCPULoadAction");
        ServerName server = PolicyBasedChaosMonkey.selectRandomItem(this.getCurrentServers());
        String hostname = server.getHostname();
        try {
            this.clusterManager.execSudo(hostname, this.timeout, this.getCommand());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.info("Finished to execute AddCPULoadAction");
    }

    private String getCommand() {
        return String.format(CPU_LOAD_COMMAND, this.processes, this.processes, Float.valueOf((float)this.duration / 1000.0f));
    }
}

