/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.ConstantDelayQueue;
import org.apache.hadoop.hbase.util.MultiThreadedUpdater;
import org.apache.hadoop.hbase.util.MultiThreadedWriter;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.test.LoadTestDataGenerator;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestRegionReplicaReplication
extends IntegrationTestIngest {
    private static final String TEST_NAME = IntegrationTestRegionReplicaReplication.class.getSimpleName();
    private static final String OPT_READ_DELAY_MS = "read_delay_ms";
    private static final int DEFAULT_REGION_REPLICATION = 2;
    private static final int SERVER_COUNT = 1;
    private static final String[] DEFAULT_COLUMN_FAMILIES = new String[]{"f1", "f2", "f3"};

    @Override
    protected int getMinServerCount() {
        return 1;
    }

    public void setConf(Configuration conf) {
        conf.setIfUnset(String.format("%s.%s", TEST_NAME, "region_replication"), String.valueOf(2));
        conf.setIfUnset(String.format("%s.%s", TEST_NAME, "families"), StringUtils.join((CharSequence)",", (String[])DEFAULT_COLUMN_FAMILIES));
        conf.setBoolean("hbase.table.sanity.checks", true);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setLong("hbase.hregion.memstore.flush.size", 0x400000L);
        conf.setInt("hbase.hstore.blockingStoreFiles", 100);
        super.setConf(conf);
    }

    @Override
    @Test
    public void testIngest() throws Exception {
        this.runIngestTest(600000L, 25000L, 10, 1024, 10, 20);
    }

    @Override
    protected void runIngestTest(long defaultRunTime, long keysPerServerPerIter, int colsPerKey, int recordSize, int writeThreads, int readThreads) throws Exception {
        LOG.info("Running ingest");
        LOG.info("Cluster size:" + this.util.getHBaseClusterInterface().getClusterMetrics().getLiveServerMetrics().size());
        Threads.sleep((long)(this.getConf().getInt("hbase.region.replica.replication.cache.disabledAndDroppedTables.expiryMs", 5000) + 1000));
        long start = System.currentTimeMillis();
        String runtimeKey = String.format("hbase.%s.runtime", ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, defaultRunTime);
        long startKey = 0L;
        long numKeys = this.getNumKeys(keysPerServerPerIter);
        while ((double)(System.currentTimeMillis() - start) < 0.9 * (double)runtime) {
            String errorMsg;
            LOG.info("Intended run time: " + runtime / 60000L + " min, left:" + (runtime - (System.currentTimeMillis() - start)) / 60000L + " min");
            int verifyPercent = 100;
            int updatePercent = 20;
            int ret = -1;
            int regionReplicaId = this.conf.getInt(String.format("%s.%s", TEST_NAME, "region_replica_id"), 1);
            ArrayList args = Lists.newArrayList((Object[])this.getArgsForLoadTestTool("", "", startKey, numKeys));
            args.add("-write");
            args.add(String.format("%d:%d:%d", colsPerKey, recordSize, writeThreads));
            args.add("-multiput");
            args.add("-writer");
            args.add(DelayingMultiThreadedWriter.class.getName());
            args.add("-read");
            args.add(String.format("%d:%d", verifyPercent, readThreads));
            args.add("-region_replica_id");
            args.add(String.valueOf(regionReplicaId));
            ret = this.loadTool.run(args.toArray(new String[args.size()]));
            if (0 != ret) {
                errorMsg = "Load failed with error code " + ret;
                LOG.error(errorMsg);
                Assert.fail((String)errorMsg);
            }
            args = Lists.newArrayList((Object[])this.getArgsForLoadTestTool("", "", startKey, numKeys));
            args.add("-update");
            args.add(String.format("%s:%s:1", updatePercent, writeThreads));
            args.add("-updater");
            args.add(DelayingMultiThreadedUpdater.class.getName());
            args.add("-read");
            args.add(String.format("%d:%d", verifyPercent, readThreads));
            args.add("-region_replica_id");
            args.add(String.valueOf(regionReplicaId));
            ret = this.loadTool.run(args.toArray(new String[args.size()]));
            if (0 != ret) {
                errorMsg = "Load failed with error code " + ret;
                LOG.error(errorMsg);
                Assert.fail((String)errorMsg);
            }
            startKey += numKeys;
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestRegionReplicaReplication(), (String[])args);
        System.exit(ret);
    }

    public static class DelayingMultiThreadedUpdater
    extends MultiThreadedUpdater {
        private long delayMs;

        public DelayingMultiThreadedUpdater(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName, double updatePercent) throws IOException {
            super(dataGen, conf, tableName, updatePercent);
        }

        protected BlockingQueue<Long> createWriteKeysQueue(Configuration conf) {
            this.delayMs = conf.getLong(String.format("%s.%s", IntegrationTestRegionReplicaReplication.class.getSimpleName(), IntegrationTestRegionReplicaReplication.OPT_READ_DELAY_MS), 5000L);
            return new ConstantDelayQueue(TimeUnit.MILLISECONDS, this.delayMs);
        }
    }

    public static class DelayingMultiThreadedWriter
    extends MultiThreadedWriter {
        private long delayMs;

        public DelayingMultiThreadedWriter(LoadTestDataGenerator dataGen, Configuration conf, TableName tableName) throws IOException {
            super(dataGen, conf, tableName);
        }

        protected BlockingQueue<Long> createWriteKeysQueue(Configuration conf) {
            this.delayMs = conf.getLong(String.format("%s.%s", IntegrationTestRegionReplicaReplication.class.getSimpleName(), IntegrationTestRegionReplicaReplication.OPT_READ_DELAY_MS), 5000L);
            return new ConstantDelayQueue(TimeUnit.MILLISECONDS, this.delayMs);
        }
    }
}

