/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.client.TestMetaWithReplicas;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestMetaReplicas {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestMetaReplicas.class);
    private static IntegrationTestingUtility util;

    @BeforeClass
    public static void setUp() throws Exception {
        if (util == null) {
            util = new IntegrationTestingUtility();
        }
        util.getConfiguration().setInt("hbase.meta.replica.count", 3);
        util.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        util.initializeCluster(3);
        ZKWatcher zkw = util.getZooKeeperWatcher();
        Configuration conf = util.getConfiguration();
        String baseZNode = conf.get("zookeeper.znode.parent", "/hbase");
        String primaryMetaZnode = ZNodePaths.joinZNode((String)baseZNode, (String)conf.get("zookeeper.znode.metaserver", "meta-region-server"));
        byte[] data = ZKUtil.getData((ZKWatcher)zkw, (String)primaryMetaZnode);
        ProtobufUtil.toServerName((byte[])data);
        IntegrationTestMetaReplicas.waitUntilZnodeAvailable(1);
        IntegrationTestMetaReplicas.waitUntilZnodeAvailable(2);
    }

    @AfterClass
    public static void teardown() throws Exception {
        util.restoreCluster();
        util = null;
    }

    private static void waitUntilZnodeAvailable(int replicaId) throws Exception {
        int i;
        String znode = util.getZooKeeperWatcher().getZNodePaths().getZNodeForReplica(replicaId);
        for (i = 0; i < 1000 && ZKUtil.checkExists((ZKWatcher)util.getZooKeeperWatcher(), (String)znode) == -1; ++i) {
            Thread.sleep(100L);
        }
        if (i == 1000) {
            throw new IOException("znode for meta replica " + replicaId + " not available");
        }
    }

    @Test
    public void testShutdownHandling() throws Exception {
        TestMetaWithReplicas.shutdownMetaAndDoValidations((HBaseTestingUtility)util);
    }

    public static void main(String[] args) throws Exception {
        IntegrationTestMetaReplicas.setUp();
        new IntegrationTestMetaReplicas().testShutdownHandling();
        IntegrationTestMetaReplicas.teardown();
    }
}

