/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HFileTestUtil;
import org.apache.hadoop.hbase.util.LoadTestTool;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngest
extends IntegrationTestBase {
    public static final char HIPHEN = '-';
    private static final int SERVER_COUNT = 1;
    protected static final long DEFAULT_RUN_TIME = 1200000L;
    protected static final long JUNIT_RUN_TIME = 600000L;
    protected static final String RUN_TIME_KEY = "hbase.%s.runtime";
    protected static final String NUM_KEYS_PER_SERVER_KEY = "num_keys_per_server";
    protected static final long DEFAULT_NUM_KEYS_PER_SERVER = 2500L;
    protected static final String NUM_WRITE_THREADS_KEY = "num_write_threads";
    protected static final int DEFAULT_NUM_WRITE_THREADS = 20;
    protected static final String NUM_READ_THREADS_KEY = "num_read_threads";
    protected static final int DEFAULT_NUM_READ_THREADS = 20;
    protected static final Logger LOG = LoggerFactory.getLogger(IntegrationTestIngest.class);
    protected IntegrationTestingUtility util;
    protected HBaseCluster cluster;
    protected LoadTestTool loadTool;
    protected String[] LOAD_TEST_TOOL_INIT_ARGS = new String[]{"families", "compression", HFileTestUtil.OPT_DATA_BLOCK_ENCODING, "in_memory", "encryption", "num_regions_per_server", "region_replication"};

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        LOG.debug("Initializing/checking cluster has 1 servers");
        this.util.initializeCluster(this.getMinServerCount());
        LOG.debug("Done initializing/checking cluster");
        this.cluster = this.util.getHBaseClusterInterface();
        this.deleteTableIfNecessary();
        this.loadTool = new LoadTestTool();
        this.loadTool.setConf(this.util.getConfiguration());
        this.initTable();
    }

    protected int getMinServerCount() {
        return 1;
    }

    protected void initTable() throws IOException {
        int ret = this.loadTool.run(this.getArgsForLoadTestToolInitTable());
        Assert.assertEquals((String)"Failed to initialize LoadTestTool", (long)0L, (long)ret);
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        this.internalRunIngestTest(1200000L);
        return 0;
    }

    @Test
    public void testIngest() throws Exception {
        this.runIngestTest(600000L, 2500L, 10, 1024, 10, 20);
    }

    protected void internalRunIngestTest(long runTime) throws Exception {
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        long numKeysPerServer = this.conf.getLong(String.format("%s.%s", clazz, NUM_KEYS_PER_SERVER_KEY), 2500L);
        int numWriteThreads = this.conf.getInt(String.format("%s.%s", clazz, NUM_WRITE_THREADS_KEY), 20);
        int numReadThreads = this.conf.getInt(String.format("%s.%s", clazz, NUM_READ_THREADS_KEY), 20);
        this.runIngestTest(runTime, numKeysPerServer, 10, 1024, numWriteThreads, numReadThreads);
    }

    @Override
    public TableName getTablename() {
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        return TableName.valueOf((String)this.conf.get(String.format("%s.%s", clazz, "tn"), clazz));
    }

    @Override
    protected Set<String> getColumnFamilies() {
        HashSet families = Sets.newHashSet();
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        String familiesString = this.getConf().get(String.format("%s.%s", clazz, "families"));
        if (familiesString == null) {
            for (byte[] family : HFileTestUtil.DEFAULT_COLUMN_FAMILIES) {
                families.add(Bytes.toString((byte[])family));
            }
        } else {
            for (String family : familiesString.split(",")) {
                families.add(family);
            }
        }
        return families;
    }

    private void deleteTableIfNecessary() throws IOException {
        if (this.util.getAdmin().tableExists(this.getTablename())) {
            this.util.deleteTable(this.getTablename());
        }
    }

    protected void runIngestTest(long defaultRunTime, long keysPerServerPerIter, int colsPerKey, int recordSize, int writeThreads, int readThreads) throws Exception {
        LOG.info("Running ingest");
        LOG.info("Cluster size:" + this.util.getHBaseClusterInterface().getClusterMetrics().getLiveServerMetrics().size());
        long start = System.currentTimeMillis();
        String runtimeKey = String.format(RUN_TIME_KEY, ((Object)((Object)this)).getClass().getSimpleName());
        long runtime = this.util.getConfiguration().getLong(runtimeKey, defaultRunTime);
        long startKey = 0L;
        long numKeys = this.getNumKeys(keysPerServerPerIter);
        while ((double)(System.currentTimeMillis() - start) < 0.9 * (double)runtime) {
            String errorMsg;
            LOG.info("Intended run time: " + runtime / 60000L + " min, left:" + (runtime - (System.currentTimeMillis() - start)) / 60000L + " min");
            int ret = -1;
            ret = this.loadTool.run(this.getArgsForLoadTestTool("-write", String.format("%d:%d:%d", colsPerKey, recordSize, writeThreads), startKey, numKeys));
            if (0 != ret) {
                errorMsg = "Load failed with error code " + ret;
                LOG.error(errorMsg);
                Assert.fail((String)errorMsg);
            }
            if (0 != (ret = this.loadTool.run(this.getArgsForLoadTestTool("-update", String.format("60:%d:1", writeThreads), startKey, numKeys)))) {
                errorMsg = "Update failed with error code " + ret;
                LOG.error(errorMsg);
                Assert.fail((String)errorMsg);
            }
            if (0 != (ret = this.loadTool.run(this.getArgsForLoadTestTool("-read", String.format("100:%d", readThreads), startKey, numKeys)))) {
                errorMsg = "Verification failed with error code " + ret;
                LOG.error(errorMsg + " Rerunning verification after 1 minute for debugging");
                Threads.sleep((long)60000L);
                ret = this.loadTool.run(this.getArgsForLoadTestTool("-read", String.format("100:%d", readThreads), startKey, numKeys));
                if (0 != ret) {
                    LOG.error("Rerun of Verification failed with error code " + ret);
                }
                Assert.fail((String)errorMsg);
            }
            startKey += numKeys;
        }
    }

    protected String[] getArgsForLoadTestToolInitTable() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-tn");
        args.add(this.getTablename().getNameAsString());
        String clazz = ((Object)((Object)this)).getClass().getSimpleName();
        for (String arg : this.LOAD_TEST_TOOL_INIT_ARGS) {
            String val = this.conf.get(String.format("%s.%s", clazz, arg));
            if (val == null) continue;
            args.add("-" + arg);
            args.add(val);
        }
        args.add("-init_only");
        return args.toArray(new String[args.size()]);
    }

    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        ArrayList<String> args = new ArrayList<String>(11);
        args.add("-tn");
        args.add(this.getTablename().getNameAsString());
        args.add("-families");
        args.add(this.getColumnFamiliesAsString());
        args.add(mode);
        args.add(modeSpecificArg);
        args.add("-start_key");
        args.add(String.valueOf(startKey));
        args.add("-num_keys");
        args.add(String.valueOf(numKeys));
        args.add("-skip_init");
        return args.toArray(new String[args.size()]);
    }

    private String getColumnFamiliesAsString() {
        return StringUtils.join((CharSequence)",", this.getColumnFamilies());
    }

    protected long getNumKeys(long keysPerServer) throws IOException {
        int numRegionServers = this.cluster.getClusterMetrics().getLiveServerMetrics().size();
        return keysPerServer * (long)numRegionServers;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngest(), (String[])args);
        System.exit(ret);
    }
}

