/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.FileMmapIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SharedMemoryMmapIOEngine
extends FileMmapIOEngine {
    public SharedMemoryMmapIOEngine(String filePath, long capacity) throws IOException {
        super(filePath, capacity);
    }

    @Override
    public boolean usesSharedMemory() {
        return true;
    }

    @Override
    public Cacheable read(long offset, int length, CacheableDeserializer<Cacheable> deserializer) throws IOException {
        ByteBuff dstBuffer = this.bufferArray.asSubByteBuff(offset, length);
        return deserializer.deserialize(dstBuffer, true, Cacheable.MemoryType.SHARED);
    }
}

