/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.ServiceException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTokenUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTokenUtil.class);

    @Test
    public void testObtainToken() throws Exception {
        URLClassLoader cl;
        block3: {
            URL urlPU = ProtobufUtil.class.getProtectionDomain().getCodeSource().getLocation();
            URL urlTU = TokenUtil.class.getProtectionDomain().getCodeSource().getLocation();
            cl = new URLClassLoader(new URL[]{urlPU, urlTU}, this.getClass().getClassLoader());
            ServiceException injected = new ServiceException("injected");
            Class<?> tokenUtil = cl.loadClass(TokenUtil.class.getCanonicalName());
            Field shouldInjectFault = tokenUtil.getDeclaredField("injectedException");
            shouldInjectFault.setAccessible(true);
            shouldInjectFault.set(null, injected);
            try {
                tokenUtil.getMethod("obtainToken", Connection.class).invoke(null, new Object[]{null});
                Assert.fail((String)"Should have injected exception.");
            }
            catch (InvocationTargetException e) {
                Throwable t = e;
                boolean serviceExceptionFound = false;
                while ((t = ((Throwable)t).getCause()) != null) {
                    if (t != injected) continue;
                    serviceExceptionFound = true;
                    break;
                }
                if (serviceExceptionFound) break block3;
                throw e;
            }
        }
        Boolean loaded = (Boolean)cl.loadClass(ProtobufUtil.class.getCanonicalName()).getDeclaredMethod("isClassLoaderLoaded", new Class[0]).invoke(null, new Object[0]);
        Assert.assertFalse((String)"Should not have loaded DynamicClassLoader", (boolean)loaded);
    }
}

