/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.FailedCloseWALAfterInitializedErrorException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.FSHLogProvider;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALOpenError {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALOpenError.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestWALOpenError.class);
    protected static Configuration conf;
    private static MiniDFSCluster cluster;
    protected static final HBaseTestingUtility TEST_UTIL;
    protected static Path hbaseDir;
    protected static Path hbaseWALDir;
    protected FileSystem fs;
    protected Path dir;
    protected WALFactory wals;
    private ServerName currentServername;
    @Rule
    public final TestName currentTest = new TestName();
    private static MyFSLog myFSLogCreated;
    private static boolean throwExceptionWhenCloseFSLogClose;

    @Before
    public void setUp() throws Exception {
        this.fs = cluster.getFileSystem();
        this.dir = new Path(hbaseDir, this.currentTest.getMethodName());
        this.currentServername = ServerName.valueOf((String)this.currentTest.getMethodName(), (int)16010, (long)1L);
        this.wals = new WALFactory(conf, this.currentServername.toString());
    }

    @After
    public void tearDown() throws Exception {
        FileStatus[] entries;
        try {
            this.wals.close();
        }
        catch (IOException exception) {
            LOG.warn("Encountered exception while closing wal factory. If you have other errors, this may be the cause. Message: " + exception);
            LOG.debug("Exception details for failure to close wal factory.", (Throwable)exception);
        }
        for (FileStatus dir : entries = this.fs.listStatus(new Path("/"))) {
            this.fs.delete(dir.getPath(), true);
        }
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniDFSCluster(3);
        conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.wal.provider", MyFSWalProvider.class.getName());
        conf.set("hbase.wal.meta_provider", MyFSWalProvider.class.getName());
        cluster = TEST_UTIL.getDFSCluster();
        hbaseDir = TEST_UTIL.createRootDir();
        hbaseWALDir = TEST_UTIL.createWALRootDir();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testWALClosedIfOpenError() throws IOException {
        throwExceptionWhenCloseFSLogClose = false;
        boolean hasFakeInitException = false;
        try {
            this.wals.getWAL((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        }
        catch (IOException ex) {
            hasFakeInitException = ex.getMessage().contains("Fake init exception");
        }
        Assert.assertTrue((boolean)hasFakeInitException);
        Assert.assertTrue((boolean)TestWALOpenError.myFSLogCreated.closed);
        FileStatus[] fileStatuses = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)TestWALOpenError.myFSLogCreated.walDir);
        Assert.assertTrue((fileStatuses == null || fileStatuses.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testThrowFailedCloseWalException() throws IOException {
        throwExceptionWhenCloseFSLogClose = true;
        boolean failedCloseWalException = false;
        try {
            this.wals.getWAL((RegionInfo)HRegionInfo.FIRST_META_REGIONINFO);
        }
        catch (FailedCloseWALAfterInitializedErrorException ex) {
            failedCloseWalException = true;
        }
        Assert.assertTrue((boolean)failedCloseWalException);
    }

    static {
        TEST_UTIL = new HBaseTestingUtility();
        throwExceptionWhenCloseFSLogClose = false;
    }

    public static class MyFSLog
    extends FSHLog {
        public MyFSLog(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
        }

        public void init() throws IOException {
            super.init();
            throw new IOException("Fake init exception");
        }

        public void close() throws IOException {
            if (throwExceptionWhenCloseFSLogClose) {
                throw new IOException("Fake close exception");
            }
            super.close();
        }
    }

    public static class MyFSWalProvider
    extends FSHLogProvider {
        protected MyFSLog createWAL() throws IOException {
            MyFSLog myFSLog = new MyFSLog(CommonFSUtils.getWALFileSystem((Configuration)this.conf), CommonFSUtils.getWALRootDir((Configuration)this.conf), MyFSWalProvider.getWALDirectoryName((String)this.factory.getFactoryId()), MyFSWalProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.getFactoryId()), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? META_WAL_PROVIDER_ID : null);
            myFSLogCreated = myFSLog;
            return myFSLog;
        }
    }
}

