/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, MediumTests.class})
public class TestShutdownWhileWALBroken {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestShutdownWhileWALBroken.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestShutdownWhileWALBroken.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"TestShutdownWhileWALBroken");
    private static byte[] CF = Bytes.toBytes((String)"CF");
    @Parameterized.Parameter
    public String walType;

    @Parameterized.Parameters(name="{index}: WAL={0}")
    public static List<Object[]> params() {
        return Arrays.asList({"asyncfs"}, {"filesystem"});
    }

    @Before
    public void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.regionserver.impl", MyRegionServer.class, HRegionServer.class);
        UTIL.getConfiguration().set("hbase.wal.provider", this.walType);
        UTIL.startMiniCluster(2);
    }

    @After
    public void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        JVMClusterUtil.RegionServerThread toKillRSThread;
        HRegionServer liveRS;
        UTIL.createMultiRegionTable(TABLE_NAME, CF);
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            UTIL.loadTable(table, CF);
        }
        final int numRegions = UTIL.getMiniHBaseCluster().getRegions(TABLE_NAME).size();
        JVMClusterUtil.RegionServerThread rst0 = UTIL.getMiniHBaseCluster().getRegionServerThreads().get(0);
        JVMClusterUtil.RegionServerThread rst1 = UTIL.getMiniHBaseCluster().getRegionServerThreads().get(1);
        if (rst1.getRegionServer().getRegions(TableName.META_TABLE_NAME).isEmpty()) {
            liveRS = rst0.getRegionServer();
            toKillRSThread = rst1;
        } else {
            liveRS = rst1.getRegionServer();
            toKillRSThread = rst0;
        }
        Assert.assertTrue((liveRS.getRegions(TABLE_NAME).size() < numRegions ? 1 : 0) != 0);
        UTIL.expireSession(toKillRSThread.getRegionServer().getZooKeeper(), false);
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return liveRS.getRegions(TABLE_NAME).size() == numRegions;
            }

            public String explainFailure() throws Exception {
                return "Failover is not finished yet";
            }
        });
        toKillRSThread.getRegionServer().stop("Stop for test");
        toKillRSThread.join();
    }

    public static final class MyRegionServer
    extends HRegionServer {
        private final CountDownLatch latch = new CountDownLatch(1);

        public MyRegionServer(Configuration conf) throws IOException {
            super(conf);
        }

        protected void tryRegionServerReport(long reportStartTime, long reportEndTime) throws IOException {
            try {
                super.tryRegionServerReport(reportStartTime, reportEndTime);
            }
            catch (YouAreDeadException e) {
                LOG.info("Caught YouAreDeadException, ignore", (Throwable)e);
            }
        }

        public void abort(String reason, Throwable cause) {
            if (cause instanceof KeeperException.SessionExpiredException) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.latch.countDown();
            }
            super.abort(reason, cause);
        }
    }
}

