/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestMinorCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMinorCompaction.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger((String)TestMinorCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = HBaseTestingUtility.createLocalHTU();
    protected Configuration conf = UTIL.getConfiguration();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private int compactionThreshold;
    private byte[] firstRowBytes;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private final byte[] col1;
    private final byte[] col2;

    public TestMinorCompaction() {
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.firstRowBytes = HBaseTestingUtility.START_KEY_BYTES;
        this.secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] = (byte)(this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] + 2);
        this.col1 = Bytes.toBytes((String)"column1");
        this.col2 = Bytes.toBytes((String)"column2");
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName());
        this.r = UTIL.createLocalHRegion((TableDescriptor)this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.r.getWAL();
        this.r.close();
        wal.close();
    }

    @Test
    public void testMinorCompactionWithDeleteRow() throws Exception {
        Delete deleteRow = new Delete(this.secondRowBytes);
        this.testMinorCompactionWithDelete(deleteRow);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn1() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.addColumns(HBaseTestingUtility.fam2, this.col2);
        this.testMinorCompactionWithDelete(dc);
    }

    @Test
    public void testMinorCompactionWithDeleteColumn2() throws Exception {
        Delete dc = new Delete(this.secondRowBytes);
        dc.addColumn(HBaseTestingUtility.fam2, this.col2);
        this.testMinorCompactionWithDelete(dc, 3);
    }

    @Test
    public void testMinorCompactionWithDeleteColumnFamily() throws Exception {
        Delete deleteCF = new Delete(this.secondRowBytes);
        deleteCF.addFamily(HBaseTestingUtility.fam2);
        this.testMinorCompactionWithDelete(deleteCF);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion1() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.addColumns(HBaseTestingUtility.fam2, this.col2, 2L);
        this.testMinorCompactionWithDelete(deleteVersion, 1);
    }

    @Test
    public void testMinorCompactionWithDeleteVersion2() throws Exception {
        Delete deleteVersion = new Delete(this.secondRowBytes);
        deleteVersion.addColumn(HBaseTestingUtility.fam2, this.col2, 1L);
        this.testMinorCompactionWithDelete(deleteVersion, 3);
    }

    private void testMinorCompactionWithDelete(Delete delete) throws Exception {
        this.testMinorCompactionWithDelete(delete, 0);
    }

    private void testMinorCompactionWithDelete(Delete delete, int expectedResultsAfterDelete) throws Exception {
        RegionAsTable loader = new RegionAsTable((Region)this.r);
        for (int i = 0; i < this.compactionThreshold + 1; ++i) {
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam1), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col1), this.firstRowBytes, this.thirdRowBytes, i);
            HBaseTestCase.addContent(loader, Bytes.toString((byte[])HBaseTestingUtility.fam2), Bytes.toString((byte[])this.col2), this.firstRowBytes, this.thirdRowBytes, i);
            this.r.flush(true);
        }
        Result result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        this.r.delete(delete);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        this.r.flush(true);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        HStore store2 = this.r.getStore(HBaseTestingUtility.fam2);
        int numFiles1 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Was expecting to see 4 store files", (numFiles1 > this.compactionThreshold ? 1 : 0) != 0);
        store2.compactRecentForTestingAssumingDefaultPolicy(this.compactionThreshold);
        int numFiles2 = store2.getStorefiles().size();
        Assert.assertTrue((String)"Number of store files should go down", (numFiles1 > numFiles2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Was not supposed to be a major compaction", (numFiles2 > 1 ? 1 : 0) != 0);
        result = this.r.get(new Get(this.secondRowBytes).addColumn(HBaseTestingUtility.fam2, this.col2).setMaxVersions(100));
        Assert.assertEquals((long)expectedResultsAfterDelete, (long)result.size());
        result = this.r.get(new Get(this.firstRowBytes).addColumn(HBaseTestingUtility.fam1, this.col1).setMaxVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
    }
}

