/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionAsTable;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequestImpl;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestMajorCompaction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMajorCompaction.class);
    @Rule
    public TestName name;
    private static final Logger LOG = LoggerFactory.getLogger((String)TestMajorCompaction.class.getName());
    private static final HBaseTestingUtility UTIL = HBaseTestingUtility.createLocalHTU();
    protected Configuration conf = UTIL.getConfiguration();
    private HRegion r = null;
    private HTableDescriptor htd = null;
    private static final byte[] COLUMN_FAMILY = HBaseTestingUtility.fam1;
    private final byte[] STARTROW = Bytes.toBytes((String)HBaseTestingUtility.START_KEY);
    private static final byte[] COLUMN_FAMILY_TEXT = COLUMN_FAMILY;
    private int compactionThreshold;
    private byte[] secondRowBytes;
    private byte[] thirdRowBytes;
    private static final long MAX_FILES_TO_COMPACT = 10L;

    @Parameterized.Parameters
    public static Object[] data() {
        return new Object[]{"NONE", "BASIC", "EAGER"};
    }

    public TestMajorCompaction(String compType) {
        this.name = new TestName();
        this.conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        this.conf.setInt("hbase.hregion.memstore.block.multiplier", 100);
        this.compactionThreshold = this.conf.getInt("hbase.hstore.compactionThreshold", 3);
        this.conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(compType));
        this.secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        this.secondRowBytes[n] = (byte)(this.secondRowBytes[n] + 1);
        this.thirdRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] = (byte)(this.thirdRowBytes[HBaseTestingUtility.START_KEY_BYTES.length - 1] + 2);
    }

    @Before
    public void setUp() throws Exception {
        this.htd = UTIL.createTableDescriptor(this.name.getMethodName().replace('[', 'i').replace(']', 'i'));
        this.r = UTIL.createLocalHRegion((TableDescriptor)this.htd, null, null);
    }

    @After
    public void tearDown() throws Exception {
        WAL wal = this.r.getWAL();
        this.r.close();
        wal.close();
    }

    @Test
    public void testMajorCompactingToNoOutput() throws IOException {
        this.testMajorCompactingWithDeletes(KeepDeletedCells.FALSE);
    }

    @Test
    public void testMajorCompactingWithKeepDeletedCells() throws IOException {
        this.testMajorCompactingWithDeletes(KeepDeletedCells.TRUE);
    }

    @Test
    public void testMajorCompaction() throws Exception {
        this.majorCompaction();
    }

    @Test
    public void testDataBlockEncodingInCacheOnly() throws Exception {
        this.majorCompactionWithDataBlockEncoding(true);
    }

    @Test
    public void testDataBlockEncodingEverywhere() throws Exception {
        this.majorCompactionWithDataBlockEncoding(false);
    }

    public void majorCompactionWithDataBlockEncoding(boolean inCacheOnly) throws Exception {
        HashMap<HStore, HFileDataBlockEncoder> replaceBlockCache = new HashMap<HStore, HFileDataBlockEncoder>();
        for (HStore hStore : this.r.getStores()) {
            HFileDataBlockEncoder blockEncoder = hStore.getDataBlockEncoder();
            replaceBlockCache.put(hStore, blockEncoder);
            DataBlockEncoding inCache = DataBlockEncoding.PREFIX;
            DataBlockEncoding onDisk = inCacheOnly ? DataBlockEncoding.NONE : inCache;
            hStore.setDataBlockEncoderInTest((HFileDataBlockEncoder)new HFileDataBlockEncoderImpl(onDisk));
        }
        this.majorCompaction();
        for (Map.Entry entry : replaceBlockCache.entrySet()) {
            ((HStore)entry.getKey()).setDataBlockEncoderInTest((HFileDataBlockEncoder)entry.getValue());
        }
    }

    private void majorCompaction() throws Exception {
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        HBaseTestCase.addContent(new RegionAsTable((Region)this.r), Bytes.toString((byte[])COLUMN_FAMILY));
        Result result = this.r.get(new Get(this.STARTROW).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        Assert.assertEquals((long)this.compactionThreshold, (long)result.size());
        for (Object store : this.r.getStores()) {
            Assert.assertNull((Object)store.getCompactionProgress());
        }
        this.r.flush(true);
        this.r.compact(true);
        int storeCount = 0;
        for (HStore store : this.r.getStores()) {
            CompactionProgress progress = store.getCompactionProgress();
            if (progress != null) {
                ++storeCount;
                Assert.assertTrue((progress.currentCompactedKVs > 0L ? 1 : 0) != 0);
                Assert.assertTrue((progress.getTotalCompactingKVs() > 0L ? 1 : 0) != 0);
            }
            Assert.assertTrue((storeCount > 0 ? 1 : 0) != 0);
        }
        byte[] secondRowBytes = (byte[])HBaseTestingUtility.START_KEY_BYTES.clone();
        int n = HBaseTestingUtility.START_KEY_BYTES.length - 1;
        secondRowBytes[n] = (byte)(secondRowBytes[n] + 1);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        LOG.debug("Row " + Bytes.toStringBinary((byte[])secondRowBytes) + " after " + "initial compaction: " + result);
        Assert.assertEquals((String)("Invalid number of versions of row " + Bytes.toStringBinary((byte[])secondRowBytes) + "."), (long)this.compactionThreshold, (long)result.size());
        LOG.debug("Adding deletes to memstore and flushing");
        Delete delete = new Delete(secondRowBytes, System.currentTimeMillis());
        byte[][] famAndQf = new byte[][]{COLUMN_FAMILY, null};
        delete.addFamily(famAndQf[0]);
        this.r.delete(delete);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        Assert.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.r.flush(true);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        Assert.assertTrue((String)"Second row should have been deleted", (boolean)result.isEmpty());
        this.createSmallerStoreFile(this.r);
        this.r.flush(true);
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        Assert.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.r.compact(true);
        Assert.assertEquals((long)1L, (long)this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles().size());
        result = this.r.get(new Get(secondRowBytes).addFamily(COLUMN_FAMILY_TEXT).readVersions(100));
        Assert.assertTrue((String)"Second row should still be deleted", (boolean)result.isEmpty());
        this.verifyCounts(3, 0);
        int ttl = 1000;
        for (HStore store : this.r.getStores()) {
            ScanInfo old = store.getScanInfo();
            ScanInfo si = old.customize(old.getMaxVersions(), 1000L, old.getKeepDeletedCells());
            store.setScanInfo(si);
        }
        Thread.sleep(1000L);
        this.r.compact(true);
        int count = this.count();
        Assert.assertEquals((String)"Should not see anything after TTL has expired", (long)0L, (long)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeBasedMajorCompaction() throws Exception {
        int delay = 10000;
        float jitterPct = 0.2f;
        this.conf.setLong("hbase.hregion.majorcompaction", (long)delay);
        this.conf.setFloat("hbase.hregion.majorcompaction.jitter", jitterPct);
        HStore s = this.r.getStore(COLUMN_FAMILY);
        s.storeEngine.getCompactionPolicy().setConf(this.conf);
        try {
            this.createStoreFile(this.r);
            this.createStoreFile(this.r);
            this.r.compact(true);
            this.createStoreFile(this.r);
            this.r.compact(false);
            Assert.assertEquals((long)2L, (long)s.getStorefilesCount());
            RatioBasedCompactionPolicy c = (RatioBasedCompactionPolicy)s.storeEngine.getCompactionPolicy();
            Collection storeFiles = s.getStorefiles();
            long mcTime = c.getNextMajorCompactTime(storeFiles);
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((long)mcTime, (long)c.getNextMajorCompactTime(storeFiles));
            }
            long jitter = Math.round((float)delay * jitterPct);
            Assert.assertTrue(((long)delay - jitter <= mcTime && mcTime <= (long)delay + jitter ? 1 : 0) != 0);
            Thread.sleep(mcTime);
            this.r.compact(false);
            Assert.assertEquals((long)1L, (long)s.getStorefilesCount());
        }
        finally {
            this.conf.setLong("hbase.hregion.majorcompaction", 86400000L);
            this.conf.setFloat("hbase.hregion.majorcompaction.jitter", 0.2f);
            this.createStoreFile(this.r);
            this.r.compact(true);
            Assert.assertEquals((long)1L, (long)s.getStorefilesCount());
        }
    }

    private void verifyCounts(int countRow1, int countRow2) throws Exception {
        int count1 = 0;
        int count2 = 0;
        for (HStoreFile f : this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            scanner.seekTo();
            do {
                byte[] row;
                if (Bytes.equals((byte[])(row = CellUtil.cloneRow((Cell)scanner.getCell())), (byte[])this.STARTROW)) {
                    ++count1;
                    continue;
                }
                if (!Bytes.equals((byte[])row, (byte[])this.secondRowBytes)) continue;
                ++count2;
            } while (scanner.next());
        }
        Assert.assertEquals((long)countRow1, (long)count1);
        Assert.assertEquals((long)countRow2, (long)count2);
    }

    private int count() throws IOException {
        int count = 0;
        for (HStoreFile f : this.r.getStore(COLUMN_FAMILY_TEXT).getStorefiles()) {
            HFileScanner scanner = f.getReader().getScanner(false, false);
            if (!scanner.seekTo()) continue;
            do {
                ++count;
            } while (scanner.next());
        }
        return count;
    }

    private void createStoreFile(HRegion region) throws IOException {
        this.createStoreFile(region, Bytes.toString((byte[])COLUMN_FAMILY));
    }

    private void createStoreFile(HRegion region, String family) throws IOException {
        RegionAsTable loader = new RegionAsTable((Region)region);
        HBaseTestCase.addContent(loader, family);
        region.flush(true);
    }

    private void createSmallerStoreFile(HRegion region) throws IOException {
        RegionAsTable loader = new RegionAsTable((Region)region);
        HBaseTestCase.addContent(loader, Bytes.toString((byte[])COLUMN_FAMILY), Bytes.toBytes((String)"bbb"), null);
        region.flush(true);
    }

    @Test
    public void testNonUserMajorCompactionRequest() throws Exception {
        HStore store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequestImpl request = ((CompactionContext)store.requestCompaction().get()).getRequest();
        Assert.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        Assert.assertEquals((String)"System-requested major compaction should not occur if there are too many store files", (Object)false, (Object)request.isMajor());
    }

    @Test
    public void testUserMajorCompactionRequest() throws IOException {
        HStore store = this.r.getStore(COLUMN_FAMILY);
        this.createStoreFile(this.r);
        int i = 0;
        while ((long)i < 11L) {
            this.createStoreFile(this.r);
            ++i;
        }
        store.triggerMajorCompaction();
        CompactionRequestImpl request = ((CompactionContext)store.requestCompaction(1, CompactionLifeCycleTracker.DUMMY, null).get()).getRequest();
        Assert.assertNotNull((String)"Expected to receive a compaction request", (Object)request);
        Assert.assertEquals((String)"User-requested major compaction should always occur, even if there are too many store files", (Object)true, (Object)request.isMajor());
    }

    @Test
    public void testMajorCompactingToNoOutputWithReverseScan() throws IOException {
        ArrayList results;
        boolean result;
        boolean result2;
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        Scan scan = new Scan();
        scan.setReversed(true);
        HRegion.RegionScannerImpl s = this.r.getScanner(scan);
        do {
            ArrayList results2 = new ArrayList();
            result2 = s.next(results2);
            Assert.assertTrue((!results2.isEmpty() ? 1 : 0) != 0);
            this.r.delete(new Delete(CellUtil.cloneRow((Cell)((Cell)results2.get(0)))));
        } while (result2);
        s.close();
        this.r.flush(true);
        this.r.compact(true);
        scan = new Scan();
        scan.setReversed(true);
        s = this.r.getScanner(scan);
        int counter = 0;
        while (result = s.next(results = new ArrayList())) {
            ++counter;
        }
        s.close();
        Assert.assertEquals((long)0L, (long)counter);
    }

    private void testMajorCompactingWithDeletes(KeepDeletedCells keepDeletedCells) throws IOException {
        ArrayList results;
        boolean result;
        this.createStoreFile(this.r);
        for (int i = 0; i < this.compactionThreshold; ++i) {
            this.createStoreFile(this.r);
        }
        HRegion.RegionScannerImpl s = this.r.getScanner(new Scan());
        int originalCount = 0;
        while (true) {
            ArrayList results2 = new ArrayList();
            boolean result2 = s.next(results2);
            this.r.delete(new Delete(CellUtil.cloneRow((Cell)((Cell)results2.get(0)))));
            if (!result2) break;
            ++originalCount;
        }
        s.close();
        this.r.flush(true);
        for (HStore store : this.r.stores.values()) {
            ScanInfo old = store.getScanInfo();
            ScanInfo si = old.customize(old.getMaxVersions(), old.getTtl(), keepDeletedCells);
            store.setScanInfo(si);
        }
        this.r.compact(true);
        s = this.r.getScanner(new Scan().setRaw(true));
        int counter = 0;
        while (result = s.next(results = new ArrayList())) {
            ++counter;
        }
        Assert.assertEquals((long)(keepDeletedCells == KeepDeletedCells.TRUE ? (long)originalCount : 0L), (long)counter);
    }
}

