/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestEncryptionKeyRotation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestEncryptionKeyRotation.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestEncryptionKeyRotation.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final Key initialCFKey;
    private static final Key secondCFKey;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCFKeyRotation() throws Exception {
        final HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"default", (String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        hcd.setEncryptionType(algorithm);
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)initialCFKey));
        htd.addFamily(hcd);
        this.createTableAndFlush(htd);
        List<Path> initialPaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((initialPaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : initialPaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
        hcd = htd.getFamily(Bytes.toBytes((String)"cf"));
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)secondCFKey));
        TEST_UTIL.getAdmin().modifyColumnFamily(htd.getTableName(), (ColumnFamilyDescriptor)hcd);
        Thread.sleep(5000L);
        TEST_UTIL.getAdmin().majorCompact(htd.getTableName());
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<IOException>(){

            public boolean evaluate() throws IOException {
                return TEST_UTIL.getAdmin().getCompactionState(htd.getTableName()) == CompactionState.NONE;
            }
        });
        List<Path> pathsAfterCompaction = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((pathsAfterCompaction.size() > 0 ? 1 : 0) != 0);
        for (Path path : pathsAfterCompaction) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])secondCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
        List<Path> list = TestEncryptionKeyRotation.findCompactedStorefilePaths(htd.getTableName());
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        for (Path path : list) {
            Assert.assertTrue((String)("Store file " + path + " retains initial key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
    }

    @Test
    public void testMasterKeyRotation() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"default", (String)this.name.getMethodName()));
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        hcd.setEncryptionType(algorithm);
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)conf, (String)"hbase", (Key)initialCFKey));
        htd.addFamily(hcd);
        this.createTableAndFlush(htd);
        List<Path> storeFilePaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((storeFilePaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : storeFilePaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
        TEST_UTIL.shutdownMiniHBaseCluster();
        conf.set("hbase.crypto.master.key.name", "other");
        conf.set("hbase.crypto.master.alternate.key.name", "hbase");
        TEST_UTIL.startMiniHBaseCluster();
        TEST_UTIL.waitTableAvailable(htd.getTableName(), 5000L);
        storeFilePaths = TestEncryptionKeyRotation.findStorefilePaths(htd.getTableName());
        Assert.assertTrue((storeFilePaths.size() > 0 ? 1 : 0) != 0);
        for (Path path : storeFilePaths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])initialCFKey.getEncoded(), (byte[])TestEncryptionKeyRotation.extractHFileKey(path)));
        }
    }

    private static List<Path> findStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Region region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegions(tableName)) {
            for (HStore store : ((HRegion)region).getStores()) {
                for (HStoreFile storefile : store.getStorefiles()) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    private static List<Path> findCompactedStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Region region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegions(tableName)) {
            for (HStore store : ((HRegion)region).getStores()) {
                Collection compactedfiles = store.getStoreEngine().getStoreFileManager().getCompactedfiles();
                if (compactedfiles == null) continue;
                for (HStoreFile storefile : compactedfiles) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableAndFlush(HTableDescriptor htd) throws Exception {
        HColumnDescriptor hcd = (HColumnDescriptor)htd.getFamilies().iterator().next();
        TEST_UTIL.getAdmin().createTable((TableDescriptor)htd);
        TEST_UTIL.waitTableAvailable(htd.getTableName(), 5000L);
        try (Table table = TEST_UTIL.getConnection().getTable(htd.getTableName());){
            table.put(new Put(Bytes.toBytes((String)"testrow")).addColumn(hcd.getName(), Bytes.toBytes((String)"q"), Bytes.toBytes((String)"value")));
        }
        TEST_UTIL.getAdmin().flush(htd.getTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] extractHFileKey(Path path) throws Exception {
        try (HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)path, (CacheConfig)new CacheConfig(conf), (boolean)true, (Configuration)conf);){
            reader.loadFileInfo();
            Encryption.Context cryptoContext = reader.getFileContext().getEncryptionContext();
            Assert.assertNotNull((String)"Reader has a null crypto context", (Object)cryptoContext);
            Key key = cryptoContext.getKey();
            Assert.assertNotNull((String)"Crypto context has no key", (Object)key);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
    }

    static {
        SecureRandom rng = new SecureRandom();
        byte[] keyBytes = new byte[16];
        rng.nextBytes(keyBytes);
        String algorithm = conf.get("hbase.crypto.key.algorithm", "AES");
        initialCFKey = new SecretKeySpec(keyBytes, algorithm);
        rng.nextBytes(keyBytes);
        secondCFKey = new SecretKeySpec(keyBytes, algorithm);
    }
}

