/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaCache;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestClusterScopeQuotaThrottle {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterScopeQuotaThrottle.class);
    private static final int REFRESH_TIME = 1800000;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName[] TABLE_NAMES = new TableName[]{TableName.valueOf((String)"TestQuotaAdmin0"), TableName.valueOf((String)"TestQuotaAdmin1"), TableName.valueOf((String)"TestQuotaAdmin2")};
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[][] SPLITS = new byte[][]{Bytes.toBytes((String)"1")};
    private static Table[] tables;
    private static final String NAMESPACE = "TestNs";
    private static final TableName TABLE_NAME;
    private static Table table;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 1800000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        QuotaCache.TEST_FORCE_REFRESH = true;
        tables = new Table[TABLE_NAMES.length];
        for (int i = 0; i < TABLE_NAMES.length; ++i) {
            TestClusterScopeQuotaThrottle.tables[i] = TEST_UTIL.createTable(TABLE_NAMES[i], FAMILY);
            TEST_UTIL.waitTableAvailable(TABLE_NAMES[i]);
        }
        TEST_UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)NAMESPACE).build());
        table = TEST_UTIL.createTable(TABLE_NAME, FAMILY, SPLITS);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        EnvironmentEdgeManager.reset();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == null) continue;
            tables[i].close();
            TEST_UTIL.deleteTable(TABLE_NAMES[i]);
        }
        TEST_UTIL.deleteTable(TABLE_NAME);
        TEST_UTIL.getAdmin().deleteNamespace(NAMESPACE);
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
    }

    @Test
    public void testNamespaceClusterScopeQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String NAMESPACE = "default";
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.WRITE_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)"default", (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.MACHINE));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doGets(10, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)"default"));
        ThrottleQuotaTestUtil.triggerNamespaceCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testTableClusterScopeQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAME, (ThrottleType)ThrottleType.READ_NUMBER, (long)20L, (TimeUnit)TimeUnit.HOURS, (QuotaScope)QuotaScope.CLUSTER));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        block0: for (JVMClusterUtil.RegionServerThread rst : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            for (TableName tableName : rst.getRegionServer().getOnlineTables()) {
                if (!tableName.getNameAsString().equals(TABLE_NAME.getNameAsString())) continue;
                int rsRegionNum = rst.getRegionServer().getRegions(tableName).size();
                if (rsRegionNum == 0) continue block0;
                if (rsRegionNum == 1) {
                    long count = ThrottleQuotaTestUtil.doGets(20, table);
                    Assert.assertTrue((count == 0L || count == 10L ? 1 : 0) != 0);
                    continue block0;
                }
                if (rsRegionNum != 2) continue block0;
                Assert.assertEquals((long)20L, (long)ThrottleQuotaTestUtil.doGets(20, table));
                continue block0;
            }
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAME));
        ThrottleQuotaTestUtil.triggerTableCacheRefresh(TEST_UTIL, true, TABLE_NAME);
    }

    @Test
    public void testUserClusterScopeQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES);
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        Assert.assertEquals((long)3L, (long)ThrottleQuotaTestUtil.doGets(10, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES);
    }

    @Test
    public void testUserNamespaceClusterScopeQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String namespace = TABLE_NAMES[0].getNamespaceAsString();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)namespace, (ThrottleType)ThrottleType.READ_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)namespace, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAMES[0]);
        Assert.assertEquals((long)5L, (long)ThrottleQuotaTestUtil.doGets(10, tables[0]));
        Assert.assertEquals((long)6L, (long)ThrottleQuotaTestUtil.doPuts(10, FAMILY, QUALIFIER, tables[0]));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName, (String)namespace));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAMES[0]);
    }

    @Test
    public void testUserTableClusterScopeQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAME, (ThrottleType)ThrottleType.READ_NUMBER, (long)20L, (TimeUnit)TimeUnit.HOURS, (QuotaScope)QuotaScope.CLUSTER));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        block0: for (JVMClusterUtil.RegionServerThread rst : TEST_UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            for (TableName tableName : rst.getRegionServer().getOnlineTables()) {
                if (!tableName.getNameAsString().equals(TABLE_NAME.getNameAsString())) continue;
                int rsRegionNum = rst.getRegionServer().getRegions(tableName).size();
                if (rsRegionNum == 0) continue block0;
                if (rsRegionNum == 1) {
                    long count = ThrottleQuotaTestUtil.doGets(20, table);
                    Assert.assertTrue((count == 0L || count == 10L ? 1 : 0) != 0);
                    continue block0;
                }
                if (rsRegionNum != 2) continue block0;
                Assert.assertEquals((long)20L, (long)ThrottleQuotaTestUtil.doGets(20, table));
                continue block0;
            }
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
    }

    static {
        TABLE_NAME = TableName.valueOf((String)NAMESPACE, (String)"TestTable");
    }
}

