/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.Date;
import java.util.Random;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFileName {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFileName.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private String uuid;
    private Date date;
    private String dateStr;
    private byte[] startKey;
    private String regionName = "region";

    @Before
    public void setUp() {
        Random random = new Random();
        this.uuid = TEST_UTIL.getRandomUUID().toString().replaceAll("-", "");
        this.date = new Date();
        this.dateStr = MobUtils.formatDate((Date)this.date);
        this.startKey = Bytes.toBytes((int)random.nextInt());
    }

    @Test
    public void testHashCode() {
        Assert.assertEquals((long)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName).hashCode(), (long)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName).hashCode());
        Assert.assertNotSame((Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName), (Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName));
    }

    @Test
    public void testCreate() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName);
        Assert.assertEquals((Object)mobFileName, (Object)MobFileName.create((String)mobFileName.getFileName()));
    }

    @Test
    public void testGet() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName);
        Assert.assertEquals((Object)MD5Hash.getMD5AsHex((byte[])this.startKey, (int)0, (int)this.startKey.length), (Object)mobFileName.getStartKey());
        Assert.assertEquals((Object)this.dateStr, (Object)mobFileName.getDate());
        Assert.assertEquals((Object)mobFileName.getFileName(), (Object)(MD5Hash.getMD5AsHex((byte[])this.startKey, (int)0, (int)this.startKey.length) + this.dateStr + this.uuid + "_" + this.regionName));
    }

    @Test
    public void testEquals() {
        MobFileName mobFileName = MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName);
        Assert.assertTrue((boolean)mobFileName.equals((Object)mobFileName));
        Assert.assertFalse((boolean)mobFileName.equals((Object)this));
        Assert.assertTrue((boolean)mobFileName.equals((Object)MobFileName.create((byte[])this.startKey, (String)this.dateStr, (String)this.uuid, (String)this.regionName)));
    }
}

