/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobFileCleanerChore;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestMobFileCleanerChore {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobFileCleanerChore.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobFileCleanerChore.class);
    private HBaseTestingUtility HTU;
    private static final String famStr = "f1";
    private static final byte[] fam = Bytes.toBytes((String)"f1");
    private static final byte[] qualifier = Bytes.toBytes((String)"q1");
    private static final long mobLen = 10L;
    private static final byte[] mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    private Configuration conf;
    private HTableDescriptor hdt;
    private HColumnDescriptor hcd;
    private Admin admin;
    private Table table = null;
    private MobFileCleanerChore chore;
    private long minAgeToArchive = 10000L;

    @Before
    public void setUp() throws Exception {
        this.HTU = new HBaseTestingUtility();
        this.hdt = this.HTU.createTableDescriptor("testMobCompactTable");
        this.conf = this.HTU.getConfiguration();
        this.initConf();
        this.HTU.startMiniCluster();
        this.admin = this.HTU.getAdmin();
        this.chore = new MobFileCleanerChore();
        this.hcd = new HColumnDescriptor(fam);
        this.hcd.setMobEnabled(true);
        this.hcd.setMobThreshold(10L);
        this.hcd.setMaxVersions(1);
        this.hdt.addFamily(this.hcd);
        this.table = this.HTU.createTable((TableDescriptor)this.hdt, (byte[][])null);
    }

    private void initConf() {
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setLong("hbase.master.hfilecleaner.ttl", 0L);
        this.conf.setInt("hbase.client.retries.number", 100);
        this.conf.setInt("hbase.hregion.max.filesize", 200000000);
        this.conf.setInt("hbase.hregion.memstore.flush.size", 800000);
        this.conf.setInt("hbase.hstore.blockingStoreFiles", 150);
        this.conf.setInt("hbase.hstore.compaction.throughput.lower.bound", 0x3200000);
        this.conf.setInt("hbase.hstore.compaction.throughput.higher.bound", 0x6400000);
        this.conf.setLong("hbase.mob.compaction.chore.period", 0L);
        this.conf.setLong("hbase.master.mob.cleaner.period", 0L);
        this.conf.setLong("hbase.mob.min.age.archive", this.minAgeToArchive);
        this.conf.setLong("hbase.hfile.compaction.discharger.interval", this.minAgeToArchive / 2L);
    }

    private void loadData(int start, int num) {
        try {
            for (int i = 0; i < num; ++i) {
                Put p = new Put(Bytes.toBytes((int)(start + i)));
                p.addColumn(fam, qualifier, mobVal);
                this.table.put(p);
            }
            this.admin.flush(this.table.getName());
        }
        catch (Exception e) {
            LOG.error("MOB file cleaner chore test FAILED", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.admin.disableTable(this.hdt.getTableName());
        this.admin.deleteTable(this.hdt.getTableName());
        this.HTU.shutdownMiniCluster();
    }

    @Test
    public void testMobFileCleanerChore() throws InterruptedException, IOException {
        this.loadData(0, 10);
        this.loadData(10, 10);
        this.loadData(20, 10);
        long num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)3L, (long)num);
        this.admin.majorCompact(this.hdt.getTableName(), fam);
        while (this.admin.getCompactionState(this.hdt.getTableName()) != CompactionState.NONE) {
            Thread.sleep(100L);
        }
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)4L, (long)num);
        LOG.info("Waiting for {}ms", (Object)(this.minAgeToArchive + 1000L));
        Thread.sleep(this.minAgeToArchive + 1000L);
        LOG.info("Cleaning up MOB files");
        this.chore.cleanupObsoleteMobFiles(this.conf, this.table.getName());
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)1L, (long)num);
        long scanned = this.scanTable();
        Assert.assertEquals((long)30L, (long)scanned);
    }

    private long getNumberOfMobFiles(Configuration conf, TableName tableName, String family) throws IOException {
        FileStatus[] stat;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        for (FileStatus st : stat = fs.listStatus(dir)) {
            LOG.debug("DDDD MOB Directory content: {} size={}", (Object)st.getPath(), (Object)st.getLen());
        }
        LOG.debug("MOB Directory content total files: {}", (Object)stat.length);
        return stat.length;
    }

    private long scanTable() {
        try {
            Result result;
            ResultScanner scanner = this.table.getScanner(fam);
            long counter = 0L;
            while ((result = scanner.next()) != null) {
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), mobVal));
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("MOB file cleaner chore test FAILED");
            if (this.HTU != null) {
                Assert.assertTrue((boolean)false);
            } else {
                System.exit(-1);
            }
            return 0L;
        }
    }
}

