/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobFileCompactionChore;
import org.apache.hadoop.hbase.mob.TestMobCompactionBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMobCompactionOptRegionBatchMode
extends TestMobCompactionBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactionOptRegionBatchMode.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactionOptRegionBatchMode.class);
    private int batchSize = 7;
    private MobFileCompactionChore compactionChore;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.compactionChore = new MobFileCompactionChore(this.conf, this.batchSize);
    }

    @Override
    protected void initConf() {
        super.initConf();
        this.conf.setInt("hbase.mob.major.compaction.region.batch.size", this.batchSize);
        this.conf.set("hbase.mob.compaction.type", "optimized");
        this.conf.setLong("hbase.mob.compactions.max.file.size", 1000000L);
    }

    @Test
    public void testMobFileCompactionBatchMode() throws InterruptedException, IOException {
        LOG.info("MOB compaction chore generational batch mode started");
        this.baseTestMobFileCompaction();
        LOG.info("MOB compaction chore generational batch mode finished OK");
    }

    @Override
    protected void mobCompact(Admin admin, HTableDescriptor hdt, HColumnDescriptor hcd) throws IOException, InterruptedException {
        this.compactionChore.performMajorCompactionInBatches(admin, (TableDescriptor)hdt, (ColumnFamilyDescriptor)hcd);
    }
}

