/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.mob.TestMobCompactionBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestMobCompactionOptMode
extends TestMobCompactionBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactionOptMode.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCompactionOptMode.class);

    @Override
    protected void initConf() {
        super.initConf();
        this.conf.set("hbase.mob.compaction.type", "optimized");
        this.conf.setLong("hbase.mob.compactions.max.file.size", 1000000L);
    }

    @Test
    public void testMobFileCompactionBatchMode() throws InterruptedException, IOException {
        LOG.info("MOB compaction generational (non-batch) mode started");
        this.baseTestMobFileCompaction();
        LOG.info("MOB compaction generational (non-batch) mode finished OK");
    }

    @Override
    protected void mobCompact(Admin admin, HTableDescriptor hdt, HColumnDescriptor hcd) throws IOException, InterruptedException {
        admin.majorCompact(hdt.getTableName(), hcd.getName());
    }
}

