/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.mob.MobFileCleanerChore;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestMobCompactionBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestMobCompactionBase.class);
    protected HBaseTestingUtility HTU;
    protected static final String famStr = "f1";
    protected static final byte[] fam = Bytes.toBytes((String)"f1");
    protected static final byte[] qualifier = Bytes.toBytes((String)"q1");
    protected static final long mobLen = 10L;
    protected static final byte[] mobVal = Bytes.toBytes((String)"01234567890123456789012345678901234567890123456789012345678901234567890123456789");
    protected Configuration conf;
    protected HTableDescriptor hdt;
    private HColumnDescriptor hcd;
    protected Admin admin;
    protected Table table = null;
    protected long minAgeToArchive = 10000L;
    protected int numRegions = 20;
    protected int rows = 1000;
    protected MobFileCleanerChore cleanerChore;

    @Before
    public void setUp() throws Exception {
        this.HTU = new HBaseTestingUtility();
        this.hdt = this.HTU.createTableDescriptor(this.getClass().getName());
        this.conf = this.HTU.getConfiguration();
        this.initConf();
        this.HTU.startMiniCluster();
        this.admin = this.HTU.getAdmin();
        this.cleanerChore = new MobFileCleanerChore();
        this.hcd = new HColumnDescriptor(fam);
        this.hcd.setMobEnabled(true);
        this.hcd.setMobThreshold(10L);
        this.hcd.setMaxVersions(1);
        this.hdt.addFamily(this.hcd);
        RegionSplitter.UniformSplit splitAlgo = new RegionSplitter.UniformSplit();
        byte[][] splitKeys = splitAlgo.split(this.numRegions);
        this.table = this.HTU.createTable((TableDescriptor)this.hdt, splitKeys);
    }

    protected void initConf() {
        this.conf.setInt("hfile.format.version", 3);
        this.conf.setLong("hbase.mob.compaction.chore.period", 0L);
        this.conf.setLong("hbase.master.mob.cleaner.period", 0L);
        this.conf.setLong("hbase.mob.min.age.archive", this.minAgeToArchive);
        this.conf.setLong("hbase.hfile.compaction.discharger.interval", this.minAgeToArchive / 2L);
    }

    private void loadData(int num) {
        Random r = new Random();
        try {
            LOG.info("Started loading {} rows", (Object)num);
            for (int i = 0; i < num; ++i) {
                byte[] key = new byte[32];
                r.nextBytes(key);
                Put p = new Put(key);
                p.addColumn(fam, qualifier, mobVal);
                this.table.put(p);
            }
            this.admin.flush(this.table.getName());
            LOG.info("Finished loading {} rows", (Object)num);
        }
        catch (Exception e) {
            LOG.error("MOB file compaction chore test FAILED", (Throwable)e);
            Assert.fail((String)"MOB file compaction chore test FAILED");
        }
    }

    @After
    public void tearDown() throws Exception {
        this.admin.disableTable(this.hdt.getTableName());
        this.admin.deleteTable(this.hdt.getTableName());
        this.HTU.shutdownMiniCluster();
    }

    public void baseTestMobFileCompaction() throws InterruptedException, IOException {
        this.loadData(this.rows);
        this.loadData(this.rows);
        this.loadData(this.rows);
        long num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)(this.numRegions * 3), (long)num);
        this.mobCompact(this.admin, this.hdt, this.hcd);
        while (this.admin.getCompactionState(this.hdt.getTableName()) != CompactionState.NONE) {
            Thread.sleep(100L);
        }
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)(this.numRegions * 4), (long)num);
        LOG.info("Waiting for {}ms", (Object)(this.minAgeToArchive + 1000L));
        Thread.sleep(this.minAgeToArchive + 1000L);
        LOG.info("Cleaning up MOB files");
        this.cleanerChore.cleanupObsoleteMobFiles(this.conf, this.table.getName());
        num = this.getNumberOfMobFiles(this.conf, this.table.getName(), new String(fam));
        Assert.assertEquals((long)this.numRegions, (long)num);
        long scanned = this.scanTable();
        Assert.assertEquals((long)(3 * this.rows), (long)scanned);
    }

    protected abstract void mobCompact(Admin var1, HTableDescriptor var2, HColumnDescriptor var3) throws IOException, InterruptedException;

    protected long getNumberOfMobFiles(Configuration conf, TableName tableName, String family) throws IOException {
        FileStatus[] stat;
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path dir = MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)family);
        for (FileStatus st : stat = fs.listStatus(dir)) {
            LOG.debug("MOB Directory content: {}", (Object)st.getPath());
        }
        LOG.debug("MOB Directory content total files: {}", (Object)stat.length);
        return stat.length;
    }

    protected long scanTable() {
        try {
            Result result;
            ResultScanner scanner = this.table.getScanner(fam);
            long counter = 0L;
            while ((result = scanner.next()) != null) {
                Assert.assertTrue((boolean)Arrays.equals(result.getValue(fam, qualifier), mobVal));
                ++counter;
            }
            return counter;
        }
        catch (Exception e) {
            LOG.error("MOB file compaction test FAILED", (Throwable)e);
            if (this.HTU != null) {
                Assert.fail((String)e.getMessage());
            } else {
                System.exit(-1);
            }
            return 0L;
        }
    }
}

