/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.mob.DefaultMobStoreCompactor;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FaultyMobStoreCompactor
extends DefaultMobStoreCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(FaultyMobStoreCompactor.class);
    public static AtomicLong mobCounter = new AtomicLong();
    public static AtomicLong totalFailures = new AtomicLong();
    public static AtomicLong totalCompactions = new AtomicLong();
    public static AtomicLong totalMajorCompactions = new AtomicLong();
    static double failureProb = 0.1;
    static Random rnd = new Random();

    public FaultyMobStoreCompactor(Configuration conf, HStore store) {
        super(conf, store);
        failureProb = conf.getDouble("hbase.mob.compaction.fault.probability", 0.1);
    }

    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, CellSink writer, long smallestReadPoint, boolean cleanSeqId, ThroughputController throughputController, boolean major, int numofFilesToCompact) throws IOException {
        totalCompactions.incrementAndGet();
        if (major) {
            totalMajorCompactions.incrementAndGet();
        }
        long bytesWrittenProgressForCloseCheck = 0L;
        long bytesWrittenProgressForLog = 0L;
        long bytesWrittenProgressForShippedCall = 0L;
        ((Set)mobRefSet.get()).clear();
        boolean isUserRequest = (Boolean)userRequest.get();
        boolean compactMOBs = major && isUserRequest;
        boolean discardMobMiss = this.conf.getBoolean("hbase.unsafe.mob.discard.miss", false);
        boolean mustFail = false;
        if (compactMOBs) {
            mobCounter.incrementAndGet();
            double dv = rnd.nextDouble();
            if (dv < failureProb) {
                mustFail = true;
                totalFailures.incrementAndGet();
            }
        }
        FileSystem fs = this.store.getFileSystem();
        ArrayList cells = new ArrayList();
        int closeCheckSizeLimit = HStore.getCloseCheckInterval();
        long lastMillis = 0L;
        if (LOG.isDebugEnabled()) {
            lastMillis = EnvironmentEdgeManager.currentTime();
        }
        String compactionName = ThroughputControlUtil.getNameForThrottling((HStore)this.store, (String)"compaction");
        long now = 0L;
        Path path = MobUtils.getMobFamilyPath((Configuration)this.conf, (TableName)this.store.getTableName(), (String)this.store.getColumnFamilyName());
        byte[] fileName = null;
        StoreFileWriter mobFileWriter = null;
        long mobCells = 0L;
        long cellsCountCompactedToMob = 0L;
        long cellsCountCompactedFromMob = 0L;
        long cellsSizeCompactedToMob = 0L;
        long cellsSizeCompactedFromMob = 0L;
        boolean finished = false;
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(this.compactionKVMax).build();
        throughputController.start(compactionName);
        KeyValueScanner kvs = scanner instanceof KeyValueScanner ? (KeyValueScanner)scanner : null;
        long shippedCallSizeLimit = (long)numofFilesToCompact * (long)this.store.getColumnFamilyDescriptor().getBlocksize();
        Cell mobCell = null;
        long counter = 0L;
        long countFailAt = -1L;
        if (mustFail) {
            countFailAt = rnd.nextInt(100);
        }
        try {
            boolean hasMore;
            try {
                mobFileWriter = this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.compactionCompression, this.store.getRegionInfo().getStartKey(), true);
                fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
            }
            catch (IOException e) {
                LOG.error("Failed to create mob writer, ", (Throwable)e);
                throw e;
            }
            if (compactMOBs) {
                ((Set)mobRefSet.get()).add(mobFileWriter.getPath().getName());
            }
            do {
                hasMore = scanner.next(cells, scannerContext);
                if (LOG.isDebugEnabled()) {
                    now = EnvironmentEdgeManager.currentTime();
                }
                for (Cell c : cells) {
                    ++counter;
                    if (compactMOBs) {
                        if (MobUtils.isMobReferenceCell((Cell)c)) {
                            if (counter == countFailAt) {
                                LOG.warn("INJECTED FAULT mobCounter={}", (Object)mobCounter.get());
                                throw new CorruptHFileException("injected fault");
                            }
                            String fName = MobUtils.getMobFileName((Cell)c);
                            try {
                                mobCell = this.mobStore.resolve(c, true, false);
                            }
                            catch (FileNotFoundException fnfe) {
                                if (discardMobMiss) {
                                    LOG.error("Missing MOB cell: file={} not found", (Object)fName);
                                    continue;
                                }
                                throw fnfe;
                            }
                            if (discardMobMiss && mobCell.getValueLength() == 0) {
                                LOG.error("Missing MOB cell value: file={} cell={}", (Object)fName, (Object)mobCell);
                                continue;
                            }
                            if ((long)mobCell.getValueLength() > this.mobSizeThreshold) {
                                PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                mobFileWriter.append(mobCell);
                                writer.append(MobUtils.createMobRefCell((Cell)mobCell, (byte[])fileName, (byte[])this.mobStore.getRefCellTags()));
                                ++mobCells;
                            } else {
                                PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                writer.append(mobCell);
                                ++cellsCountCompactedFromMob;
                                cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                            }
                        } else {
                            int size = c.getValueLength();
                            if ((long)size > this.mobSizeThreshold) {
                                mobFileWriter.append(c);
                                writer.append(MobUtils.createMobRefCell((Cell)c, (byte[])fileName, (byte[])this.mobStore.getRefCellTags()));
                                ++mobCells;
                                ++cellsCountCompactedToMob;
                                cellsSizeCompactedToMob += (long)c.getValueLength();
                            } else {
                                writer.append(c);
                            }
                        }
                    } else if (c.getTypeByte() != KeyValue.Type.Put.getCode()) {
                        writer.append(c);
                    } else if (MobUtils.isMobReferenceCell((Cell)c)) {
                        if (MobUtils.hasValidMobRefCellValue((Cell)c)) {
                            int size = MobUtils.getMobValueLength((Cell)c);
                            if ((long)size > this.mobSizeThreshold) {
                                writer.append(c);
                                ((Set)mobRefSet.get()).add(MobUtils.getMobFileName((Cell)c));
                            } else {
                                mobCell = this.mobStore.resolve(c, true, false);
                                if (mobCell.getValueLength() != 0) {
                                    PrivateCellUtil.setSequenceId((Cell)mobCell, (long)c.getSequenceId());
                                    writer.append(mobCell);
                                    ++cellsCountCompactedFromMob;
                                    cellsSizeCompactedFromMob += (long)mobCell.getValueLength();
                                } else {
                                    LOG.error("Empty value for: " + c);
                                    writer.append(c);
                                    ((Set)mobRefSet.get()).add(MobUtils.getMobFileName((Cell)c));
                                }
                            }
                        } else {
                            LOG.error("Corrupted MOB reference: {}", (Object)c);
                            writer.append(c);
                        }
                    } else if ((long)c.getValueLength() <= this.mobSizeThreshold) {
                        writer.append(c);
                    } else {
                        ++mobCells;
                        mobFileWriter.append(c);
                        Cell reference = MobUtils.createMobRefCell((Cell)c, (byte[])fileName, (byte[])this.mobStore.getRefCellTags());
                        writer.append(reference);
                        ++cellsCountCompactedToMob;
                        cellsSizeCompactedToMob += (long)c.getValueLength();
                        ((Set)mobRefSet.get()).add(mobFileWriter.getPath().getName());
                    }
                    int len = c.getSerializedSize();
                    ++this.progress.currentCompactedKVs;
                    this.progress.totalCompactedSize += (long)len;
                    bytesWrittenProgressForShippedCall += (long)len;
                    if (LOG.isDebugEnabled()) {
                        bytesWrittenProgressForLog += (long)len;
                    }
                    throughputController.control(compactionName, (long)len);
                    if (closeCheckSizeLimit > 0 && (bytesWrittenProgressForCloseCheck += (long)len) > (long)closeCheckSizeLimit) {
                        bytesWrittenProgressForCloseCheck = 0L;
                        if (!this.store.areWritesEnabled()) {
                            this.progress.cancel();
                            boolean bl = false;
                            return bl;
                        }
                    }
                    if (kvs == null || bytesWrittenProgressForShippedCall <= shippedCallSizeLimit) continue;
                    ((ShipperListener)writer).beforeShipped();
                    kvs.shipped();
                    bytesWrittenProgressForShippedCall = 0L;
                }
                if (LOG.isDebugEnabled() && now - lastMillis >= 60000L) {
                    String rate = String.format("%.2f", (double)bytesWrittenProgressForLog / 1024.0 / ((double)(now - lastMillis) / 1000.0));
                    LOG.debug("Compaction progress: {} {}, rate={} KB/sec, throughputController is {}", new Object[]{compactionName, this.progress, rate, throughputController});
                    lastMillis = now;
                    bytesWrittenProgressForLog = 0L;
                }
                cells.clear();
            } while (hasMore);
            finished = true;
        }
        catch (InterruptedException e) {
            this.progress.cancel();
            throw new InterruptedIOException("Interrupted while control throughput of compacting " + compactionName);
        }
        catch (FileNotFoundException e) {
            LOG.error("MOB Stress Test FAILED, region: " + this.store.getRegionInfo().getEncodedName(), (Throwable)e);
            System.exit(-1);
        }
        catch (IOException t) {
            LOG.error("Mob compaction failed for region: " + this.store.getRegionInfo().getEncodedName());
            throw t;
        }
        finally {
            ((ShipperListener)writer).beforeShipped();
            throughputController.finish(compactionName);
            if (!finished && mobFileWriter != null) {
                ((Set)mobRefSet.get()).clear();
                this.abortWriter(mobFileWriter);
            }
        }
        if (mobFileWriter != null) {
            if (mobCells > 0L) {
                mobFileWriter.appendMetadata(fd.maxSeqId, major, mobCells);
                mobFileWriter.close();
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                this.abortWriter(mobFileWriter);
            }
        }
        this.mobStore.updateCellsCountCompactedFromMob(cellsCountCompactedFromMob);
        this.mobStore.updateCellsCountCompactedToMob(cellsCountCompactedToMob);
        this.mobStore.updateCellsSizeCompactedFromMob(cellsSizeCompactedFromMob);
        this.mobStore.updateCellsSizeCompactedToMob(cellsSizeCompactedToMob);
        this.progress.complete();
        return true;
    }
}

