/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.MetricsBalancerSourceImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestBalancerStatusTagInJMXMetrics
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBalancerStatusTagInJMXMetrics.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestBalancerStatusTagInJMXMetrics.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int connectorPort = 61120;
    private static HMaster master;
    private static MiniHBaseCluster cluster;
    private static Configuration conf;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int sign;
            while (!HBaseTestingUtility.available(connectorPort += (sign = i % 2 == 0 ? 1 : -1) * rand.nextInt(100))) {
            }
            try {
                conf.setInt("regionserver.rmi.registry.port", connectorPort);
                cluster = UTIL.startMiniCluster();
                LOG.info("Waiting for active/ready master");
                cluster.waitForActiveAndReadyMaster();
                master = cluster.getMaster();
                break;
            }
            catch (Exception e) {
                LOG.debug("Encountered exception when starting mini cluster. Trying port " + connectorPort, (Throwable)e);
                try {
                    UTIL.shutdownMiniCluster();
                }
                catch (Exception ex) {
                    LOG.debug("Encountered exception shutting down cluster", (Throwable)ex);
                }
                continue;
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testJmxMetrics() throws Exception {
        Assert.assertEquals((Object)this.getStatus(), (Object)"true");
        master.getLoadBalancer().updateBalancerStatus(false);
        Assert.assertEquals((Object)this.getStatus(), (Object)"false");
    }

    public String getStatus() throws Exception {
        MetricsSource source = DefaultMetricsSystem.instance().getSource("Master,sub=Balancer");
        if (source instanceof MetricsBalancerSourceImpl) {
            MetricsTag status = ((MetricsBalancerSourceImpl)source).getMetricsRegistry().getTag("isBalancerActive");
            return status.value();
        }
        LOG.warn("Balancer JMX Metrics not registered");
        throw new Exception("MetricsBalancer JMX Context not found");
    }

    static {
        conf = null;
    }
}

