/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterAbortWhileMergingTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterAbortWhileMergingTable.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterAbortWhileMergingTable.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static Admin admin;
    private static byte[] CF;
    private static byte[] SPLITKEY;
    private static CountDownLatch mergeCommitArrive;

    @BeforeClass
    public static void setupCluster() throws Exception {
        UTIL.getConfiguration().set("hbase.coprocessor.master.classes", MergeRegionObserver.class.getName());
        UTIL.startMiniCluster(3);
        admin = UTIL.getHBaseAdmin();
        byte[][] splitKeys = new byte[][]{SPLITKEY};
        UTIL.createTable(TABLE_NAME, CF, (byte[][])splitKeys);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void test() throws Exception {
        List regionInfos = admin.getRegions(TABLE_NAME);
        MergeTableRegionsProcedure mergeTableRegionsProcedure = new MergeTableRegionsProcedure((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment(), new RegionInfo[]{(RegionInfo)regionInfos.get(0), (RegionInfo)regionInfos.get(1)}, false);
        long procID = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().submitProcedure((Procedure)mergeTableRegionsProcedure);
        mergeCommitArrive.await();
        UTIL.getMiniHBaseCluster().stopMaster(0);
        UTIL.getMiniHBaseCluster().startMaster();
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster() != null && UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        UTIL.waitFor(30000L, () -> UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().isFinished(procID));
        Assert.assertTrue((String)"Found region RIT, that's impossible!", (UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager().getRegionsInTransition().size() == 0 ? 1 : 0) != 0);
    }

    static {
        CF = Bytes.toBytes((String)"cf");
        SPLITKEY = Bytes.toBytes((String)"bbbbbbb");
        mergeCommitArrive = new CountDownLatch(1);
    }

    public static class MergeRegionObserver
    implements MasterCoprocessor,
    MasterObserver {
        public Optional<MasterObserver> getMasterObserver() {
            return Optional.of(this);
        }

        public void preMergeRegionsCommitAction(ObserverContext<MasterCoprocessorEnvironment> ctx, RegionInfo[] regionsToMerge, List<Mutation> metaEntries) {
            mergeCommitArrive.countDown();
            LOG.error("mergeCommitArrive countdown");
        }
    }
}

