/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MasterTests.class, LargeTests.class})
public class TestRollingRestart {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRollingRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRollingRestart.class);
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter
    public boolean splitWALCoordinatedByZK;

    @Test
    public void testBasicRollingRestart() throws Exception {
        int NUM_MASTERS = 2;
        int NUM_RS = 3;
        int NUM_REGIONS_TO_CREATE = 20;
        int expectedNumRS = 3;
        this.log("Starting cluster");
        Configuration conf = HBaseConfiguration.create();
        conf.setBoolean("hbase.split.wal.zk.coordinated", this.splitWALCoordinatedByZK);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numMasters(2).numRegionServers(3).numDataNodes(3).build();
        TEST_UTIL.startMiniCluster(option);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[\\[|\\]]", "-"));
        byte[] family = Bytes.toBytes((String)"family");
        this.log("Creating table with 20 regions");
        Table ht = TEST_UTIL.createMultiRegionTable(tableName, family, 20);
        int numRegions = -1;
        RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);
        Object object = null;
        try {
            numRegions = r.getStartKeys().length;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (r != null) {
                if (object != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    r.close();
                }
            }
        }
        ++numRegions;
        this.log("Waiting for no more RIT\n");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Disabling table\n");
        TEST_UTIL.getAdmin().disableTable(tableName);
        this.log("Waiting for no more RIT\n");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        NavigableSet<String> regions = HBaseTestingUtility.getAllOnlineRegions(cluster);
        this.log("Verifying only catalog and namespace regions are assigned\n");
        if (regions.size() != 2) {
            for (String oregion : regions) {
                this.log("Region still online: " + oregion);
            }
        }
        Assert.assertEquals((long)2L, (long)regions.size());
        this.log("Enabling table\n");
        TEST_UTIL.getAdmin().enableTable(tableName);
        this.log("Waiting for no more RIT\n");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Verifying there are " + numRegions + " assigned on cluster\n");
        regions = HBaseTestingUtility.getAllOnlineRegions(cluster);
        this.assertRegionsAssigned(cluster, regions);
        Assert.assertEquals((long)expectedNumRS, (long)cluster.getRegionServerThreads().size());
        this.log("Adding a fourth RS");
        JVMClusterUtil.RegionServerThread restarted = cluster.startRegionServer();
        ++expectedNumRS;
        restarted.waitForServerOnline();
        this.log("Additional RS is online");
        this.log("Waiting for no more RIT");
        TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
        this.log("Verifying there are " + numRegions + " assigned on cluster");
        this.assertRegionsAssigned(cluster, regions);
        Assert.assertEquals((long)expectedNumRS, (long)cluster.getRegionServerThreads().size());
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        JVMClusterUtil.MasterThread activeMaster = null;
        JVMClusterUtil.MasterThread backupMaster = null;
        Assert.assertEquals((long)2L, (long)masterThreads.size());
        if (masterThreads.get(0).getMaster().isActiveMaster()) {
            activeMaster = masterThreads.get(0);
            backupMaster = masterThreads.get(1);
        } else {
            activeMaster = masterThreads.get(1);
            backupMaster = masterThreads.get(0);
        }
        this.log("Stopping backup master\n\n");
        backupMaster.getMaster().stop("Stop of backup during rolling restart");
        cluster.hbaseCluster.waitOnMaster(backupMaster);
        this.log("Stopping primary master\n\n");
        activeMaster.getMaster().stop("Stop of active during rolling restart");
        cluster.hbaseCluster.waitOnMaster(activeMaster);
        this.log("Restarting primary master\n\n");
        activeMaster = cluster.startMaster();
        cluster.waitForActiveAndReadyMaster();
        this.log("Restarting backup master\n\n");
        backupMaster = cluster.startMaster();
        Assert.assertEquals((long)expectedNumRS, (long)cluster.getRegionServerThreads().size());
        List<JVMClusterUtil.RegionServerThread> regionServers = cluster.getLiveRegionServerThreads();
        int num = 1;
        int total = regionServers.size();
        for (JVMClusterUtil.RegionServerThread rst : regionServers) {
            ServerName serverName = rst.getRegionServer().getServerName();
            this.log("Stopping region server " + num + " of " + total + " [ " + serverName + "]");
            rst.getRegionServer().stop("Stopping RS during rolling restart");
            cluster.hbaseCluster.waitOnRegionServer(rst);
            this.log("Waiting for RS shutdown to be handled by master");
            this.waitForRSShutdownToStartAndFinish(activeMaster, serverName);
            this.log("RS shutdown done, waiting for no more RIT");
            TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            this.log("Verifying there are " + numRegions + " assigned on cluster");
            this.assertRegionsAssigned(cluster, regions);
            Assert.assertEquals((long)(--expectedNumRS), (long)cluster.getRegionServerThreads().size());
            this.log("Restarting region server " + num + " of " + total);
            restarted = cluster.startRegionServer();
            restarted.waitForServerOnline();
            ++expectedNumRS;
            this.log("Region server " + num + " is back online");
            this.log("Waiting for no more RIT");
            TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            this.log("Verifying there are " + numRegions + " assigned on cluster");
            this.assertRegionsAssigned(cluster, regions);
            Assert.assertEquals((long)expectedNumRS, (long)cluster.getRegionServerThreads().size());
            ++num;
        }
        Thread.sleep(1000L);
        this.assertRegionsAssigned(cluster, regions);
        ht.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    private void waitForRSShutdownToStartAndFinish(JVMClusterUtil.MasterThread activeMaster, ServerName serverName) throws InterruptedException {
        ServerManager sm = activeMaster.getMaster().getServerManager();
        while (!sm.getDeadServers().isDeadServer(serverName)) {
            this.log("Waiting for [" + serverName + "] to be listed as dead in master");
            Thread.sleep(1L);
        }
        this.log("Server [" + serverName + "] marked as dead, waiting for it to " + "finish dead processing");
        while (sm.areDeadServersInProgress()) {
            this.log("Server [" + serverName + "] still being processed, waiting");
            Thread.sleep(100L);
        }
        this.log("Server [" + serverName + "] done with server shutdown processing");
    }

    private void log(String msg) {
        LOG.debug("\n\nTRR: " + msg + "\n");
    }

    private int getNumberOfOnlineRegions(MiniHBaseCluster cluster) {
        int numFound = 0;
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            numFound += rst.getRegionServer().getNumberOfOnlineRegions();
        }
        for (JVMClusterUtil.MasterThread mt : cluster.getMasterThreads()) {
            numFound += mt.getMaster().getNumberOfOnlineRegions();
        }
        return numFound;
    }

    private void assertRegionsAssigned(MiniHBaseCluster cluster, Set<String> expectedRegions) throws IOException {
        int numFound = this.getNumberOfOnlineRegions(cluster);
        if (expectedRegions.size() > numFound) {
            this.log("Expected to find " + expectedRegions.size() + " but only found" + " " + numFound);
            NavigableSet<String> foundRegions = HBaseTestingUtility.getAllOnlineRegions(cluster);
            for (String region : expectedRegions) {
                if (foundRegions.contains(region)) continue;
                this.log("Missing region: " + region);
            }
            Assert.assertEquals((long)expectedRegions.size(), (long)numFound);
        } else if (expectedRegions.size() < numFound) {
            int doubled = numFound - expectedRegions.size();
            this.log("Expected to find " + expectedRegions.size() + " but found" + " " + numFound + " (" + doubled + " double assignments?)");
            NavigableSet<String> doubleRegions = this.getDoubleAssignedRegions(cluster);
            for (String region : doubleRegions) {
                this.log("Region is double assigned: " + region);
            }
            Assert.assertEquals((long)expectedRegions.size(), (long)numFound);
        } else {
            this.log("Success!  Found expected number of " + numFound + " regions");
        }
    }

    private NavigableSet<String> getDoubleAssignedRegions(MiniHBaseCluster cluster) throws IOException {
        TreeSet<String> online = new TreeSet<String>();
        TreeSet<String> doubled = new TreeSet<String>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            for (RegionInfo region : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rst.getRegionServer().getRSRpcServices())) {
                if (online.add(region.getRegionNameAsString())) continue;
                doubled.add(region.getRegionNameAsString());
            }
        }
        return doubled;
    }

    @Parameterized.Parameters
    public static Collection coordinatedByZK() {
        return Arrays.asList(false, true);
    }
}

