/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.assignment.ServerStateNode;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestClusterRestartFailover
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterRestartFailover.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClusterRestartFailover.class);
    private static CountDownLatch SCP_LATCH;
    private static ServerName SERVER_FOR_TEST;

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    private ServerStateNode getServerStateNode(ServerName serverName) {
        return this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getServerNode(serverName);
    }

    @Test
    public void test() throws Exception {
        this.setupCluster();
        this.setupTable();
        for (JVMClusterUtil.RegionServerThread thread : this.UTIL.getHBaseCluster().getRegionServerThreads()) {
            if (thread.getRegionServer().getOnlineTables().contains(TableName.NAMESPACE_TABLE_NAME)) continue;
            SERVER_FOR_TEST = thread.getRegionServer().getServerName();
            break;
        }
        this.UTIL.waitFor(60000L, () -> this.getServerStateNode(SERVER_FOR_TEST) != null);
        ServerStateNode serverNode = this.getServerStateNode(SERVER_FOR_TEST);
        Assert.assertNotNull((Object)serverNode);
        Assert.assertTrue((String)"serverNode should be ONLINE when cluster runs normally", (boolean)serverNode.isInState(new ServerState[]{ServerState.ONLINE}));
        SCP_LATCH = new CountDownLatch(1);
        List<Integer> ports = this.UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServersList().stream().map(serverName -> serverName.getPort()).collect(Collectors.toList());
        LOG.info("Shutting down cluster");
        this.UTIL.getHBaseCluster().killAll();
        this.UTIL.getHBaseCluster().waitUntilShutDown();
        LOG.info("Restarting cluster");
        this.UTIL.restartHBaseCluster(StartMiniClusterOption.builder().masterClass(HMasterForTest.class).numMasters(1).numRegionServers(3).rsPorts(ports).build());
        this.UTIL.waitFor(60000L, () -> this.UTIL.getHBaseCluster().getMaster().isInitialized());
        this.UTIL.waitFor(60000L, () -> this.getServerStateNode(SERVER_FOR_TEST) != null);
        serverNode = this.getServerStateNode(SERVER_FOR_TEST);
        Assert.assertFalse((String)"serverNode should not be ONLINE during SCP processing", (boolean)serverNode.isInState(new ServerState[]{ServerState.ONLINE}));
        Optional<Procedure> procedure = this.UTIL.getHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure && ((ServerCrashProcedure)p).getServerName().equals((Object)SERVER_FOR_TEST)).findAny();
        Assert.assertTrue((String)("Should have one SCP for " + SERVER_FOR_TEST), (boolean)procedure.isPresent());
        Assert.assertTrue((String)("Submit the SCP for the same serverName " + SERVER_FOR_TEST + " which should fail"), (this.UTIL.getHBaseCluster().getMaster().getServerManager().expireServer(SERVER_FOR_TEST) == -1L ? 1 : 0) != 0);
        SCP_LATCH.countDown();
        this.UTIL.waitFor(60000L, () -> ((Procedure)procedure.get()).isFinished());
        Assert.assertFalse((String)("Even when the SCP is finished, the duplicate SCP should not be scheduled for " + SERVER_FOR_TEST), (this.UTIL.getHBaseCluster().getMaster().getServerManager().expireServer(SERVER_FOR_TEST) == -1L ? 1 : 0) != 0);
        serverNode = this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getServerNode(SERVER_FOR_TEST);
        Assert.assertNull((String)"serverNode should be deleted after SCP finished", (Object)serverNode);
    }

    private void setupCluster() throws Exception {
        this.UTIL.startMiniCluster(StartMiniClusterOption.builder().masterClass(HMasterForTest.class).numMasters(1).numRegionServers(3).build());
        this.UTIL.waitFor(60000L, () -> this.UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        this.UTIL.waitFor(60000L, () -> this.UTIL.getHBaseCluster().getMaster().getProcedures().stream().noneMatch(p -> p instanceof ServerCrashProcedure));
        this.UTIL.getHBaseCluster().getMaster().balanceSwitch(false);
    }

    private void setupTable() throws Exception {
        TableName tableName = TABLES[0];
        this.UTIL.createMultiRegionTable(tableName, FAMILY);
        this.UTIL.waitTableAvailable(tableName);
        Table table = this.UTIL.getConnection().getTable(tableName);
        for (int i = 0; i < 100; ++i) {
            this.UTIL.loadTable(table, FAMILY);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master) {
            super(master);
        }

        public List<RegionInfo> getRegionsOnServer(ServerName serverName) {
            List regions = super.getRegionsOnServer(serverName);
            if (SCP_LATCH != null && SERVER_FOR_TEST != null && serverName.equals((Object)SERVER_FOR_TEST)) {
                try {
                    LOG.info("ServerCrashProcedure wait the CountDownLatch here");
                    SCP_LATCH.await();
                    LOG.info("Continue the ServerCrashProcedure");
                    SCP_LATCH = null;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return regions;
        }
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManagerForTest(master);
        }
    }
}

