/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CachedBlock;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestHFileReaderImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileReaderImpl.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    static KeyValue toKV(String row) {
        return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value"));
    }

    static String toRowStr(Cell c) {
        return Bytes.toString((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength());
    }

    Path makeNewFile() throws IOException {
        Path ncTFile = new Path(TEST_UTIL.getDataTestDir(), "basic.hfile");
        FSDataOutputStream fout = TEST_UTIL.getTestFileSystem().create(ncTFile);
        int blocksize = TestHFileReaderImpl.toKV("a").getLength() * 3;
        HFileContext context = new HFileContextBuilder().withBlockSize(blocksize).withIncludesTags(true).build();
        Configuration conf = TEST_UTIL.getConfiguration();
        HFile.Writer writer = HFile.getWriterFactoryNoCache((Configuration)conf).withOutputStream(fout).withFileContext(context).withComparator((CellComparator)CellComparatorImpl.COMPARATOR).create();
        writer.append((Cell)TestHFileReaderImpl.toKV("c"));
        writer.append((Cell)TestHFileReaderImpl.toKV("e"));
        writer.append((Cell)TestHFileReaderImpl.toKV("g"));
        writer.append((Cell)TestHFileReaderImpl.toKV("i"));
        writer.append((Cell)TestHFileReaderImpl.toKV("k"));
        writer.close();
        fout.close();
        return ncTFile;
    }

    @Test
    public void testSeekBefore() throws Exception {
        int refCount;
        BlockCacheKey cacheKey;
        Path p = this.makeNewFile();
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Configuration conf = TEST_UTIL.getConfiguration();
        int[] bucketSizes = new int[]{512, 2048, 4096, 65536, 131072};
        BucketCache bucketcache = new BucketCache("offheap", 0x8000000L, 65536, bucketSizes, 5, 6400, null);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)p, (CacheConfig)new CacheConfig(conf, (BlockCache)bucketcache), (boolean)true, (Configuration)conf);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(true, true);
        scanner.seekTo((Cell)TestHFileReaderImpl.toKV("i"));
        Assert.assertEquals((Object)"i", (Object)TestHFileReaderImpl.toRowStr(scanner.getCell()));
        scanner.close();
        while (bucketcache.getBlockCount() <= 0L) {
            Thread.sleep(10L);
        }
        scanner = reader.getScanner(true, true);
        scanner.seekTo((Cell)TestHFileReaderImpl.toKV("i"));
        Assert.assertEquals((Object)"i", (Object)TestHFileReaderImpl.toRowStr(scanner.getCell()));
        scanner.seekBefore((Cell)TestHFileReaderImpl.toKV("i"));
        Assert.assertEquals((Object)"g", (Object)TestHFileReaderImpl.toRowStr(scanner.getCell()));
        scanner.close();
        for (CachedBlock cachedBlock : Lists.newArrayList((Iterable)bucketcache)) {
            cacheKey = new BlockCacheKey(cachedBlock.getFilename(), cachedBlock.getOffset());
            refCount = bucketcache.getRefCount(cacheKey);
            Assert.assertEquals((long)0L, (long)refCount);
        }
        scanner = reader.getScanner(true, true);
        scanner.seekTo((Cell)TestHFileReaderImpl.toKV("i"));
        Assert.assertEquals((Object)"i", (Object)TestHFileReaderImpl.toRowStr(scanner.getCell()));
        scanner.seekBefore((Cell)TestHFileReaderImpl.toKV("c"));
        scanner.close();
        for (CachedBlock cachedBlock : Lists.newArrayList((Iterable)bucketcache)) {
            cacheKey = new BlockCacheKey(cachedBlock.getFilename(), cachedBlock.getOffset());
            refCount = bucketcache.getRefCount(cacheKey);
            Assert.assertEquals((long)0L, (long)refCount);
        }
        reader.close();
        for (CachedBlock cachedBlock : Lists.newArrayList((Iterable)bucketcache)) {
            cacheKey = new BlockCacheKey(cachedBlock.getFilename(), cachedBlock.getOffset());
            bucketcache.evictBlock(cacheKey);
        }
        bucketcache.shutdown();
        this.deleteTestDir(fs);
    }

    protected void deleteTestDir(FileSystem fs) throws IOException {
        Path dataTestDir = TEST_UTIL.getDataTestDir();
        if (fs.exists(dataTestDir)) {
            fs.delete(dataTestDir, true);
        }
    }
}

