/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.Compressor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestHFileBlock {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileBlock.class);
    private static final boolean detailedLogging = false;
    private static final boolean[] BOOLEAN_VALUES = new boolean[]{false, true};
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileBlock.class);
    static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    private static final int NUM_TEST_BLOCKS = 1000;
    private static final int NUM_READER_THREADS = 26;
    private static int NUM_KEYVALUES = 50;
    private static int FIELD_LENGTH = 10;
    private static float CHANCE_TO_REPEAT = 0.6f;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private FileSystem fs;
    private final boolean includesMemstoreTS;
    private final boolean includesTag;

    public TestHFileBlock(boolean includesMemstoreTS, boolean includesTag) {
        this.includesMemstoreTS = includesMemstoreTS;
        this.includesTag = includesTag;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.MEMSTORETS_TAGS_PARAMETRIZED;
    }

    @Before
    public void setUp() throws IOException {
        this.fs = HFileSystem.get((Configuration)TEST_UTIL.getConfiguration());
    }

    static void writeTestBlockContents(DataOutputStream dos) throws IOException {
        for (int i = 0; i < 1000; ++i) {
            dos.writeInt(i / 100);
        }
    }

    static int writeTestKeyValues(HFileBlock.Writer hbw, int seed, boolean includesMemstoreTS, boolean useTag) throws IOException {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Random randomizer = new Random(42L + (long)seed);
        for (int i = 0; i < NUM_KEYVALUES; ++i) {
            byte[] value;
            byte[] qualifier;
            byte[] family;
            byte[] row;
            if (0 < i && randomizer.nextFloat() < CHANCE_TO_REPEAT) {
                row = CellUtil.cloneRow((Cell)((Cell)keyValues.get(randomizer.nextInt(keyValues.size()))));
            } else {
                row = new byte[FIELD_LENGTH];
                randomizer.nextBytes(row);
            }
            if (0 == i) {
                family = new byte[FIELD_LENGTH];
                randomizer.nextBytes(family);
            } else {
                family = CellUtil.cloneFamily((Cell)((Cell)keyValues.get(0)));
            }
            if (0 < i && randomizer.nextFloat() < CHANCE_TO_REPEAT) {
                qualifier = CellUtil.cloneQualifier((Cell)((Cell)keyValues.get(randomizer.nextInt(keyValues.size()))));
            } else {
                qualifier = new byte[FIELD_LENGTH];
                randomizer.nextBytes(qualifier);
            }
            if (0 < i && randomizer.nextFloat() < CHANCE_TO_REPEAT) {
                value = CellUtil.cloneValue((Cell)((Cell)keyValues.get(randomizer.nextInt(keyValues.size()))));
            } else {
                value = new byte[FIELD_LENGTH];
                randomizer.nextBytes(value);
            }
            long timestamp = 0 < i && randomizer.nextFloat() < CHANCE_TO_REPEAT ? ((KeyValue)keyValues.get(randomizer.nextInt(keyValues.size()))).getTimestamp() : randomizer.nextLong();
            if (!useTag) {
                keyValues.add(new KeyValue(row, family, qualifier, timestamp, value));
                continue;
            }
            keyValues.add(new KeyValue(row, family, qualifier, timestamp, value, new Tag[]{new ArrayBackedTag(1, Bytes.toBytes((String)"myTagVal"))}));
        }
        int totalSize = 0;
        Collections.sort(keyValues, CellComparatorImpl.COMPARATOR);
        for (KeyValue kv : keyValues) {
            totalSize += kv.getLength();
            if (includesMemstoreTS) {
                long memstoreTS = randomizer.nextLong();
                kv.setSequenceId(memstoreTS);
                totalSize += WritableUtils.getVIntSize((long)memstoreTS);
            }
            hbw.write((Cell)kv);
        }
        return totalSize;
    }

    public byte[] createTestV1Block(Compression.Algorithm algo) throws IOException {
        Compressor compressor = algo.getCompressor();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = algo.createCompressionStream((OutputStream)baos, compressor, 0);
        DataOutputStream dos = new DataOutputStream(os);
        BlockType.META.write((DataOutput)dos);
        TestHFileBlock.writeTestBlockContents(dos);
        dos.flush();
        algo.returnCompressor(compressor);
        return baos.toByteArray();
    }

    static HFileBlock.Writer createTestV2Block(Compression.Algorithm algo, boolean includesMemstoreTS, boolean includesTag) throws IOException {
        BlockType blockType = BlockType.DATA;
        HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(includesMemstoreTS).withIncludesTags(includesTag).withBytesPerCheckSum(16384).build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
        DataOutputStream dos = hbw.startWriting(blockType);
        TestHFileBlock.writeTestBlockContents(dos);
        dos.flush();
        hbw.ensureBlockReady();
        Assert.assertEquals((long)4000L, (long)hbw.getUncompressedSizeWithoutHeader());
        hbw.release();
        return hbw;
    }

    public String createTestBlockStr(Compression.Algorithm algo, int correctLength, boolean useTag) throws IOException {
        HFileBlock.Writer hbw = TestHFileBlock.createTestV2Block(algo, this.includesMemstoreTS, useTag);
        byte[] testV2Block = hbw.getHeaderAndDataForTest();
        int osOffset = 42;
        if (testV2Block.length == correctLength) {
            testV2Block[osOffset] = 3;
        }
        return Bytes.toStringBinary((byte[])testV2Block);
    }

    @Test
    public void testNoCompression() throws IOException {
        CacheConfig cacheConf = (CacheConfig)Mockito.mock(CacheConfig.class);
        Mockito.when((Object)cacheConf.getBlockCache()).thenReturn(Optional.empty());
        HFileBlock block = TestHFileBlock.createTestV2Block(Compression.Algorithm.NONE, this.includesMemstoreTS, false).getBlockForCaching(cacheConf);
        Assert.assertEquals((long)4000L, (long)block.getUncompressedSizeWithoutHeader());
        Assert.assertEquals((long)4004L, (long)block.getOnDiskSizeWithoutHeader());
        Assert.assertTrue((boolean)block.isUnpacked());
    }

    @Test
    public void testGzipCompression() throws IOException {
        String correctTestBlockStr = "DATABLK*\\x00\\x00\\x00>\\x00\\x00\\x0F\\xA0\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\x0" + ChecksumType.getDefaultChecksumType().getCode() + "\\x00\\x00@\\x00\\x00\\x00\\x00[" + "\\x1F\\x8B" + "\\x08" + "\\x00" + "\\x00\\x00\\x00\\x00" + "\\x00" + "\\x03" + "\\xED\\xC3\\xC1\\x11\\x00 \\x08\\xC00DD\\xDD\\x7Fa" + "\\xD6\\xE8\\xA3\\xB9K\\x84`\\x96Q\\xD3\\xA8\\xDB\\xA8e\\xD4c" + "\\xD46\\xEA5\\xEA3\\xEA7\\xE7\\x00LI\\x5Cs\\xA0\\x0F\\x00\\x00" + "\\x00\\x00\\x00\\x00";
        int correctGzipBlockLength = 95;
        String testBlockStr = this.createTestBlockStr(Compression.Algorithm.GZ, 95, false);
        Assert.assertEquals((Object)correctTestBlockStr.substring(0, 91), (Object)testBlockStr.substring(0, 91));
    }

    @Test
    public void testReaderV2() throws IOException {
        this.testReaderV2Internals();
    }

    protected void testReaderV2Internals() throws IOException {
        if (this.includesTag) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        }
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                LOG.info("testReaderV2: Compression algorithm: " + algo + ", pread=" + pread);
                Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + algo);
                FSDataOutputStream os = this.fs.create(path);
                HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withBytesPerCheckSum(16384).build();
                HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
                long totalSize = 0L;
                for (int blockId = 0; blockId < 2; ++blockId) {
                    DataOutputStream dos = hbw.startWriting(BlockType.DATA);
                    for (int i = 0; i < 1234; ++i) {
                        dos.writeInt(i);
                    }
                    hbw.writeHeaderAndData(os);
                    totalSize += (long)hbw.getOnDiskSizeWithHeader();
                }
                os.close();
                FSDataInputStream is = this.fs.open(path);
                meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(algo).build();
                HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, totalSize, meta);
                HFileBlock b = hbr.readBlockData(0L, -1L, pread, false);
                is.close();
                Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                b.sanityCheck();
                Assert.assertEquals((long)4936L, (long)b.getUncompressedSizeWithoutHeader());
                Assert.assertEquals((long)(algo == Compression.Algorithm.GZ ? 2173L : 4936L), (long)(b.getOnDiskSizeWithoutHeader() - b.totalChecksumBytes()));
                HFileBlock expected = b;
                if (algo != Compression.Algorithm.GZ) continue;
                is = this.fs.open(path);
                hbr = new HFileBlock.FSReaderImpl(is, totalSize, meta);
                b = hbr.readBlockData(0L, (long)(2206 + b.totalChecksumBytes()), pread, false);
                Assert.assertEquals((Object)expected, (Object)b);
                int wrongCompressedSize = 2172;
                try {
                    b = hbr.readBlockData(0L, (long)(wrongCompressedSize + 33), pread, false);
                    Assert.fail((String)"Exception expected");
                }
                catch (IOException ex) {
                    String expectedPrefix = "Passed in onDiskSizeWithHeader=";
                    Assert.assertTrue((String)("Invalid exception message: '" + ex.getMessage() + "'.\nMessage is expected to start with: '" + expectedPrefix + "'"), (boolean)ex.getMessage().startsWith(expectedPrefix));
                }
                is.close();
            }
        }
    }

    @Test
    public void testDataBlockEncoding() throws IOException {
        this.testInternals();
    }

    private void testInternals() throws IOException {
        int numBlocks = 5;
        if (this.includesTag) {
            TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        }
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : new boolean[]{false, true}) {
                for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
                    LOG.info("testDataBlockEncoding: Compression algorithm={}, pread={}, dataBlockEncoder={}", new Object[]{algo.toString(), pread, encoding});
                    Path path = new Path(TEST_UTIL.getDataTestDir(), "blocks_v2_" + algo + "_" + encoding.toString());
                    FSDataOutputStream os = this.fs.create(path);
                    NoOpDataBlockEncoder dataBlockEncoder = encoding != DataBlockEncoding.NONE ? new HFileDataBlockEncoderImpl(encoding) : NoOpDataBlockEncoder.INSTANCE;
                    HFileContext meta = new HFileContextBuilder().withCompression(algo).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withBytesPerCheckSum(16384).build();
                    HFileBlock.Writer hbw = new HFileBlock.Writer((HFileDataBlockEncoder)dataBlockEncoder, meta);
                    long totalSize = 0L;
                    ArrayList<Integer> encodedSizes = new ArrayList<Integer>();
                    ArrayList<ByteBuffer> encodedBlocks = new ArrayList<ByteBuffer>();
                    for (int blockId = 0; blockId < 5; ++blockId) {
                        hbw.startWriting(BlockType.DATA);
                        TestHFileBlock.writeTestKeyValues(hbw, blockId, this.includesMemstoreTS, this.includesTag);
                        hbw.writeHeaderAndData(os);
                        int headerLen = 33;
                        byte[] encodedResultWithHeader = hbw.cloneUncompressedBufferWithHeader().array();
                        int encodedSize = encodedResultWithHeader.length - headerLen;
                        if (encoding != DataBlockEncoding.NONE) {
                            headerLen += 2;
                        }
                        byte[] encodedDataSection = new byte[encodedResultWithHeader.length - headerLen];
                        System.arraycopy(encodedResultWithHeader, headerLen, encodedDataSection, 0, encodedDataSection.length);
                        ByteBuffer encodedBuf = ByteBuffer.wrap(encodedDataSection);
                        encodedSizes.add(encodedSize);
                        encodedBlocks.add(encodedBuf);
                        totalSize += (long)hbw.getOnDiskSizeWithHeader();
                    }
                    os.close();
                    FSDataInputStream is = this.fs.open(path);
                    meta = new HFileContextBuilder().withHBaseCheckSum(true).withCompression(algo).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).build();
                    HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, totalSize, meta);
                    hbr.setDataBlockEncoder((HFileDataBlockEncoder)dataBlockEncoder);
                    hbr.setIncludesMemStoreTS(this.includesMemstoreTS);
                    int pos = 0;
                    for (int blockId = 0; blockId < 5; ++blockId) {
                        HFileBlock blockFromHFile = hbr.readBlockData((long)pos, -1L, pread, false);
                        Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                        blockFromHFile.sanityCheck();
                        pos += blockFromHFile.getOnDiskSizeWithHeader();
                        Assert.assertEquals((long)((Integer)encodedSizes.get(blockId)).intValue(), (long)blockFromHFile.getUncompressedSizeWithoutHeader());
                        Assert.assertEquals((Object)meta.isCompressedOrEncrypted(), (Object)(!blockFromHFile.isUnpacked() ? 1 : 0));
                        long packedHeapsize = blockFromHFile.heapSize();
                        HFileBlock blockUnpacked = blockFromHFile.unpack(meta, (HFileBlock.FSReader)hbr);
                        Assert.assertTrue((boolean)blockUnpacked.isUnpacked());
                        if (meta.isCompressedOrEncrypted()) {
                            LOG.info("packedHeapsize=" + packedHeapsize + ", unpackedHeadsize=" + blockUnpacked.heapSize());
                            Assert.assertFalse((packedHeapsize == blockUnpacked.heapSize() ? 1 : 0) != 0);
                            Assert.assertTrue((String)"Packed heapSize should be < unpacked heapSize", (packedHeapsize < blockUnpacked.heapSize() ? 1 : 0) != 0);
                        }
                        ByteBuff actualBuffer = blockUnpacked.getBufferWithoutHeader();
                        if (encoding != DataBlockEncoding.NONE) {
                            Assert.assertEquals((String)("Unexpected first byte with " + TestHFileBlock.buildMessageDetails(algo, encoding, pread)), (Object)Long.toHexString(0L), (Object)Long.toHexString(actualBuffer.get(0)));
                            Assert.assertEquals((String)("Unexpected second byte with " + TestHFileBlock.buildMessageDetails(algo, encoding, pread)), (Object)Long.toHexString(encoding.getId()), (Object)Long.toHexString(actualBuffer.get(1)));
                            actualBuffer.position(2);
                            actualBuffer = actualBuffer.slice();
                        }
                        ByteBuffer expectedBuffer = (ByteBuffer)encodedBlocks.get(blockId);
                        expectedBuffer.rewind();
                        TestHFileBlock.assertBuffersEqual((ByteBuff)new SingleByteBuff(expectedBuffer), actualBuffer, algo, encoding, pread);
                        for (boolean reuseBuffer : new boolean[]{false, true}) {
                            ByteBuffer serialized = ByteBuffer.allocate(blockFromHFile.getSerializedLength());
                            blockFromHFile.serialize(serialized, true);
                            HFileBlock deserialized = (HFileBlock)blockFromHFile.getDeserializer().deserialize((ByteBuff)new SingleByteBuff(serialized), reuseBuffer, Cacheable.MemoryType.EXCLUSIVE);
                            Assert.assertEquals((String)("Serialization did not preserve block state. reuseBuffer=" + reuseBuffer), (Object)blockFromHFile, (Object)deserialized);
                            if (blockFromHFile == blockUnpacked) continue;
                            Assert.assertEquals((String)"Deserializaed block cannot be unpacked correctly.", (Object)blockUnpacked, (Object)deserialized.unpack(meta, (HFileBlock.FSReader)hbr));
                        }
                    }
                    is.close();
                }
            }
        }
    }

    static String buildMessageDetails(Compression.Algorithm compression, DataBlockEncoding encoding, boolean pread) {
        return String.format("compression %s, encoding %s, pread %s", compression, encoding, pread);
    }

    static void assertBuffersEqual(ByteBuff expectedBuffer, ByteBuff actualBuffer, Compression.Algorithm compression, DataBlockEncoding encoding, boolean pread) {
        if (!actualBuffer.equals(expectedBuffer)) {
            int prefix;
            int minLimit = Math.min(expectedBuffer.limit(), actualBuffer.limit());
            for (prefix = 0; prefix < minLimit && expectedBuffer.get(prefix) == actualBuffer.get(prefix); ++prefix) {
            }
            Assert.fail((String)String.format("Content mismatch for %s, commonPrefix %d, expected %s, got %s", TestHFileBlock.buildMessageDetails(compression, encoding, pread), prefix, TestHFileBlock.nextBytesToStr(expectedBuffer, prefix), TestHFileBlock.nextBytesToStr(actualBuffer, prefix)));
        }
    }

    private static String nextBytesToStr(ByteBuff buf, int pos) {
        int maxBytes = buf.limit() - pos;
        int numBytes = Math.min(16, maxBytes);
        return Bytes.toStringBinary((byte[])buf.array(), (int)(buf.arrayOffset() + pos), (int)numBytes) + (numBytes < maxBytes ? "..." : "");
    }

    @Test
    public void testPreviousOffset() throws IOException {
        this.testPreviousOffsetInternals();
    }

    protected void testPreviousOffsetInternals() throws IOException {
        for (Compression.Algorithm algo : COMPRESSION_ALGORITHMS) {
            for (boolean pread : BOOLEAN_VALUES) {
                for (boolean cacheOnWrite : BOOLEAN_VALUES) {
                    Random rand = this.defaultRandom();
                    LOG.info("testPreviousOffset: Compression algorithm={}, pread={}, cacheOnWrite={}", new Object[]{algo.toString(), pread, cacheOnWrite});
                    Path path = new Path(TEST_UTIL.getDataTestDir(), "prev_offset");
                    ArrayList<Long> expectedOffsets = new ArrayList<Long>();
                    ArrayList<Long> expectedPrevOffsets = new ArrayList<Long>();
                    ArrayList<BlockType> expectedTypes = new ArrayList<BlockType>();
                    ArrayList<ByteBuffer> expectedContents = cacheOnWrite ? new ArrayList<ByteBuffer>() : null;
                    long totalSize = this.writeBlocks(rand, algo, path, expectedOffsets, expectedPrevOffsets, expectedTypes, expectedContents);
                    FSDataInputStream is = this.fs.open(path);
                    HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(algo).build();
                    HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, totalSize, meta);
                    long curOffset = 0L;
                    for (int i = 0; i < 1000; ++i) {
                        if (!pread) {
                            Assert.assertEquals((long)is.getPos(), (long)(curOffset + (long)(i == 0 ? 0 : 33)));
                        }
                        Assert.assertEquals((long)((Long)expectedOffsets.get(i)), (long)curOffset);
                        HFileBlock b = hbr.readBlockData(curOffset, -1L, pread, false);
                        Assert.assertEquals((String)("Invalid block #" + i + "'s type:"), expectedTypes.get(i), (Object)b.getBlockType());
                        Assert.assertEquals((String)("Invalid previous block offset for block " + i + " of " + "type " + b.getBlockType() + ":"), (long)((Long)expectedPrevOffsets.get(i)), (long)b.getPrevBlockOffset());
                        b.sanityCheck();
                        Assert.assertEquals((long)curOffset, (long)b.getOffset());
                        HFileBlock b2 = hbr.readBlockData(curOffset, (long)b.getOnDiskSizeWithHeader(), pread, false);
                        b2.sanityCheck();
                        Assert.assertEquals((Object)b.getBlockType(), (Object)b2.getBlockType());
                        Assert.assertEquals((long)b.getOnDiskSizeWithoutHeader(), (long)b2.getOnDiskSizeWithoutHeader());
                        Assert.assertEquals((long)b.getOnDiskSizeWithHeader(), (long)b2.getOnDiskSizeWithHeader());
                        Assert.assertEquals((long)b.getUncompressedSizeWithoutHeader(), (long)b2.getUncompressedSizeWithoutHeader());
                        Assert.assertEquals((long)b.getPrevBlockOffset(), (long)b2.getPrevBlockOffset());
                        Assert.assertEquals((long)curOffset, (long)b2.getOffset());
                        Assert.assertEquals((long)b.getBytesPerChecksum(), (long)b2.getBytesPerChecksum());
                        Assert.assertEquals((long)b.getOnDiskDataSizeWithHeader(), (long)b2.getOnDiskDataSizeWithHeader());
                        Assert.assertEquals((long)0L, (long)HFile.getAndResetChecksumFailuresCount());
                        curOffset += (long)b.getOnDiskSizeWithHeader();
                        if (!cacheOnWrite) continue;
                        b = b.unpack(meta, (HFileBlock.FSReader)hbr);
                        ByteBuff bufRead = b.getBufferReadOnly();
                        ByteBuffer bufExpected = (ByteBuffer)expectedContents.get(i);
                        boolean bytesAreCorrect = Bytes.compareTo((byte[])bufRead.array(), (int)bufRead.arrayOffset(), (int)(bufRead.limit() - b.totalChecksumBytes()), (byte[])bufExpected.array(), (int)bufExpected.arrayOffset(), (int)bufExpected.limit()) == 0;
                        String wrongBytesMsg = "";
                        if (!bytesAreCorrect) {
                            wrongBytesMsg = "Expected bytes in block #" + i + " (algo=" + algo + ", pread=" + pread + ", cacheOnWrite=" + cacheOnWrite + "):\n";
                            wrongBytesMsg = wrongBytesMsg + Bytes.toStringBinary((byte[])bufExpected.array(), (int)bufExpected.arrayOffset(), (int)Math.min(42, bufExpected.limit())) + ", actual:\n" + Bytes.toStringBinary((byte[])bufRead.array(), (int)bufRead.arrayOffset(), (int)Math.min(42, bufRead.limit()));
                        }
                        Assert.assertTrue((String)wrongBytesMsg, (boolean)bytesAreCorrect);
                    }
                    Assert.assertEquals((long)curOffset, (long)this.fs.getFileStatus(path).getLen());
                    is.close();
                }
            }
        }
    }

    private Random defaultRandom() {
        return new Random(189237L);
    }

    @Test
    public void testConcurrentReading() throws Exception {
        this.testConcurrentReadingInternals();
    }

    protected void testConcurrentReadingInternals() throws IOException, InterruptedException, ExecutionException {
        for (Compression.Algorithm compressAlgo : COMPRESSION_ALGORITHMS) {
            int i;
            Path path = new Path(TEST_UTIL.getDataTestDir(), "concurrent_reading");
            Random rand = this.defaultRandom();
            ArrayList<Long> offsets = new ArrayList<Long>();
            ArrayList<BlockType> types = new ArrayList<BlockType>();
            this.writeBlocks(rand, compressAlgo, path, offsets, null, types, null);
            FSDataInputStream is = this.fs.open(path);
            long fileSize = this.fs.getFileStatus(path).getLen();
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(compressAlgo).build();
            HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(is, fileSize, meta);
            ExecutorService exec = Executors.newFixedThreadPool(26);
            ExecutorCompletionService<Boolean> ecs = new ExecutorCompletionService<Boolean>(exec);
            for (i = 0; i < 26; ++i) {
                ecs.submit(new BlockReaderThread("reader_" + (char)(65 + i), (HFileBlock.FSReader)hbr, offsets, types, fileSize));
            }
            for (i = 0; i < 26; ++i) {
                Future result = ecs.take();
                Assert.assertTrue((boolean)((Boolean)result.get()));
            }
            is.close();
        }
    }

    private long writeBlocks(Random rand, Compression.Algorithm compressAlgo, Path path, List<Long> expectedOffsets, List<Long> expectedPrevOffsets, List<BlockType> expectedTypes, List<ByteBuffer> expectedContents) throws IOException {
        boolean cacheOnWrite = expectedContents != null;
        FSDataOutputStream os = this.fs.create(path);
        HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withCompression(compressAlgo).withBytesPerCheckSum(16384).build();
        HFileBlock.Writer hbw = new HFileBlock.Writer(null, meta);
        HashMap<BlockType, Long> prevOffsetByType = new HashMap<BlockType, Long>();
        long totalSize = 0L;
        for (int i = 0; i < 1000; ++i) {
            long pos = os.getPos();
            int blockTypeOrdinal = rand.nextInt(BlockType.values().length);
            if (blockTypeOrdinal == BlockType.ENCODED_DATA.ordinal()) {
                blockTypeOrdinal = BlockType.DATA.ordinal();
            }
            BlockType bt = BlockType.values()[blockTypeOrdinal];
            DataOutputStream dos = hbw.startWriting(bt);
            int size = rand.nextInt(500);
            for (int j = 0; j < size; ++j) {
                dos.writeShort(i + 1);
                dos.writeInt(j + 1);
            }
            if (expectedOffsets != null) {
                expectedOffsets.add(os.getPos());
            }
            if (expectedPrevOffsets != null) {
                Long prevOffset = (Long)prevOffsetByType.get(bt);
                expectedPrevOffsets.add(prevOffset != null ? prevOffset : -1L);
                prevOffsetByType.put(bt, os.getPos());
            }
            expectedTypes.add(bt);
            hbw.writeHeaderAndData(os);
            totalSize += (long)hbw.getOnDiskSizeWithHeader();
            if (!cacheOnWrite) continue;
            expectedContents.add(hbw.cloneUncompressedBufferWithHeader());
        }
        os.close();
        LOG.info("Created a temporary file at " + path + ", " + this.fs.getFileStatus(path).getLen() + " byte, compression=" + compressAlgo);
        return totalSize;
    }

    @Test
    public void testBlockHeapSize() {
        this.testBlockHeapSizeInternals();
    }

    protected void testBlockHeapSizeInternals() {
        if (ClassSize.is32BitJVM()) {
            Assert.assertEquals((long)64L, (long)HFileBlock.MULTI_BYTE_BUFFER_HEAP_SIZE);
        } else {
            Assert.assertEquals((long)72L, (long)HFileBlock.MULTI_BYTE_BUFFER_HEAP_SIZE);
        }
        for (int size : new int[]{100, 256, 12345}) {
            byte[] byteArr = new byte[33 + size];
            ByteBuffer buf = ByteBuffer.wrap(byteArr, 0, size);
            HFileContext meta = new HFileContextBuilder().withIncludesMvcc(this.includesMemstoreTS).withIncludesTags(this.includesTag).withHBaseCheckSum(false).withCompression(Compression.Algorithm.NONE).withBytesPerCheckSum(16384).withChecksumType(ChecksumType.NULL).build();
            HFileBlock block = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, -1L, 0, -1, meta);
            long byteBufferExpectedSize = ClassSize.align((long)(ClassSize.estimateBase(new MultiByteBuff(new ByteBuffer[]{buf}).getClass(), (boolean)true) + 33L + (long)size));
            long hfileMetaSize = ClassSize.align((long)ClassSize.estimateBase(HFileContext.class, (boolean)true));
            long hfileBlockExpectedSize = ClassSize.align((long)ClassSize.estimateBase(HFileBlock.class, (boolean)true));
            long expected = hfileBlockExpectedSize + byteBufferExpectedSize + hfileMetaSize;
            Assert.assertEquals((String)("Block data size: " + size + ", byte buffer expected " + "size: " + byteBufferExpectedSize + ", HFileBlock class expected " + "size: " + hfileBlockExpectedSize + ";"), (long)expected, (long)block.heapSize());
        }
    }

    @Test
    public void testSerializeWithoutNextBlockMetadata() {
        int size = 100;
        int length = 33 + size;
        byte[] byteArr = new byte[length];
        ByteBuffer buf = ByteBuffer.wrap(byteArr, 0, size);
        HFileContext meta = new HFileContextBuilder().build();
        HFileBlock blockWithNextBlockMetadata = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, -1L, 52, -1, meta);
        HFileBlock blockWithoutNextBlockMetadata = new HFileBlock(BlockType.DATA, size, size, -1L, buf, true, -1L, -1, -1, meta);
        ByteBuffer buff1 = ByteBuffer.allocate(length);
        ByteBuffer buff2 = ByteBuffer.allocate(length);
        blockWithNextBlockMetadata.serialize(buff1, true);
        blockWithoutNextBlockMetadata.serialize(buff2, true);
        Assert.assertNotEquals((Object)buff1, (Object)buff2);
        buff1.clear();
        buff2.clear();
        blockWithNextBlockMetadata.serialize(buff1, false);
        blockWithoutNextBlockMetadata.serialize(buff2, false);
        Assert.assertEquals((Object)buff1, (Object)buff2);
    }

    private class BlockReaderThread
    implements Callable<Boolean> {
        private final String clientId;
        private final HFileBlock.FSReader hbr;
        private final List<Long> offsets;
        private final List<BlockType> types;
        private final long fileSize;

        public BlockReaderThread(String clientId, HFileBlock.FSReader hbr, List<Long> offsets, List<BlockType> types, long fileSize) {
            this.clientId = clientId;
            this.offsets = offsets;
            this.hbr = hbr;
            this.types = types;
            this.fileSize = fileSize;
        }

        @Override
        public Boolean call() throws Exception {
            Random rand = new Random(this.clientId.hashCode());
            long endTime = System.currentTimeMillis() + 10000L;
            int numBlocksRead = 0;
            int numPositionalRead = 0;
            int numWithOnDiskSize = 0;
            while (System.currentTimeMillis() < endTime) {
                HFileBlock b;
                int blockId = rand.nextInt(1000);
                long offset = this.offsets.get(blockId);
                boolean pread = true;
                boolean withOnDiskSize = rand.nextBoolean();
                long expectedSize = (blockId == 999 ? this.fileSize : this.offsets.get(blockId + 1)) - offset;
                try {
                    long onDiskSizeArg = withOnDiskSize ? expectedSize : -1L;
                    b = this.hbr.readBlockData(offset, onDiskSizeArg, pread, false);
                }
                catch (IOException ex) {
                    LOG.error("Error in client " + this.clientId + " trying to read block at " + offset + ", pread=" + pread + ", withOnDiskSize=" + withOnDiskSize, (Throwable)ex);
                    return false;
                }
                Assert.assertEquals((Object)this.types.get(blockId), (Object)b.getBlockType());
                Assert.assertEquals((long)expectedSize, (long)b.getOnDiskSizeWithHeader());
                Assert.assertEquals((long)offset, (long)b.getOffset());
                ++numBlocksRead;
                if (pread) {
                    ++numPositionalRead;
                }
                if (!withOnDiskSize) continue;
                ++numWithOnDiskSize;
            }
            LOG.info("Client " + this.clientId + " successfully read " + numBlocksRead + " blocks (with pread: " + numPositionalRead + ", with onDiskSize " + "specified: " + numWithOnDiskSize + ")");
            return true;
        }
    }
}

