/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.fs;

import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MiscTests.class, LargeTests.class})
public class TestBlockReorderBlockLocation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockReorderBlockLocation.class);
    private Configuration conf;
    private MiniDFSCluster cluster;
    private HBaseTestingUtility htu;
    private DistributedFileSystem dfs;
    private static final String host1 = "host1";
    private static final String host2 = "host2";
    private static final String host3 = "host3";
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.htu = new HBaseTestingUtility();
        this.htu.getConfiguration().setInt("dfs.blocksize", 1024);
        this.htu.getConfiguration().setInt("dfs.replication", 3);
        this.htu.startMiniDFSCluster(3, new String[]{"/r1", "/r2", "/r3"}, new String[]{host1, host2, host3});
        this.conf = this.htu.getConfiguration();
        this.cluster = this.htu.getDFSCluster();
        this.dfs = (DistributedFileSystem)FileSystem.get((Configuration)this.conf);
    }

    @After
    public void tearDownAfterClass() throws Exception {
        this.htu.shutdownMiniCluster();
    }

    private static ClientProtocol getNamenode(DFSClient dfsc) throws Exception {
        Field nf = DFSClient.class.getDeclaredField("namenode");
        nf.setAccessible(true);
        return (ClientProtocol)nf.get(dfsc);
    }

    @Test
    public void testBlockLocation() throws Exception {
        this.htu.startMiniZKCluster();
        MiniHBaseCluster hbm = this.htu.startMiniHBaseCluster();
        this.conf = hbm.getConfiguration();
        String fileName = "/helloWorld";
        Path p = new Path("/helloWorld");
        int repCount = 3;
        Assert.assertTrue(((short)this.cluster.getDataNodes().size() >= 3 ? 1 : 0) != 0);
        FSDataOutputStream fop = this.dfs.create(p, (short)3);
        double toWrite = 875.5613;
        fop.writeDouble(875.5613);
        fop.close();
        for (int i = 0; i < 10; ++i) {
            LocatedBlocks l;
            long max = System.currentTimeMillis() + 10000L;
            do {
                l = TestBlockReorderBlockLocation.getNamenode(this.dfs.getClient()).getBlockLocations("/helloWorld", 0L, 1L);
                Assert.assertNotNull((Object)l.getLocatedBlocks());
                Assert.assertEquals((long)1L, (long)l.getLocatedBlocks().size());
                Assert.assertTrue((String)("Expecting 3 , got " + l.get(0).getLocations().length), (System.currentTimeMillis() < max ? 1 : 0) != 0);
            } while (l.get(0).getLocations().length != 3);
            Object[] originalList = l.getLocatedBlocks().toArray();
            HFileSystem.ReorderWALBlocks lrb = new HFileSystem.ReorderWALBlocks();
            lrb.reorderBlocks(this.conf, l, "/helloWorld");
            Assert.assertArrayEquals((Object[])originalList, (Object[])l.getLocatedBlocks().toArray());
            Assert.assertNotNull((Object)this.conf.get("hbase.rootdir"));
            Assert.assertFalse((boolean)this.conf.get("hbase.rootdir").isEmpty());
            String pseudoLogFile = this.conf.get("hbase.rootdir") + "/" + "WALs" + "/" + host1 + ",6977,6576" + "/mylogfile";
            Assert.assertNotNull((String)("log= " + pseudoLogFile), (Object)AbstractFSWALProvider.getServerNameFromWALDirectoryName((Configuration)this.dfs.getConf(), (String)pseudoLogFile));
            lrb.reorderBlocks(this.conf, l, pseudoLogFile);
            Assert.assertEquals((Object)host1, (Object)l.get(0).getLocations()[2].getHostName());
            lrb.reorderBlocks(this.conf, l, pseudoLogFile);
            Assert.assertEquals((Object)host1, (Object)l.get(0).getLocations()[2].getHostName());
        }
    }
}

