/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestMultiActionMetricsFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiActionMetricsFromClient.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"test_table");
    private static final byte[] FAMILY = Bytes.toBytes((String)"fam1");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"qual");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiMetrics() throws Exception {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.set("hbase.client.metrics.enable", "true");
        try (ConnectionImplementation conn = (ConnectionImplementation)ConnectionFactory.createConnection((Configuration)conf);){
            byte[][] keys;
            BufferedMutator mutator = conn.getBufferedMutator(TABLE_NAME);
            for (byte[] key : keys = new byte[][]{Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"zzz")}) {
                Put p = new Put(key);
                p.addColumn(FAMILY, QUALIFIER, Bytes.toBytes((int)10));
                mutator.mutate((Mutation)p);
            }
            mutator.flush();
            mutator.close();
            MetricsConnection metrics = conn.getConnectionMetrics();
            Assert.assertEquals((long)1L, (long)metrics.multiTracker.reqHist.getCount());
            Assert.assertEquals((double)3.0, (double)metrics.numActionsPerServerHist.getSnapshot().getMean(), (double)1.0E-15);
            Assert.assertEquals((long)1L, (long)metrics.numActionsPerServerHist.getCount());
        }
    }
}

