/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AbstractTestAsyncTableRegionReplicasRead;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class, ClientTests.class})
public class TestAsyncTableRegionReplicasScan
extends AbstractTestAsyncTableRegionReplicasRead {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableRegionReplicasScan.class);
    private static int ROW_COUNT = 1000;

    private static byte[] getRow(int i) {
        return Bytes.toBytes((String)String.format("%s-%03d", Bytes.toString((byte[])ROW), i));
    }

    private static byte[] getValue(int i) {
        return Bytes.toBytes((String)String.format("%s-%03d", Bytes.toString((byte[])VALUE), i));
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestAsyncTableRegionReplicasScan.startClusterAndCreateTable();
        AsyncTable table = ASYNC_CONN.getTable(TABLE_NAME);
        for (int i = 0; i < ROW_COUNT; ++i) {
            table.put(new Put(TestAsyncTableRegionReplicasScan.getRow(i)).addColumn(FAMILY, QUALIFIER, TestAsyncTableRegionReplicasScan.getValue(i))).get();
        }
        TestAsyncTableRegionReplicasScan.waitUntilAllReplicasHaveRow(TestAsyncTableRegionReplicasScan.getRow(ROW_COUNT - 1));
    }

    @Override
    protected void readAndCheck(AsyncTable<?> table, int replicaId) throws IOException {
        Scan scan = new Scan().setConsistency(Consistency.TIMELINE).setCaching(1);
        if (replicaId >= 0) {
            scan.setReplicaId(replicaId);
        }
        try (ResultScanner scanner = table.getScanner(scan);){
            for (int i = 0; i < 1000; ++i) {
                Result result = scanner.next();
                Assert.assertNotNull((Object)result);
                Assert.assertArrayEquals((byte[])TestAsyncTableRegionReplicasScan.getValue(i), (byte[])result.getValue(FAMILY, QUALIFIER));
            }
        }
    }
}

