/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.client.TestAsyncTableAdminApi;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class, ClientTests.class})
public class TestAsyncTableAdminApi3
extends TestAsyncAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncTableAdminApi3.class);

    @Test
    public void testTableExist() throws Exception {
        boolean exist = (Boolean)this.admin.tableExists(this.tableName).get();
        Assert.assertFalse((boolean)exist);
        TEST_UTIL.createTable(this.tableName, FAMILY);
        exist = (Boolean)this.admin.tableExists(this.tableName).get();
        Assert.assertTrue((boolean)exist);
        exist = (Boolean)this.admin.tableExists(TableName.META_TABLE_NAME).get();
        Assert.assertTrue((boolean)exist);
        exist = (Boolean)this.admin.tableExists(TableName.META_TABLE_NAME).get();
        Assert.assertTrue((boolean)exist);
    }

    @Test
    public void testListTables() throws Exception {
        int i;
        int j;
        int numTables = ((List)this.admin.listTableDescriptors().get()).size();
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "2"));
        TableName tableName3 = TableName.valueOf((String)(this.tableName.getNameAsString() + "3"));
        TableName[] tables = new TableName[]{tableName1, tableName2, tableName3};
        for (int i2 = 0; i2 < tables.length; ++i2) {
            this.createTableWithDefaultConf(tables[i2]);
        }
        List tableDescs = (List)this.admin.listTableDescriptors().get();
        int size = tableDescs.size();
        Assert.assertTrue((size >= tables.length ? 1 : 0) != 0);
        for (int i3 = 0; i3 < tables.length && i3 < size; ++i3) {
            boolean found = false;
            for (j = 0; j < size; ++j) {
                if (!((TableDescriptor)tableDescs.get(j)).getTableName().equals((Object)tables[i3])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + tables[i3]), (boolean)found);
        }
        List tableNames = (ArrayList<TableName>)this.admin.listTableNames().get();
        size = tableNames.size();
        Assert.assertTrue((size == numTables + tables.length ? 1 : 0) != 0);
        for (i = 0; i < tables.length && i < size; ++i) {
            boolean found = false;
            for (int j2 = 0; j2 < size; ++j2) {
                if (!((TableName)tableNames.get(j2)).equals((Object)tables[i])) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Not found: " + tables[i]), (boolean)found);
        }
        tableNames = new ArrayList<TableName>(tables.length + 1);
        tableDescs = (List)this.admin.listTableDescriptors(tableNames).get();
        size = tableDescs.size();
        Assert.assertEquals((long)0L, (long)size);
        Collections.addAll(tableNames, tables);
        tableNames.add(TableName.META_TABLE_NAME);
        tableDescs = (List)this.admin.listTableDescriptors(tableNames).get();
        size = tableDescs.size();
        Assert.assertEquals((long)(tables.length + 1), (long)size);
        i = 0;
        for (j = 0; i < tables.length && j < size; ++i, ++j) {
            Assert.assertTrue((String)"tableName should be equal in order", (boolean)((TableDescriptor)tableDescs.get(j)).getTableName().equals((Object)tables[i]));
        }
        Assert.assertTrue((boolean)((TableDescriptor)tableDescs.get(size - 1)).getTableName().equals((Object)TableName.META_TABLE_NAME));
        for (i = 0; i < tables.length; ++i) {
            this.admin.disableTable(tables[i]).join();
            this.admin.deleteTable(tables[i]).join();
        }
        tableDescs = (List)this.admin.listTableDescriptors(true).get();
        Assert.assertTrue((String)"Not found system tables", (tableDescs.size() > 0 ? 1 : 0) != 0);
        tableNames = (List)this.admin.listTableNames(true).get();
        Assert.assertTrue((String)"Not found system tables", (tableNames.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetTableDescriptor() throws Exception {
        byte[][] families = new byte[][]{FAMILY, FAMILY_0, FAMILY_1};
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        for (byte[] family : families) {
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family));
        }
        TableDescriptor desc = builder.build();
        this.admin.createTable(desc).join();
        TableDescriptorBuilder.ModifyableTableDescriptor modifyableDesc = (TableDescriptorBuilder.ModifyableTableDescriptor)desc;
        TableDescriptor confirmedHtd = (TableDescriptor)this.admin.getDescriptor(this.tableName).get();
        Assert.assertEquals((long)0L, (long)modifyableDesc.compareTo((TableDescriptorBuilder.ModifyableTableDescriptor)confirmedHtd));
    }

    @Test
    public void testDisableAndEnableTable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        AsyncTable table = ASYNC_CONN.getTable(this.tableName);
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, value);
        table.put(put).join();
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        table.get(get).get();
        this.admin.disableTable(this.tableName).join();
        Assert.assertTrue((String)"Table must be disabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.DISABLED}));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(this.tableName));
        get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        boolean ok = false;
        try {
            table.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        ok = false;
        try {
            table.scanAll(new Scan()).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        this.admin.enableTable(this.tableName).join();
        Assert.assertTrue((String)"Table must be enabled.", (boolean)TEST_UTIL.getHBaseCluster().getMaster().getTableStateManager().isTableState(this.tableName, new TableState.State[]{TableState.State.ENABLED}));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(this.tableName));
        try {
            table.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME).get();
            Assert.fail((String)"meta table can not be disabled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(DoNotRetryIOException.class));
        }
    }

    @Test
    public void testDisableAndEnableTables() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.tableName.getNameAsString() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.tableName.getNameAsString() + "2"));
        this.createTableWithDefaultConf(tableName1);
        this.createTableWithDefaultConf(tableName2);
        AsyncTable table1 = ASYNC_CONN.getTable(tableName1);
        AsyncTable table2 = ASYNC_CONN.getTable(tableName1);
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, qualifier, value);
        table1.put(put).join();
        table2.put(put).join();
        Get get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        table1.get(get).get();
        table2.get(get).get();
        ((List)this.admin.listTableNames(Pattern.compile(this.tableName.getNameAsString() + ".*"), false).get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.disableTable(t).join();
        });
        get = new Get(row);
        get.addColumn(FAMILY, qualifier);
        boolean ok = false;
        try {
            table1.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        ok = false;
        try {
            table2.get(get).get();
        }
        catch (ExecutionException e) {
            ok = true;
        }
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(tableName1));
        Assert.assertEquals((Object)TableState.State.DISABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(tableName2));
        ((List)this.admin.listTableNames(Pattern.compile(this.tableName.getNameAsString() + ".*"), false).get()).forEach(t -> {
            Void cfr_ignored_0 = (Void)this.admin.enableTable(t).join();
        });
        try {
            table1.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        try {
            table2.get(get).get();
        }
        catch (Exception e) {
            ok = false;
        }
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(tableName1));
        Assert.assertEquals((Object)TableState.State.ENABLED, (Object)TestAsyncTableAdminApi.getStateFromMeta(tableName2));
    }

    @Test
    public void testEnableTableRetainAssignment() throws Exception {
        byte[][] splitKeys = new byte[][]{{1, 1, 1}, {2, 2, 2}, {3, 3, 3}, {4, 4, 4}, {5, 5, 5}, {6, 6, 6}, {7, 7, 7}, {8, 8, 8}, {9, 9, 9}};
        int expectedRegions = splitKeys.length + 1;
        this.createTableWithDefaultConf(this.tableName, splitKeys);
        AsyncTable metaTable = ASYNC_CONN.getTable(TableName.META_TABLE_NAME);
        List regions = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions " + "but only found " + regions.size()), (long)expectedRegions, (long)regions.size());
        this.admin.disableTable(this.tableName).join();
        this.admin.enableTable(this.tableName).join();
        List regions2 = (List)AsyncMetaTableAccessor.getTableHRegionLocations((AsyncTable)metaTable, (TableName)this.tableName).get();
        Assert.assertEquals((long)regions.size(), (long)regions2.size());
        Assert.assertTrue((boolean)regions2.containsAll(regions));
    }

    @Test
    public void testIsTableEnabledAndDisabled() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableEnabled(this.tableName).get()));
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableDisabled(this.tableName).get()));
        this.admin.disableTable(this.tableName).join();
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableEnabled(this.tableName).get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableDisabled(this.tableName).get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableEnabled(TableName.META_TABLE_NAME).get()));
        Assert.assertFalse((boolean)((Boolean)this.admin.isTableDisabled(TableName.META_TABLE_NAME).get()));
    }

    @Test
    public void testIsTableAvailable() throws Exception {
        this.createTableWithDefaultConf(this.tableName);
        TEST_UTIL.waitTableAvailable(this.tableName);
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableAvailable(this.tableName).get()));
        Assert.assertTrue((boolean)((Boolean)this.admin.isTableAvailable(TableName.META_TABLE_NAME).get()));
    }
}

