/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.ModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.NamespaceModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.RegionModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.RegionServerModeStrategy;
import org.apache.hadoop.hbase.hbtop.mode.TableModeStrategy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public enum Mode {
    NAMESPACE("Namespace", "Record per Namespace", new NamespaceModeStrategy()),
    TABLE("Table", "Record per Table", new TableModeStrategy()),
    REGION("Region", "Record per Region", new RegionModeStrategy()),
    REGION_SERVER("RegionServer", "Record per RegionServer", new RegionServerModeStrategy());

    private final String header;
    private final String description;
    private final ModeStrategy modeStrategy;

    private Mode(String header, String description, ModeStrategy modeStrategy) {
        this.header = Objects.requireNonNull(header);
        this.description = Objects.requireNonNull(description);
        this.modeStrategy = Objects.requireNonNull(modeStrategy);
    }

    public String getHeader() {
        return this.header;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Record> getRecords(ClusterMetrics clusterMetrics) {
        return this.modeStrategy.getRecords(clusterMetrics);
    }

    public List<FieldInfo> getFieldInfos() {
        return this.modeStrategy.getFieldInfos();
    }

    public Field getDefaultSortField() {
        return this.modeStrategy.getDefaultSortField();
    }

    @Nullable
    public DrillDownInfo drillDown(Record currentRecord) {
        return this.modeStrategy.drillDown(currentRecord);
    }
}

