/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.field;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.hbtop.field.FieldValueType;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class FieldValue
implements Comparable<FieldValue> {
    private final Object value;
    private final FieldValueType type;

    FieldValue(Object value, FieldValueType type) {
        Objects.requireNonNull(value);
        this.type = Objects.requireNonNull(type);
        switch (type) {
            case STRING: {
                if (value instanceof String) {
                    this.value = value;
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            case INTEGER: {
                if (value instanceof Integer) {
                    this.value = value;
                    break;
                }
                if (value instanceof String) {
                    this.value = Integer.valueOf((String)value);
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            case LONG: {
                if (value instanceof Long) {
                    this.value = value;
                    break;
                }
                if (value instanceof String) {
                    this.value = Long.valueOf((String)value);
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            case FLOAT: {
                if (value instanceof Float) {
                    this.value = value;
                    break;
                }
                if (value instanceof String) {
                    this.value = Float.valueOf((String)value);
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            case SIZE: {
                if (value instanceof Size) {
                    this.value = this.optimizeSize((Size)value);
                    break;
                }
                if (value instanceof String) {
                    this.value = this.optimizeSize(this.parseSizeString((String)value));
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            case PERCENT: {
                if (value instanceof Float) {
                    this.value = value;
                    break;
                }
                if (value instanceof String) {
                    this.value = this.parsePercentString((String)value);
                    break;
                }
                throw new IllegalArgumentException("invalid type");
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private Size optimizeSize(Size size) {
        if (size.get(Size.Unit.BYTE) < 1024.0) {
            return size.getUnit() == Size.Unit.BYTE ? size : new Size(size.get(Size.Unit.BYTE), Size.Unit.BYTE);
        }
        if (size.get(Size.Unit.KILOBYTE) < 1024.0) {
            return size.getUnit() == Size.Unit.KILOBYTE ? size : new Size(size.get(Size.Unit.KILOBYTE), Size.Unit.KILOBYTE);
        }
        if (size.get(Size.Unit.MEGABYTE) < 1024.0) {
            return size.getUnit() == Size.Unit.MEGABYTE ? size : new Size(size.get(Size.Unit.MEGABYTE), Size.Unit.MEGABYTE);
        }
        if (size.get(Size.Unit.GIGABYTE) < 1024.0) {
            return size.getUnit() == Size.Unit.GIGABYTE ? size : new Size(size.get(Size.Unit.GIGABYTE), Size.Unit.GIGABYTE);
        }
        if (size.get(Size.Unit.TERABYTE) < 1024.0) {
            return size.getUnit() == Size.Unit.TERABYTE ? size : new Size(size.get(Size.Unit.TERABYTE), Size.Unit.TERABYTE);
        }
        return size.getUnit() == Size.Unit.PETABYTE ? size : new Size(size.get(Size.Unit.PETABYTE), Size.Unit.PETABYTE);
    }

    private Size parseSizeString(String sizeString) {
        if (sizeString.length() < 3) {
            throw new IllegalArgumentException("invalid size");
        }
        String valueString = sizeString.substring(0, sizeString.length() - 2);
        String unitSimpleName = sizeString.substring(sizeString.length() - 2);
        return new Size(Double.parseDouble(valueString), this.convertToUnit(unitSimpleName));
    }

    private Size.Unit convertToUnit(String unitSimpleName) {
        for (Size.Unit unit : Size.Unit.values()) {
            if (!unitSimpleName.equals(unit.getSimpleName())) continue;
            return unit;
        }
        throw new IllegalArgumentException("invalid size");
    }

    private Float parsePercentString(String percentString) {
        if (percentString.endsWith("%")) {
            percentString = percentString.substring(0, percentString.length() - 1);
        }
        return Float.valueOf(percentString);
    }

    public String asString() {
        return this.toString();
    }

    public int asInt() {
        return (Integer)this.value;
    }

    public long asLong() {
        return (Long)this.value;
    }

    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    public Size asSize() {
        return (Size)this.value;
    }

    public String toString() {
        switch (this.type) {
            case STRING: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case SIZE: {
                return this.value.toString();
            }
            case PERCENT: {
                return String.format("%.2f", (Float)this.value) + "%";
            }
        }
        throw new AssertionError();
    }

    @Override
    public int compareTo(@NonNull FieldValue o) {
        if (this.type != o.type) {
            throw new IllegalArgumentException("invalid type");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareTo((String)o.value);
            }
            case INTEGER: {
                return ((Integer)this.value).compareTo((Integer)o.value);
            }
            case LONG: {
                return ((Long)this.value).compareTo((Long)o.value);
            }
            case FLOAT: 
            case PERCENT: {
                return ((Float)this.value).compareTo((Float)o.value);
            }
            case SIZE: {
                return ((Size)this.value).compareTo((Size)o.value);
            }
        }
        throw new AssertionError();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldValue)) {
            return false;
        }
        FieldValue that = (FieldValue)o;
        return this.value.equals(that.value) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public FieldValue plus(FieldValue o) {
        if (this.type != o.type) {
            throw new IllegalArgumentException("invalid type");
        }
        switch (this.type) {
            case STRING: {
                return new FieldValue(((String)this.value).concat((String)o.value), this.type);
            }
            case INTEGER: {
                return new FieldValue((Integer)this.value + (Integer)o.value, this.type);
            }
            case LONG: {
                return new FieldValue((Long)this.value + (Long)o.value, this.type);
            }
            case FLOAT: 
            case PERCENT: {
                return new FieldValue(Float.valueOf(((Float)this.value).floatValue() + ((Float)o.value).floatValue()), this.type);
            }
            case SIZE: {
                Size size = (Size)this.value;
                Size oSize = (Size)o.value;
                Size.Unit unit = size.getUnit();
                return new FieldValue(new Size(size.get(unit) + oSize.get(unit), unit), this.type);
            }
        }
        throw new AssertionError();
    }

    public int compareToIgnoreCase(FieldValue o) {
        if (this.type != o.type) {
            throw new IllegalArgumentException("invalid type");
        }
        switch (this.type) {
            case STRING: {
                return ((String)this.value).compareToIgnoreCase((String)o.value);
            }
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case SIZE: 
            case PERCENT: {
                return this.compareTo(o);
            }
        }
        throw new AssertionError();
    }
}

