/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Pointer;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::AbstractInvoker"}, parent="Object")
public abstract class AbstractInvoker
extends Pointer {
    static final String CLASS_NAME = "AbstractInvoker";
    protected final Arity arity;

    public static RubyClass createAbstractInvokerClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = module.defineClassUnder(CLASS_NAME, module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        result2.defineAnnotatedMethods(AbstractInvoker.class);
        result2.defineAnnotatedConstants(AbstractInvoker.class);
        return result2;
    }

    protected AbstractInvoker(Ruby runtime, RubyClass klass, int arity2, MemoryIO io2) {
        super(runtime, klass, io2, 0L);
        this.arity = Arity.fixed(arity2);
    }

    @JRubyMethod(name={"attach"})
    public IRubyObject attach(ThreadContext context, IRubyObject obj, IRubyObject methodName) {
        DynamicMethod m = this.createDynamicMethod(obj.getSingletonClass());
        obj.getSingletonClass().addMethod(methodName.asJavaString(), m);
        if (obj instanceof RubyModule) {
            ((RubyModule)obj).addMethod(methodName.asJavaString(), m);
        }
        this.getRuntime().getFFI().registerAttachedMethod(m, this);
        return this;
    }

    protected abstract DynamicMethod createDynamicMethod(RubyModule var1);

    public final Arity getArity() {
        return this.arity;
    }
}

