/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsUserSourceImpl
implements MetricsUserSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUserSourceImpl.class);
    private final String userNamePrefix;
    private final String user;
    private final String userGetKey;
    private final String userScanTimeKey;
    private final String userPutKey;
    private final String userDeleteKey;
    private final String userIncrementKey;
    private final String userAppendKey;
    private final String userReplayKey;
    private MetricHistogram getHisto;
    private MetricHistogram scanTimeHisto;
    private MetricHistogram putHisto;
    private MetricHistogram deleteHisto;
    private MetricHistogram incrementHisto;
    private MetricHistogram appendHisto;
    private MetricHistogram replayHisto;
    private final int hashCode;
    private AtomicBoolean closed = new AtomicBoolean(false);
    private final MetricsUserAggregateSourceImpl agg;
    private final DynamicMetricsRegistry registry;

    public MetricsUserSourceImpl(String user, MetricsUserAggregateSourceImpl agg) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating new MetricsUserSourceImpl for user " + user);
        }
        this.user = user;
        this.agg = agg;
        this.registry = agg.getMetricsRegistry();
        this.userNamePrefix = "user_" + user + "_metric_";
        this.hashCode = this.userNamePrefix.hashCode();
        this.userGetKey = this.userNamePrefix + "get";
        this.userScanTimeKey = this.userNamePrefix + "scanTime";
        this.userPutKey = this.userNamePrefix + "put";
        this.userDeleteKey = this.userNamePrefix + "delete";
        this.userIncrementKey = this.userNamePrefix + "increment";
        this.userAppendKey = this.userNamePrefix + "append";
        this.userReplayKey = this.userNamePrefix + "replay";
        agg.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() {
        MetricsUserSourceImpl metricsUserSourceImpl = this;
        synchronized (metricsUserSourceImpl) {
            this.getHisto = this.registry.newTimeHistogram(this.userGetKey);
            this.scanTimeHisto = this.registry.newTimeHistogram(this.userScanTimeKey);
            this.putHisto = this.registry.newTimeHistogram(this.userPutKey);
            this.deleteHisto = this.registry.newTimeHistogram(this.userDeleteKey);
            this.incrementHisto = this.registry.newTimeHistogram(this.userIncrementKey);
            this.appendHisto = this.registry.newTimeHistogram(this.userAppendKey);
            this.replayHisto = this.registry.newTimeHistogram(this.userReplayKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing user Metrics for user: " + this.user);
        }
        MetricsUserSourceImpl metricsUserSourceImpl = this;
        synchronized (metricsUserSourceImpl) {
            this.registry.removeMetric(this.userGetKey);
            this.registry.removeMetric(this.userScanTimeKey);
            this.registry.removeMetric(this.userPutKey);
            this.registry.removeMetric(this.userDeleteKey);
            this.registry.removeMetric(this.userIncrementKey);
            this.registry.removeMetric(this.userAppendKey);
            this.registry.removeMetric(this.userReplayKey);
        }
    }

    public String getUser() {
        return this.user;
    }

    public int compareTo(MetricsUserSource source) {
        if (source == null) {
            return -1;
        }
        if (!(source instanceof MetricsUserSourceImpl)) {
            return -1;
        }
        MetricsUserSourceImpl impl = (MetricsUserSourceImpl)source;
        return Long.compare(this.hashCode, impl.hashCode);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MetricsUserSourceImpl && this.compareTo((MetricsUserSourceImpl)obj) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsUserSourceImpl metricsUserSourceImpl = this;
        synchronized (metricsUserSourceImpl) {
            if (this.closed.get()) {
                return;
            }
        }
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void updateScanTime(long t) {
        this.scanTimeHisto.add(t);
    }
}

