/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.http.ClickjackingPreventionFilter;
import org.apache.hadoop.hbase.http.HttpServerUtil;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.http.SecurityHeadersFilter;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.rest.Constants;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RESTServletContainer;
import org.apache.hadoop.hbase.rest.filter.AuthFilter;
import org.apache.hadoop.hbase.rest.filter.GzipFilter;
import org.apache.hadoop.hbase.rest.filter.RestCsrfPreventionFilter;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.hbase.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.yetus.audience.InterfaceAudience;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class RESTServer
implements Constants {
    static Logger LOG = LoggerFactory.getLogger((String)"RESTServer");
    static final String REST_CSRF_ENABLED_KEY = "hbase.rest.csrf.enabled";
    static final boolean REST_CSRF_ENABLED_DEFAULT = false;
    boolean restCSRFEnabled = false;
    static final String REST_CSRF_CUSTOM_HEADER_KEY = "hbase.rest.csrf.custom.header";
    static final String REST_CSRF_CUSTOM_HEADER_DEFAULT = "X-XSRF-HEADER";
    static final String REST_CSRF_METHODS_TO_IGNORE_KEY = "hbase.rest.csrf.methods.to.ignore";
    static final String REST_CSRF_METHODS_TO_IGNORE_DEFAULT = "GET,OPTIONS,HEAD,TRACE";
    public static final String SKIP_LOGIN_KEY = "hbase.rest.skip.login";
    static final int DEFAULT_HTTP_MAX_HEADER_SIZE = 65536;
    private static final String PATH_SPEC_ANY = "/*";
    static final String REST_HTTP_ALLOW_OPTIONS_METHOD = "hbase.rest.http.allow.options.method";
    private static boolean REST_HTTP_ALLOW_OPTIONS_METHOD_DEFAULT = true;
    static final String REST_CSRF_BROWSER_USERAGENTS_REGEX_KEY = "hbase.rest-csrf.browser-useragents-regex";
    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "MS_CANNOT_BE_FINAL"}, justification="For testing")
    public static Configuration conf = null;
    private final UserProvider userProvider;
    private Server server;
    private InfoServer infoServer;

    public RESTServer(Configuration conf) {
        RESTServer.conf = conf;
        this.userProvider = UserProvider.instantiate((Configuration)conf);
    }

    private static void printUsageAndExit(Options options, int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("hbase rest start", "", options, "\nTo run the REST server as a daemon, execute hbase-daemon.sh start|stop rest [--infoport <port>] [-p <port>] [-ro]\n", true);
        System.exit(exitCode);
    }

    void addCSRFFilter(ServletContextHandler ctxHandler, Configuration conf) {
        this.restCSRFEnabled = conf.getBoolean(REST_CSRF_ENABLED_KEY, false);
        if (this.restCSRFEnabled) {
            Map<String, String> restCsrfParams = RestCsrfPreventionFilter.getFilterParams(conf, "hbase.rest-csrf.");
            FilterHolder holder = new FilterHolder();
            holder.setName("csrf");
            holder.setClassName(RestCsrfPreventionFilter.class.getName());
            holder.setInitParameters(restCsrfParams);
            ctxHandler.addFilter(holder, PATH_SPEC_ANY, EnumSet.allOf(DispatcherType.class));
        }
    }

    private void addClickjackingPreventionFilter(ServletContextHandler ctxHandler, Configuration conf) {
        FilterHolder holder = new FilterHolder();
        holder.setName("clickjackingprevention");
        holder.setClassName(ClickjackingPreventionFilter.class.getName());
        holder.setInitParameters(ClickjackingPreventionFilter.getDefaultParameters((Configuration)conf));
        ctxHandler.addFilter(holder, PATH_SPEC_ANY, EnumSet.allOf(DispatcherType.class));
    }

    private void addSecurityHeadersFilter(ServletContextHandler ctxHandler, Configuration conf) {
        FilterHolder holder = new FilterHolder();
        holder.setName("securityheaders");
        holder.setClassName(SecurityHeadersFilter.class.getName());
        holder.setInitParameters(SecurityHeadersFilter.getDefaultParameters((Configuration)conf));
        ctxHandler.addFilter(holder, PATH_SPEC_ANY, EnumSet.allOf(DispatcherType.class));
    }

    private static Pair<FilterHolder, Class<? extends ServletContainer>> loginServerPrincipal(UserProvider userProvider, Configuration conf) throws Exception {
        Class<ServletContainer> containerClass = ServletContainer.class;
        if (userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled()) {
            String machineName = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.rest.dns.interface", "default"), (String)conf.get("hbase.rest.dns.nameserver", "default")));
            String keytabFilename = conf.get("hbase.rest.keytab.file");
            Preconditions.checkArgument((keytabFilename != null && !keytabFilename.isEmpty() ? 1 : 0) != 0, (Object)"hbase.rest.keytab.file should be set if security is enabled");
            String principalConfig = conf.get("hbase.rest.kerberos.principal");
            Preconditions.checkArgument((principalConfig != null && !principalConfig.isEmpty() ? 1 : 0) != 0, (Object)"hbase.rest.kerberos.principal should be set if security is enabled");
            if (!conf.getBoolean(SKIP_LOGIN_KEY, false)) {
                userProvider.login("hbase.rest.keytab.file", "hbase.rest.kerberos.principal", machineName);
            }
            if (conf.get("hbase.rest.authentication.type") != null) {
                containerClass = RESTServletContainer.class;
                FilterHolder authFilter = new FilterHolder();
                authFilter.setClassName(AuthFilter.class.getName());
                authFilter.setName("AuthenticationFilter");
                return new Pair((Object)authFilter, containerClass);
            }
        }
        return new Pair(null, containerClass);
    }

    private static void parseCommandLine(String[] args, Configuration conf) {
        String command;
        List remainingArgs;
        String val;
        Options options = new Options();
        options.addOption("p", "port", true, "Port to bind to [default: 8080]");
        options.addOption("ro", "readonly", false, "Respond only to GET HTTP method requests [default: false]");
        options.addOption(null, "infoport", true, "Port for web UI");
        CommandLine commandLine = null;
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("Could not parse: ", (Throwable)e);
            RESTServer.printUsageAndExit(options, -1);
        }
        if (commandLine != null && commandLine.hasOption("port")) {
            val = commandLine.getOptionValue("port");
            conf.setInt("hbase.rest.port", Integer.parseInt(val));
            if (LOG.isDebugEnabled()) {
                LOG.debug("port set to " + val);
            }
        }
        if (commandLine != null && commandLine.hasOption("readonly")) {
            conf.setBoolean("hbase.rest.readonly", true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("readonly set to true");
            }
        }
        if (commandLine != null && commandLine.hasOption("infoport")) {
            val = commandLine.getOptionValue("infoport");
            conf.setInt("hbase.rest.info.port", Integer.parseInt(val));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Web UI port set to " + val);
            }
        }
        if (commandLine != null && commandLine.hasOption("skipLogin")) {
            conf.setBoolean(SKIP_LOGIN_KEY, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping Kerberos login for REST server");
            }
        }
        List list = remainingArgs = commandLine != null ? commandLine.getArgList() : new ArrayList();
        if (remainingArgs.size() != 1) {
            RESTServer.printUsageAndExit(options, 1);
        }
        if (!"start".equals(command = (String)remainingArgs.get(0))) {
            if ("stop".equals(command)) {
                System.exit(1);
            } else {
                RESTServer.printUsageAndExit(options, 1);
            }
        }
    }

    public synchronized void run() throws Exception {
        String[] filterClasses;
        ServerConnector serverConnector;
        Pair<FilterHolder, Class<? extends ServletContainer>> pair = RESTServer.loginServerPrincipal(this.userProvider, conf);
        FilterHolder authFilter = (FilterHolder)pair.getFirst();
        Class containerClass = (Class)pair.getSecond();
        RESTServlet servlet = RESTServlet.getInstance(conf, this.userProvider);
        ResourceConfig application = new ResourceConfig().packages(new String[]{"org.apache.hadoop.hbase.rest"}).register(JacksonJaxbJsonProvider.class);
        ServletContainer servletContainer = (ServletContainer)ReflectionUtils.newInstance((Class)containerClass, (Object[])new Object[]{application});
        ServletHolder sh = new ServletHolder((Servlet)servletContainer);
        int maxThreads = servlet.getConfiguration().getInt("hbase.rest.threads.max", 100);
        int minThreads = servlet.getConfiguration().getInt("hbase.rest.threads.min", 2);
        int queueSize = servlet.getConfiguration().getInt("hbase.rest.task.queue.size", -1);
        int idleTimeout = servlet.getConfiguration().getInt("hbase.rest.thread.idle.timeout", 60000);
        QueuedThreadPool threadPool = queueSize > 0 ? new QueuedThreadPool(maxThreads, minThreads, idleTimeout, new ArrayBlockingQueue(queueSize)) : new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        this.server = new Server((ThreadPool)threadPool);
        MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
        this.server.addEventListener((Container.Listener)mbContainer);
        this.server.addBean((Object)mbContainer);
        String host = servlet.getConfiguration().get("hbase.rest.host", "0.0.0.0");
        int servicePort = servlet.getConfiguration().getInt("hbase.rest.port", 8080);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(servicePort);
        httpConfig.setHeaderCacheSize(65536);
        httpConfig.setRequestHeaderSize(65536);
        httpConfig.setResponseHeaderSize(65536);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        if (conf.getBoolean("hbase.rest.ssl.enabled", false)) {
            String[] includeProtocols;
            String[] excludeProtocols;
            String[] includeCiphers;
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslCtxFactory = new SslContextFactory();
            String keystore = conf.get("hbase.rest.ssl.keystore.store");
            String[] password = HBaseConfiguration.getPassword((Configuration)conf, (String)"hbase.rest.ssl.keystore.password", null);
            String keyPassword = HBaseConfiguration.getPassword((Configuration)conf, (String)"hbase.rest.ssl.keystore.keypassword", (String)password);
            sslCtxFactory.setKeyStorePath(keystore);
            sslCtxFactory.setKeyStorePassword((String)password);
            sslCtxFactory.setKeyManagerPassword(keyPassword);
            String[] excludeCiphers = servlet.getConfiguration().getStrings("hbase.rest.ssl.exclude.cipher.suites", ArrayUtils.EMPTY_STRING_ARRAY);
            if (excludeCiphers.length != 0) {
                sslCtxFactory.setExcludeCipherSuites(excludeCiphers);
            }
            if ((includeCiphers = servlet.getConfiguration().getStrings("hbase.rest.ssl.include.cipher.suites", ArrayUtils.EMPTY_STRING_ARRAY)).length != 0) {
                sslCtxFactory.setIncludeCipherSuites(includeCiphers);
            }
            if ((excludeProtocols = servlet.getConfiguration().getStrings("hbase.rest.ssl.exclude.protocols", ArrayUtils.EMPTY_STRING_ARRAY)).length != 0) {
                sslCtxFactory.setExcludeProtocols(excludeProtocols);
            }
            if ((includeProtocols = servlet.getConfiguration().getStrings("hbase.rest.ssl.include.protocols", ArrayUtils.EMPTY_STRING_ARRAY)).length != 0) {
                sslCtxFactory.setIncludeProtocols(includeProtocols);
            }
            serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslCtxFactory, HttpVersion.HTTP_1_1.toString()), new HttpConnectionFactory(httpsConfig)});
        } else {
            serverConnector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        }
        int acceptQueueSize = servlet.getConfiguration().getInt("hbase.rest.connector.accept.queue.size", -1);
        if (acceptQueueSize >= 0) {
            serverConnector.setAcceptQueueSize(acceptQueueSize);
        }
        serverConnector.setPort(servicePort);
        serverConnector.setHost(host);
        this.server.addConnector((Connector)serverConnector);
        this.server.setStopAtShutdown(true);
        ServletContextHandler ctxHandler = new ServletContextHandler((HandlerContainer)this.server, "/", 1);
        ctxHandler.addServlet(sh, PATH_SPEC_ANY);
        if (authFilter != null) {
            ctxHandler.addFilter(authFilter, PATH_SPEC_ANY, EnumSet.of(DispatcherType.REQUEST));
        }
        for (String filter : filterClasses = servlet.getConfiguration().getStrings("hbase.rest.filter.classes", new String[]{GzipFilter.class.getName()})) {
            filter = filter.trim();
            ctxHandler.addFilter(filter, PATH_SPEC_ANY, EnumSet.of(DispatcherType.REQUEST));
        }
        this.addCSRFFilter(ctxHandler, conf);
        this.addClickjackingPreventionFilter(ctxHandler, conf);
        this.addSecurityHeadersFilter(ctxHandler, conf);
        HttpServerUtil.constrainHttpMethods((ServletContextHandler)ctxHandler, (boolean)servlet.getConfiguration().getBoolean(REST_HTTP_ALLOW_OPTIONS_METHOD, REST_HTTP_ALLOW_OPTIONS_METHOD_DEFAULT));
        int port = conf.getInt("hbase.rest.info.port", 8085);
        if (port >= 0) {
            conf.setLong("startcode", System.currentTimeMillis());
            String a = conf.get("hbase.rest.info.bindAddress", "0.0.0.0");
            this.infoServer = new InfoServer("rest", a, port, false, conf);
            this.infoServer.setAttribute("hbase.conf", (Object)conf);
            this.infoServer.start();
        }
        try {
            this.server.start();
        }
        catch (Exception e) {
            LOG.error(HBaseMarkers.FATAL, "Failed to start server", (Throwable)e);
            throw e;
        }
    }

    public synchronized void join() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running");
        }
        this.server.join();
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running");
        }
        this.server.stop();
        this.server = null;
        RESTServlet.stop();
    }

    public synchronized int getPort() {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running");
        }
        return ((ServerConnector)this.server.getConnectors()[0]).getLocalPort();
    }

    public synchronized int getInfoPort() {
        if (this.infoServer == null) {
            throw new IllegalStateException("InfoServer is not running");
        }
        return this.infoServer.getPort();
    }

    public Configuration getConf() {
        return conf;
    }

    public static void main(String[] args) throws Exception {
        LOG.info("***** STARTING service '" + RESTServer.class.getSimpleName() + "' *****");
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        RESTServer.parseCommandLine(args, conf);
        RESTServer server = new RESTServer(conf);
        try {
            server.run();
            server.join();
        }
        catch (Exception e) {
            System.exit(1);
        }
        LOG.info("***** STOPPING service '" + RESTServer.class.getSimpleName() + "' *****");
    }
}

