/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.logaggregation.tracker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMLogAggregationStatusTracker
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(NMLogAggregationStatusTracker.class);
    private final ReentrantReadWriteLock.ReadLock readLocker;
    private final ReentrantReadWriteLock.WriteLock writeLocker;
    private final Context nmContext;
    private final long rollingInterval;
    private final Timer timer;
    private final Map<ApplicationId, AppLogAggregationStatusForRMRecovery> recoveryStatuses;
    private boolean disabled = false;

    public NMLogAggregationStatusTracker(Context context) {
        super(NMLogAggregationStatusTracker.class.getName());
        this.nmContext = context;
        Configuration conf = context.getConf();
        if (!conf.getBoolean("yarn.log-aggregation-enable", false)) {
            this.disabled = true;
        }
        this.recoveryStatuses = new ConcurrentHashMap<ApplicationId, AppLogAggregationStatusForRMRecovery>();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLocker = lock.readLock();
        this.writeLocker = lock.writeLock();
        this.timer = new Timer();
        long configuredRollingInterval = conf.getLong("yarn.log-aggregation-status.time-out.ms", 600000L);
        if (configuredRollingInterval <= 0L) {
            this.rollingInterval = 600000L;
            LOG.warn("The configured log-aggregation-status.time-out.ms is " + configuredRollingInterval + " which should be larger than 0. " + "Using the default value:" + this.rollingInterval + " instead.");
        } else {
            this.rollingInterval = configuredRollingInterval;
        }
        LOG.info("the rolling interval seconds for the NodeManager Cached Log aggregation status is " + this.rollingInterval / 1000L);
    }

    protected void serviceStart() throws Exception {
        if (this.disabled) {
            LOG.warn("Log Aggregation is disabled.So is the LogAggregationStatusTracker.");
        } else {
            this.timer.scheduleAtFixedRate((TimerTask)new LogAggregationStatusRoller(), this.rollingInterval, this.rollingInterval);
        }
    }

    public void serviceStop() throws Exception {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLogAggregationStatus(ApplicationId appId, LogAggregationStatus logAggregationStatus, long updateTime, String diagnosis, boolean finalized) {
        if (this.disabled) {
            LOG.warn("The log aggregation is disabled. No need to update the log aggregation status");
        }
        this.readLocker.lock();
        try {
            AppLogAggregationStatusForRMRecovery tracker = this.recoveryStatuses.get(appId);
            if (tracker == null) {
                Application application = (Application)this.nmContext.getApplications().get(appId);
                if (application == null) {
                    LOG.warn("The application:" + appId + " has already finished," + " and has been removed from NodeManager, we should not " + "receive the log aggregation status update for " + "this application.");
                    return;
                }
                AppLogAggregationStatusForRMRecovery newTracker = new AppLogAggregationStatusForRMRecovery(logAggregationStatus, diagnosis);
                newTracker.setLastModifiedTime(updateTime);
                newTracker.setFinalized(finalized);
                this.recoveryStatuses.put(appId, newTracker);
            } else if (tracker.isFinalized()) {
                LOG.warn("Ignore the log aggregation status update request for the application:" + appId + ". The cached log aggregation " + "status is " + tracker.getLogAggregationStatus() + ".");
            } else if (tracker.getLastModifiedTime() > updateTime) {
                LOG.warn("Ignore the log aggregation status update request for the application:" + appId + ". The request log " + "aggregation status update is older than the cached " + "log aggregation status.");
            } else {
                tracker.setLogAggregationStatus(logAggregationStatus);
                tracker.setDiagnosis(diagnosis);
                tracker.setLastModifiedTime(updateTime);
                tracker.setFinalized(finalized);
                this.recoveryStatuses.put(appId, tracker);
            }
        }
        finally {
            this.readLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogAggregationReport> pullCachedLogAggregationReports() {
        ArrayList<LogAggregationReport> reports = new ArrayList<LogAggregationReport>();
        if (this.disabled) {
            LOG.warn("The log aggregation is disabled.There is no cached log aggregation status.");
            return reports;
        }
        this.writeLocker.lock();
        try {
            for (Map.Entry<ApplicationId, AppLogAggregationStatusForRMRecovery> tracker : this.recoveryStatuses.entrySet()) {
                AppLogAggregationStatusForRMRecovery current = tracker.getValue();
                LogAggregationReport report = LogAggregationReport.newInstance((ApplicationId)tracker.getKey(), (LogAggregationStatus)current.getLogAggregationStatus(), (String)current.getDiagnosis());
                reports.add(report);
            }
            ArrayList<LogAggregationReport> arrayList = reports;
            return arrayList;
        }
        finally {
            this.writeLocker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollLogAggregationStatus() {
        this.writeLocker.lock();
        try {
            long currentTimeStamp = System.currentTimeMillis();
            LOG.info("Rolling over the cached log aggregation status.");
            Iterator<Map.Entry<ApplicationId, AppLogAggregationStatusForRMRecovery>> it = this.recoveryStatuses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ApplicationId, AppLogAggregationStatusForRMRecovery> tracker = it.next();
                if (this.nmContext.getApplications().get(tracker.getKey()) != null || currentTimeStamp - tracker.getValue().getLastModifiedTime() <= this.rollingInterval) continue;
                it.remove();
            }
        }
        finally {
            this.writeLocker.unlock();
        }
    }

    private static class AppLogAggregationStatusForRMRecovery {
        private LogAggregationStatus logAggregationStatus;
        private long lastModifiedTime;
        private boolean finalized;
        private String diagnosis;

        AppLogAggregationStatusForRMRecovery(LogAggregationStatus logAggregationStatus, String diagnosis) {
            this.setLogAggregationStatus(logAggregationStatus);
            this.setDiagnosis(diagnosis);
        }

        public LogAggregationStatus getLogAggregationStatus() {
            return this.logAggregationStatus;
        }

        public void setLogAggregationStatus(LogAggregationStatus logAggregationStatus) {
            this.logAggregationStatus = logAggregationStatus;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public boolean isFinalized() {
            return this.finalized;
        }

        public void setFinalized(boolean finalized) {
            this.finalized = finalized;
        }

        public String getDiagnosis() {
            return this.diagnosis;
        }

        public void setDiagnosis(String diagnosis) {
            this.diagnosis = diagnosis;
        }
    }

    private class LogAggregationStatusRoller
    extends TimerTask {
        private LogAggregationStatusRoller() {
        }

        @Override
        public void run() {
            NMLogAggregationStatusTracker.this.rollLogAggregationStatus();
        }
    }
}

