/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import java.util.List;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.gpu.GpuResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.DockerCommandPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.AssignedGpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDiscoverer;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDockerCommandPluginFactory;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuNodeResourceUpdateHandler;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.NMResourceInfo;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.NMGpuResourceInfo;

public class GpuResourcePlugin
implements ResourcePlugin {
    private final GpuNodeResourceUpdateHandler resourceDiscoverHandler;
    private final GpuDiscoverer gpuDiscoverer;
    private GpuResourceHandlerImpl gpuResourceHandler = null;
    private DockerCommandPlugin dockerCommandPlugin = null;

    public GpuResourcePlugin(GpuNodeResourceUpdateHandler resourceDiscoverHandler, GpuDiscoverer gpuDiscoverer) {
        this.resourceDiscoverHandler = resourceDiscoverHandler;
        this.gpuDiscoverer = gpuDiscoverer;
    }

    @Override
    public synchronized void initialize(Context context) throws YarnException {
        this.gpuDiscoverer.initialize(context.getConf());
        this.dockerCommandPlugin = GpuDockerCommandPluginFactory.createGpuDockerCommandPlugin(context.getConf());
    }

    @Override
    public synchronized ResourceHandler createResourceHandler(Context context, CGroupsHandler cGroupsHandler, PrivilegedOperationExecutor privilegedOperationExecutor) {
        if (this.gpuResourceHandler == null) {
            this.gpuResourceHandler = new GpuResourceHandlerImpl(context, cGroupsHandler, privilegedOperationExecutor, this.gpuDiscoverer);
        }
        return this.gpuResourceHandler;
    }

    @Override
    public synchronized NodeResourceUpdaterPlugin getNodeResourceHandlerInstance() {
        return this.resourceDiscoverHandler;
    }

    @Override
    public void cleanup() throws YarnException {
    }

    @Override
    public DockerCommandPlugin getDockerCommandPluginInstance() {
        return this.dockerCommandPlugin;
    }

    @Override
    public synchronized NMResourceInfo getNMResourceInfo() throws YarnException {
        GpuDeviceInformation gpuDeviceInformation = this.gpuDiscoverer.isAutoDiscoveryEnabled() ? this.gpuDiscoverer.getGpuDeviceInformation() : null;
        GpuResourceAllocator gpuResourceAllocator = this.gpuResourceHandler.getGpuAllocator();
        List<GpuDevice> totalGpus = gpuResourceAllocator.getAllowedGpusCopy();
        List<AssignedGpuDevice> assignedGpuDevices = gpuResourceAllocator.getAssignedGpusCopy();
        return new NMGpuResourceInfo(gpuDeviceInformation, totalGpus, assignedGpuDevices);
    }

    public String toString() {
        return GpuResourcePlugin.class.getName();
    }
}

