/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDevice;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.gpu.GpuDeviceSpecificationException;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformation;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.GpuDeviceInformationParser;
import org.apache.hadoop.yarn.server.nodemanager.webapp.dao.gpu.PerGpuDeviceInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GpuDiscoverer {
    public static final Logger LOG = LoggerFactory.getLogger(GpuDiscoverer.class);
    @VisibleForTesting
    static final String DEFAULT_BINARY_NAME = "nvidia-smi";
    private static final Set<String> DEFAULT_BINARY_SEARCH_DIRS = ImmutableSet.of((Object)"/usr/bin", (Object)"/bin", (Object)"/usr/local/nvidia/bin");
    private static final int MAX_EXEC_TIMEOUT_MS = 10000;
    private static final int MAX_REPEATED_ERROR_ALLOWED = 10;
    private Configuration conf = null;
    private String pathOfGpuBinary = null;
    private Map<String, String> environment = new HashMap<String, String>();
    private GpuDeviceInformationParser parser = new GpuDeviceInformationParser();
    private int numOfErrorExecutionSinceLastSucceed = 0;
    private GpuDeviceInformation lastDiscoveredGpuInformation = null;
    private List<GpuDevice> gpuDevicesFromUser;

    private void validateConfOrThrowException() throws YarnException {
        if (this.conf == null) {
            throw new YarnException("Please initialize (call initialize) before use " + GpuDiscoverer.class.getSimpleName());
        }
    }

    private String getErrorMessageOfScriptExecution(String msg) {
        return this.getFailedToExecuteScriptMessage() + "! Exception message: " + msg;
    }

    private String getErrorMessageOfScriptExecutionThresholdReached() {
        return this.getFailedToExecuteScriptMessage() + " for " + 10 + " times, " + "skipping following executions!";
    }

    private String getFailedToExecuteScriptMessage() {
        return "Failed to execute GPU device detection script (" + this.pathOfGpuBinary + ")";
    }

    private String getFailedToParseErrorMessage(String msg) {
        return "Failed to parse XML output of GPU device detection script( " + this.pathOfGpuBinary + ")" + msg;
    }

    synchronized GpuDeviceInformation getGpuDeviceInformation() throws YarnException {
        this.validateConfOrThrowException();
        if (this.numOfErrorExecutionSinceLastSucceed == 10) {
            String msg = this.getErrorMessageOfScriptExecutionThresholdReached();
            LOG.error(msg);
            throw new YarnException(msg);
        }
        try {
            String output = Shell.execCommand(this.environment, (String[])new String[]{this.pathOfGpuBinary, "-x", "-q"}, (long)10000L);
            this.lastDiscoveredGpuInformation = this.parser.parseXml(output);
            this.numOfErrorExecutionSinceLastSucceed = 0;
            return this.lastDiscoveredGpuInformation;
        }
        catch (IOException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = this.getErrorMessageOfScriptExecution(e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg);
            }
            throw new YarnException(msg, (Throwable)e);
        }
        catch (YarnException e) {
            ++this.numOfErrorExecutionSinceLastSucceed;
            String msg = this.getFailedToParseErrorMessage(e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(msg, (Throwable)e);
            }
            throw e;
        }
    }

    boolean isAutoDiscoveryEnabled() {
        String allowedDevicesStr = this.conf.get("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices", "auto");
        return allowedDevicesStr.equals("auto");
    }

    public synchronized List<GpuDevice> getGpusUsableByYarn() throws YarnException {
        this.validateConfOrThrowException();
        if (this.isAutoDiscoveryEnabled()) {
            return this.parseGpuDevicesFromAutoDiscoveredGpuInfo();
        }
        if (this.gpuDevicesFromUser == null) {
            this.gpuDevicesFromUser = this.parseGpuDevicesFromUserDefinedValues();
        }
        return this.gpuDevicesFromUser;
    }

    private List<GpuDevice> parseGpuDevicesFromAutoDiscoveredGpuInfo() throws YarnException {
        if (this.lastDiscoveredGpuInformation == null) {
            String msg = "yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices is set to auto, however automatically discovering GPU information failed, please check NodeManager log for more details, as an alternative, admin can specify yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices manually to enable GPU isolation.";
            LOG.error(msg);
            throw new YarnException(msg);
        }
        ArrayList<GpuDevice> gpuDevices = new ArrayList<GpuDevice>();
        if (this.lastDiscoveredGpuInformation.getGpus() != null) {
            int numberOfGpus = this.lastDiscoveredGpuInformation.getGpus().size();
            LOG.debug("Found {} GPU devices", (Object)numberOfGpus);
            for (int i = 0; i < numberOfGpus; ++i) {
                List<PerGpuDeviceInformation> gpuInfos = this.lastDiscoveredGpuInformation.getGpus();
                gpuDevices.add(new GpuDevice(i, gpuInfos.get(i).getMinorNumber()));
            }
        }
        return gpuDevices;
    }

    private List<GpuDevice> parseGpuDevicesFromUserDefinedValues() throws YarnException {
        String devices = this.conf.get("yarn.nodemanager.resource-plugins.gpu.allowed-gpu-devices", "auto");
        if (devices.trim().isEmpty()) {
            throw GpuDeviceSpecificationException.createWithEmptyValueSpecified();
        }
        ArrayList gpuDevices = Lists.newArrayList();
        for (String device : devices.split(",")) {
            if (device.trim().length() <= 0) continue;
            String[] splitByColon = device.trim().split(":");
            if (splitByColon.length != 2) {
                throw GpuDeviceSpecificationException.createWithWrongValueSpecified(device, devices);
            }
            GpuDevice gpuDevice = this.parseGpuDevice(device, splitByColon, devices);
            if (!gpuDevices.contains(gpuDevice)) {
                gpuDevices.add(gpuDevice);
                continue;
            }
            throw GpuDeviceSpecificationException.createWithDuplicateValueSpecified(device, devices);
        }
        LOG.info("Allowed GPU devices:" + gpuDevices);
        return gpuDevices;
    }

    private GpuDevice parseGpuDevice(String device, String[] splitByColon, String allowedDevicesStr) throws YarnException {
        try {
            int index = Integer.parseInt(splitByColon[0]);
            int minorNumber = Integer.parseInt(splitByColon[1]);
            return new GpuDevice(index, minorNumber);
        }
        catch (NumberFormatException e) {
            throw GpuDeviceSpecificationException.createWithWrongValueSpecified(device, allowedDevicesStr, e);
        }
    }

    public synchronized void initialize(Configuration config) throws YarnException {
        this.conf = config;
        if (this.isAutoDiscoveryEnabled()) {
            this.numOfErrorExecutionSinceLastSucceed = 0;
            this.lookUpAutoDiscoveryBinary(config);
            try {
                LOG.info("Trying to discover GPU information ...");
                GpuDeviceInformation info = this.getGpuDeviceInformation();
                LOG.info("Discovered GPU information: " + info.toString());
            }
            catch (YarnException e) {
                String msg = "Failed to discover GPU information from system, exception message:" + e.getMessage() + " continue...";
                LOG.warn(msg);
            }
        }
    }

    private void lookUpAutoDiscoveryBinary(Configuration config) throws YarnException {
        File configuredBinaryFile;
        String configuredBinaryPath = config.get("yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables", DEFAULT_BINARY_NAME);
        if (configuredBinaryPath.isEmpty()) {
            configuredBinaryPath = DEFAULT_BINARY_NAME;
        }
        File binaryPath = !(configuredBinaryFile = new File(configuredBinaryPath)).exists() ? this.lookupBinaryInDefaultDirs() : (configuredBinaryFile.isDirectory() ? this.handleConfiguredBinaryPathIsDirectory(configuredBinaryFile) : configuredBinaryFile);
        this.pathOfGpuBinary = binaryPath.getAbsolutePath();
    }

    private File handleConfiguredBinaryPathIsDirectory(File configuredBinaryFile) throws YarnException {
        File binaryPath = new File(configuredBinaryFile, DEFAULT_BINARY_NAME);
        if (!binaryPath.exists()) {
            throw new YarnException("Failed to find GPU discovery executable, please double check yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables setting. The setting points to a directory but no file found in the directory with name:nvidia-smi");
        }
        LOG.warn("Specified path is a directory, use nvidia-smi under the directory, updated path-to-executable:" + binaryPath.getAbsolutePath());
        return binaryPath;
    }

    private File lookupBinaryInDefaultDirs() throws YarnException {
        File lookedUpBinary = this.lookupBinaryInDefaultDirsInternal();
        if (lookedUpBinary == null) {
            throw new YarnException("Failed to find GPU discovery executable, please double check yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables setting. Also tried to find the executable in the default directories: " + DEFAULT_BINARY_SEARCH_DIRS);
        }
        return lookedUpBinary;
    }

    private File lookupBinaryInDefaultDirsInternal() {
        HashSet triedBinaryPaths = Sets.newHashSet();
        for (String dir : DEFAULT_BINARY_SEARCH_DIRS) {
            File binaryPath = new File(dir, DEFAULT_BINARY_NAME);
            if (binaryPath.exists()) {
                return binaryPath;
            }
            triedBinaryPaths.add(binaryPath.getAbsolutePath());
        }
        LOG.warn("Failed to locate GPU device discovery binary, tried paths: " + triedBinaryPaths + "! Please double check the value of config " + "yarn.nodemanager.resource-plugins.gpu.path-to-discovery-executables" + ". Using default binary: " + DEFAULT_BINARY_NAME);
        return null;
    }

    @VisibleForTesting
    Map<String, String> getEnvironmentToRunCommand() {
        return this.environment;
    }

    @VisibleForTesting
    String getPathOfGpuBinary() {
        return this.pathOfGpuBinary;
    }
}

