/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;

public final class DeviceSpecParser {
    private static final String DEVICE_SPEC_REGEX = "(\\w+[0-31])(\\/)(\\d+)(\\:)(\\d+)";
    private static final Pattern DEVICE_PATTERN = Pattern.compile("(\\w+[0-31])(\\/)(\\d+)(\\:)(\\d+)");

    private DeviceSpecParser() {
    }

    static List<FpgaResourceAllocator.FpgaDevice> getDevicesFromString(String type, String devices) throws ResourceHandlerException {
        if (devices.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] deviceList = devices.split(",");
        ArrayList<FpgaResourceAllocator.FpgaDevice> fpgaDevices = new ArrayList<FpgaResourceAllocator.FpgaDevice>();
        for (String deviceSpec : deviceList) {
            Matcher matcher = DEVICE_PATTERN.matcher(deviceSpec);
            if (matcher.matches()) {
                try {
                    String devName = matcher.group(1);
                    int major = Integer.parseInt(matcher.group(3));
                    int minor = Integer.parseInt(matcher.group(5));
                    fpgaDevices.add(new FpgaResourceAllocator.FpgaDevice(type, major, minor, devName));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ResourceHandlerException("Cannot parse major/minor number: " + deviceSpec);
                }
            }
            throw new ResourceHandlerException("Illegal device specification string: " + deviceSpec);
        }
        return fpgaDevices;
    }
}

