/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AoclDiagnosticOutputParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelFpgaOpenclPlugin
implements AbstractFpgaVendorPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(IntelFpgaOpenclPlugin.class);
    private boolean initialized = false;
    private InnerShellExecutor shell;
    private static final String DEFAULT_BINARY_NAME = "aocl";
    private static final String ALTERAOCLSDKROOT_NAME = "ALTERAOCLSDKROOT";
    private Function<String, String> envProvider = System::getenv;
    private String pathToExecutable = null;

    @VisibleForTesting
    void setInnerShellExecutor(InnerShellExecutor shellExecutor) {
        this.shell = shellExecutor;
    }

    @VisibleForTesting
    String getPathToExecutable() {
        return this.pathToExecutable;
    }

    @VisibleForTesting
    void setEnvProvider(Function<String, String> envProvider) {
        this.envProvider = envProvider;
    }

    public IntelFpgaOpenclPlugin() {
        this.shell = new InnerShellExecutor();
    }

    public String getDefaultPathToExecutable() {
        return this.envProvider.apply(ALTERAOCLSDKROOT_NAME);
    }

    @Override
    public boolean initPlugin(Configuration config) {
        if (this.initialized) {
            return true;
        }
        String pluginDefaultBinaryName = DEFAULT_BINARY_NAME;
        String executable = config.get("yarn.nodemanager.resource-plugins.fpga.path-to-discovery-executables", pluginDefaultBinaryName);
        File binaryPath = new File(executable);
        if (!binaryPath.exists()) {
            LOG.warn("Failed to find FPGA discoverer executable configured in yarn.nodemanager.resource-plugins.fpga.path-to-discovery-executables, please check! Try default path");
            executable = pluginDefaultBinaryName;
            String pluginDefaultPreferredPath = this.getDefaultPathToExecutable();
            if (null == pluginDefaultPreferredPath) {
                LOG.warn("Failed to find FPGA discoverer executable from system  environment ALTERAOCLSDKROOT, please check your environment!");
            } else {
                binaryPath = new File(pluginDefaultPreferredPath + "/bin", pluginDefaultBinaryName);
                if (binaryPath.exists()) {
                    executable = binaryPath.getAbsolutePath();
                    LOG.info("Succeed in finding FPGA discoverer executable: " + executable);
                } else {
                    executable = pluginDefaultBinaryName;
                    LOG.warn("Failed to find FPGA discoverer executable in " + pluginDefaultPreferredPath + ", file doesn't exists! Use default binary" + executable);
                }
            }
        }
        this.pathToExecutable = executable;
        if (!this.diagnose(10000)) {
            LOG.warn("Intel FPGA for OpenCL diagnose failed!");
            this.initialized = false;
        } else {
            this.initialized = true;
        }
        return this.initialized;
    }

    @Override
    public List<FpgaResourceAllocator.FpgaDevice> discover(int timeout) {
        List<FpgaResourceAllocator.FpgaDevice> list = new LinkedList<FpgaResourceAllocator.FpgaDevice>();
        String output = this.getDiagnoseInfo(timeout);
        if (null == output) {
            return list;
        }
        list = AoclDiagnosticOutputParser.parseDiagnosticOutput(output, this.shell, this.getFpgaType());
        return list;
    }

    public String getDiagnoseInfo(int timeout) {
        return this.shell.runDiagnose(this.pathToExecutable, timeout);
    }

    @Override
    public boolean diagnose(int timeout) {
        String output = this.getDiagnoseInfo(timeout);
        return null != output && output.contains("DIAGNOSTIC_PASSED");
    }

    @Override
    public String getFpgaType() {
        return "IntelOpenCL";
    }

    @Override
    public String retrieveIPfilePath(String id, String dstDir, Map<Path, List<String>> localizedResources) {
        String ipFilePath = null;
        LOG.info("Got environment: " + id + ", search IP file in localized resources");
        if (null == id || id.isEmpty()) {
            LOG.warn("IP_ID environment is empty, skip downloading");
            return null;
        }
        if (localizedResources != null) {
            Optional<Path> aocxPath = localizedResources.keySet().stream().filter(path -> this.matchesIpid((Path)path, id)).findFirst();
            if (aocxPath.isPresent()) {
                ipFilePath = aocxPath.get().toString();
                LOG.info("Found: {}", (Object)ipFilePath);
            } else {
                LOG.warn("Requested IP file not found");
            }
        } else {
            LOG.warn("Localized resource is null!");
        }
        return ipFilePath;
    }

    private boolean matchesIpid(Path p, String id) {
        return p.getName().toLowerCase().equals(id.toLowerCase() + ".aocx");
    }

    @Override
    public boolean configureIP(String ipPath, FpgaResourceAllocator.FpgaDevice device) {
        String aclName = device.getAliasDevName();
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{this.pathToExecutable, "program", aclName, ipPath});
        try {
            shexec.execute();
            if (0 != shexec.getExitCode()) {
                LOG.error("Device programming failed, aocl output is:");
                LOG.error(shexec.getOutput());
                return false;
            }
            LOG.debug(shexec.getOutput());
            LOG.info("Intel aocl program " + ipPath + " to " + aclName + " successfully");
        }
        catch (IOException e) {
            LOG.error("Intel aocl program " + ipPath + " to " + aclName + " failed!", (Throwable)e);
            LOG.error("Aocl output: " + shexec.getOutput());
            return false;
        }
        return true;
    }

    public static class InnerShellExecutor {
        public String getMajorAndMinorNumber(String devName) {
            String output = null;
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{"stat", "-c", "%t:%T", "/dev/" + devName});
            try {
                LOG.debug("Get FPGA major-minor numbers from /dev/" + devName);
                shexec.execute();
                String[] strs = shexec.getOutput().trim().split(":");
                LOG.debug("stat output:" + shexec.getOutput());
                output = Integer.parseInt(strs[0], 16) + ":" + Integer.parseInt(strs[1], 16);
            }
            catch (IOException e) {
                LOG.warn("Failed to get major-minor number from reading /dev/" + devName);
                LOG.warn("Command output:" + shexec.getOutput() + ", exit code: " + shexec.getExitCode(), (Throwable)e);
            }
            return output;
        }

        public String runDiagnose(String binary, int timeout) {
            String output = null;
            Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(new String[]{binary, "diagnose"}, null, null, (long)timeout);
            try {
                shexec.execute();
            }
            catch (IOException e) {
                String msg = "Failed to execute " + binary + " diagnose, exception message:" + e.getMessage() + ", output:" + output + ", continue ...";
                LOG.warn(msg);
                LOG.debug(shexec.getOutput());
            }
            return shexec.getOutput();
        }
    }
}

