/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;

public class DeviceResourceUpdaterImpl
extends NodeResourceUpdaterPlugin {
    static final Log LOG = LogFactory.getLog(DeviceResourceUpdaterImpl.class);
    private String resourceName;
    private DevicePlugin devicePlugin;

    public DeviceResourceUpdaterImpl(String resourceName, DevicePlugin devicePlugin) {
        this.devicePlugin = devicePlugin;
        this.resourceName = resourceName;
    }

    @Override
    public void updateConfiguredResource(Resource res) throws YarnException {
        LOG.info((Object)(this.resourceName + " plugin update resource "));
        Set<Device> devices = null;
        try {
            devices = this.devicePlugin.getDevices();
        }
        catch (Exception e) {
            throw new YarnException("Exception thrown from plugin's getDevices" + e.getMessage());
        }
        if (null == devices) {
            LOG.warn((Object)(this.resourceName + " plugin failed to discover resource ( null value got)."));
            return;
        }
        res.setResourceValue(this.resourceName, (long)devices.size());
    }
}

